/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import io.vertx.ext.web.impl.Origin;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class OAuth2AuthHandlerImpl
extends HTTPAuthorizationHandler<OAuth2Auth>
implements OAuth2AuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthHandlerImpl.class);
    private final VertxContextPRNG prng;
    private final String host;
    private final String callbackPath;
    private final MessageDigest sha256;
    private Route callback;
    private JsonObject extraParams;
    private final List<String> scopes = new ArrayList<String>();
    private String prompt;
    private int pkce = -1;
    private boolean bearerOnly = true;

    public OAuth2AuthHandlerImpl(Vertx vertx, OAuth2Auth authProvider, String callbackURL) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER);
        this.prng = VertxContextPRNG.current((Vertx)vertx);
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get instance of SHA-256 MessageDigest", e);
        }
        if (callbackURL != null) {
            Origin origin = Origin.parse(callbackURL);
            this.host = origin.toString();
            this.callbackPath = origin.resource();
        } else {
            this.host = null;
            this.callbackPath = null;
        }
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        this.parseAuthorization(context, !this.bearerOnly, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            String token = (String)parseAuthorization.result();
            if (token == null) {
                if (this.bearerOnly || this.callback == null) {
                    handler.handle((Object)Future.failedFuture((String)"callback route is not configured."));
                    return;
                }
                if (context.request().method() == HttpMethod.GET && context.normalizedPath().equals(this.callback.getPath())) {
                    LOG.warn((Object)"The callback route is shaded by the OAuth2AuthHandler, ensure the callback route is added BEFORE the OAuth2AuthHandler route!");
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(500, "Infinite redirect loop [oauth2 callback]")));
                } else {
                    if (context.request().method() != HttpMethod.GET) {
                        LOG.error((Object)"OAuth2 redirect attempt to non GET resource");
                        context.fail(405, new IllegalStateException("OAuth2 redirect attempt to non GET resource"));
                        return;
                    }
                    String redirectUri = context.request().uri();
                    String state = null;
                    String codeVerifier = null;
                    if (context.session() == null) {
                        if (this.pkce > 0) {
                            context.fail(500, new IllegalStateException("OAuth2 PKCE requires a session to be present"));
                            return;
                        }
                    } else {
                        context.session().put("redirect_uri", context.request().uri());
                        state = this.prng.nextString(6);
                        context.session().put("state", state);
                        if (this.pkce > 0) {
                            codeVerifier = this.prng.nextString(this.pkce);
                            context.session().put("pkce", codeVerifier);
                        }
                    }
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(302, this.authURI(redirectUri, state, codeVerifier))));
                }
            } else {
                handler.handle((Object)Future.succeededFuture((Object)new TokenCredentials(token).setScopes(this.scopes)));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String authURI(String redirectURL, String state, String codeVerifier) {
        JsonObject config = new JsonObject().put("state", (Object)(state != null ? state : redirectURL));
        if (this.host != null) {
            config.put("redirect_uri", (Object)(this.host + this.callback.getPath()));
        }
        if (this.scopes.size() > 0) {
            config.put("scopes", this.scopes);
        }
        if (this.prompt != null) {
            config.put("prompt", (Object)this.prompt);
        }
        if (codeVerifier != null) {
            MessageDigest messageDigest = this.sha256;
            synchronized (messageDigest) {
                this.sha256.update(codeVerifier.getBytes(StandardCharsets.US_ASCII));
                config.put("code_challenge", (Object)this.sha256.digest()).put("code_challenge_method", (Object)"S256");
            }
        }
        if (this.extraParams != null) {
            config.mergeIn(this.extraParams);
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(config);
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler withScope(String scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public OAuth2AuthHandler prompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    @Override
    public OAuth2AuthHandler pkceVerifierLength(int length) {
        if (length >= 0 && (length < 43 || length > 128)) {
            throw new IllegalArgumentException("Length must be between 34 and 128");
        }
        this.pkce = length;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        if (this.callbackPath != null && !"".equals(this.callbackPath) && !this.callbackPath.equals(route.getPath())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"route path changed to match callback URL");
            }
            route.path(this.callbackPath);
        }
        route.method(HttpMethod.GET);
        route.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String resource;
            String error = ctx.request().getParam("error");
            if (error != null) {
                int errorCode;
                switch (error) {
                    case "invalid_token": {
                        errorCode = 401;
                        break;
                    }
                    case "insufficient_scope": {
                        errorCode = 403;
                        break;
                    }
                    default: {
                        errorCode = 400;
                    }
                }
                String errorDescription = ctx.request().getParam("error_description");
                if (errorDescription != null) {
                    ctx.fail(errorCode, new IllegalStateException(error + ": " + errorDescription));
                } else {
                    ctx.fail(errorCode, new IllegalStateException(error));
                }
                return;
            }
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400, new IllegalStateException("Missing code parameter"));
                return;
            }
            Oauth2Credentials credentials = new Oauth2Credentials().setCode(code).setExtra(this.extraParams);
            String state = ctx.request().getParam("state");
            if (state == null) {
                ctx.fail(400, new IllegalStateException("Missing IdP state parameter to the callback endpoint"));
                return;
            }
            if (ctx.session() != null) {
                String ctxState = (String)ctx.session().remove("state");
                if (!state.equals(ctxState)) {
                    ctx.fail(401, new IllegalStateException("Invalid oauth2 state"));
                    return;
                }
                String codeVerifier = (String)ctx.session().remove("pkce");
                if (codeVerifier != null) {
                    JsonObject extras = credentials.getExtra();
                    if (extras != null) {
                        credentials.setExtra(new JsonObject().mergeIn(extras).put("code_verifier", (Object)codeVerifier));
                    } else {
                        credentials.setExtra(new JsonObject().put("code_verifier", (Object)codeVerifier));
                    }
                }
                resource = (String)ctx.session().get("redirect_uri");
            } else {
                resource = state;
            }
            if (this.host == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Cannot compute: 'redirect_uri' variable. OAuth2AuthHandler was created without a origin/callback URL.");
                }
            } else {
                credentials.setRedirectUri(this.host + route.getPath());
            }
            ((OAuth2Auth)this.authProvider).authenticate((Credentials)credentials, res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    String location;
                    ctx.setUser((User)res.result());
                    Session session = ctx.session();
                    String string = location = resource != null ? resource : "/";
                    if (session != null) {
                        session.regenerateId();
                    } else if (location.length() != 0 && location.charAt(0) == '/') {
                        ctx.reroute(location);
                        return;
                    }
                    ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)location).setStatusCode(302).end("Redirecting to " + location + ".");
                }
            });
        }));
        this.bearerOnly = false;
        this.callback = route;
        return this;
    }
}

