/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.impl.SessionHandlerImpl;
import io.vertx.ext.web.sstore.SessionStore;

@VertxGen
public interface SessionHandler
extends Handler<RoutingContext> {
    public static final String DEFAULT_SESSION_COOKIE_NAME = "vertx-web.session";
    public static final String DEFAULT_SESSION_COOKIE_PATH = "/";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    public static final boolean DEFAULT_NAG_HTTPS = true;
    public static final boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = false;
    public static final boolean DEFAULT_COOKIE_SECURE_FLAG = false;
    public static final int DEFAULT_SESSIONID_MIN_LENGTH = 16;
    public static final boolean DEFAULT_LAZY_SESSION = false;

    public static SessionHandler create(SessionStore sessionStore) {
        return new SessionHandlerImpl(sessionStore);
    }

    @Fluent
    public SessionHandler setSessionTimeout(long var1);

    @Fluent
    public SessionHandler setNagHttps(boolean var1);

    @Fluent
    public SessionHandler setCookieSecureFlag(boolean var1);

    @Fluent
    public SessionHandler setCookieHttpOnlyFlag(boolean var1);

    @Fluent
    public SessionHandler setSessionCookieName(String var1);

    @Fluent
    public SessionHandler setSessionCookiePath(String var1);

    @Fluent
    public SessionHandler setMinLength(int var1);

    @Fluent
    public SessionHandler setCookieSameSite(CookieSameSite var1);

    @Fluent
    public SessionHandler setLazySession(boolean var1);

    @Fluent
    public SessionHandler setCookieMaxAge(long var1);

    @Fluent
    @Deprecated
    public SessionHandler setAuthProvider(AuthProvider var1);

    @Fluent
    public SessionHandler flush(RoutingContext var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public SessionHandler flush(RoutingContext var1, boolean var2, Handler<AsyncResult<Void>> var3);

    default public Future<Void> flush(RoutingContext ctx) {
        PromiseInternal promise = ((VertxInternal)ctx.vertx()).promise();
        this.flush(ctx, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    default public Future<Void> flush(RoutingContext ctx, boolean ignoreStatus) {
        PromiseInternal promise = ((VertxInternal)ctx.vertx()).promise();
        this.flush(ctx, ignoreStatus, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public SessionHandler setCookieless(boolean var1);

    public Session newSession(RoutingContext var1);
}

