/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.impl.UserHolder;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SessionInternal;

public class SessionHandlerImpl
implements SessionHandler {
    public static final String SESSION_USER_HOLDER_KEY = "__vertx.userHolder";
    public static final String SESSION_FLUSHED_KEY = "__vertx.session-flushed";
    public static final String SESSION_STOREUSER_KEY = "__vertx.session-storeuser";
    private static final Logger LOG = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName = "vertx-web.session";
    private String sessionCookiePath = "/";
    private long sessionTimeout = 1800000L;
    private boolean nagHttps = true;
    private boolean sessionCookieSecure = false;
    private boolean sessionCookieHttpOnly = false;
    private int minLength = 16;
    private boolean lazySession = false;
    private long cookieMaxAge = -1L;
    private boolean cookieless;
    private CookieSameSite cookieSameSite;

    public SessionHandlerImpl(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    @Override
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    @Override
    public SessionHandler setSessionCookiePath(String sessionCookiePath) {
        this.sessionCookiePath = sessionCookiePath;
        return this;
    }

    @Override
    public SessionHandler setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    @Override
    public SessionHandler setCookieSameSite(CookieSameSite policy) {
        this.cookieSameSite = policy;
        return this;
    }

    @Override
    public SessionHandler setLazySession(boolean lazySession) {
        this.lazySession = lazySession;
        return this;
    }

    @Override
    public SessionHandler setCookieMaxAge(long cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
        return this;
    }

    @Override
    @Deprecated
    public SessionHandler setAuthProvider(AuthProvider authProvider) {
        return this;
    }

    @Override
    public SessionHandler setCookieless(boolean cookieless) {
        this.cookieless = cookieless;
        return this;
    }

    @Override
    public SessionHandler flush(RoutingContext context, Handler<AsyncResult<Void>> handler) {
        return this.flush(context, false, false, handler);
    }

    @Override
    public SessionHandler flush(RoutingContext context, boolean ignoreStatus, Handler<AsyncResult<Void>> handler) {
        return this.flush(context, false, ignoreStatus, handler);
    }

    private void setCookieProperties(Cookie cookie) {
        cookie.setPath(this.sessionCookiePath);
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        cookie.setSameSite(this.cookieSameSite);
        if (this.cookieMaxAge >= 0L) {
            cookie.setMaxAge(this.cookieMaxAge);
        }
    }

    private SessionHandler flush(RoutingContext context, boolean skipCrc, boolean ignoreStatus, Handler<AsyncResult<Void>> handler) {
        boolean sessionUsed = context.isSessionAccessed();
        Session session = context.session();
        if (!session.isDestroyed()) {
            int currentStatusCode = context.response().getStatusCode();
            if (ignoreStatus || currentStatusCode >= 200 && currentStatusCode < 400) {
                Boolean storeUser = (Boolean)context.get(SESSION_STOREUSER_KEY);
                if (storeUser != null && storeUser.booleanValue() && context.user() != null) {
                    session.put(SESSION_USER_HOLDER_KEY, new UserHolder(context));
                }
                if (session.isRegenerated()) {
                    if (this.cookieless) {
                        session.setAccessed();
                    } else {
                        Cookie cookie = this.sessionCookie(context, session);
                        session.setAccessed();
                        cookie.setValue(session.value());
                        this.setCookieProperties(cookie);
                    }
                    this.sessionStore.delete(session.oldId(), (Handler<AsyncResult<Void>>)((Handler)delete -> {
                        if (delete.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)delete.cause()));
                        } else {
                            this.sessionStore.put(session, (Handler<AsyncResult<Void>>)((Handler)put -> {
                                if (put.failed()) {
                                    handler.handle((Object)Future.failedFuture((Throwable)put.cause()));
                                } else {
                                    context.put(SESSION_FLUSHED_KEY, true);
                                    if (session instanceof SessionInternal) {
                                        ((SessionInternal)((Object)session)).flushed(skipCrc);
                                    }
                                    handler.handle((Object)Future.succeededFuture());
                                }
                            }));
                        }
                    }));
                } else if (!this.lazySession || sessionUsed) {
                    if (!this.cookieless) {
                        this.sessionCookie(context, session);
                    }
                    session.setAccessed();
                    this.sessionStore.put(session, (Handler<AsyncResult<Void>>)((Handler)put -> {
                        if (put.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)put.cause()));
                        } else {
                            context.put(SESSION_FLUSHED_KEY, true);
                            if (session instanceof SessionInternal) {
                                ((SessionInternal)((Object)session)).flushed(skipCrc);
                            }
                            handler.handle((Object)Future.succeededFuture());
                        }
                    }));
                }
            }
        } else {
            if (!this.cookieless) {
                context.removeCookie(this.sessionCookieName);
            }
            if (session.isRegenerated()) {
                this.sessionStore.delete(session.oldId(), (Handler<AsyncResult<Void>>)((Handler)delete -> {
                    if (delete.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)delete.cause()));
                    } else {
                        this.sessionStore.delete(session.id(), (Handler<AsyncResult<Void>>)((Handler)delete2 -> {
                            if (delete2.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)delete2.cause()));
                            } else {
                                context.put(SESSION_FLUSHED_KEY, true);
                                handler.handle((Object)Future.succeededFuture());
                            }
                        }));
                    }
                }));
            } else {
                this.sessionStore.delete(session.id(), (Handler<AsyncResult<Void>>)((Handler)delete -> {
                    if (delete.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)delete.cause()));
                    } else {
                        context.put(SESSION_FLUSHED_KEY, true);
                        handler.handle((Object)Future.succeededFuture());
                    }
                }));
            }
        }
        return this;
    }

    public void handle(RoutingContext context) {
        String sessionID;
        String uri;
        HttpServerRequest request = context.request();
        if (this.nagHttps && LOG.isDebugEnabled() && !(uri = request.absoluteURI()).startsWith("https:")) {
            LOG.debug((Object)("Using session cookies without https could make you susceptible to session hijacking: " + uri));
        }
        if ((sessionID = this.getSessionId(context)) != null && sessionID.length() > this.minLength) {
            boolean parseEnded = request.isEnded();
            if (!parseEnded) {
                request.pause();
            }
            this.getSession(context.vertx(), sessionID, (Handler<AsyncResult<Session>>)((Handler)res -> {
                if (!parseEnded && !request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
                    request.resume();
                }
                if (res.succeeded()) {
                    Session session = (Session)res.result();
                    if (session != null) {
                        context.setSession(session);
                        UserHolder holder = (UserHolder)session.get(SESSION_USER_HOLDER_KEY);
                        if (holder != null) {
                            holder.refresh(context);
                        } else {
                            context.put(SESSION_STOREUSER_KEY, true);
                        }
                        this.addStoreSessionHandler(context);
                    } else {
                        this.createNewSession(context);
                    }
                } else {
                    context.fail(res.cause());
                }
                context.next();
            }));
        } else {
            this.createNewSession(context);
            context.next();
        }
    }

    @Override
    public Session newSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        context.setSession(session);
        if (!this.cookieless) {
            context.removeCookie(this.sessionCookieName, false);
        }
        context.put(SESSION_STOREUSER_KEY, true);
        this.flush(context, true, true, (Handler<AsyncResult<Void>>)((Handler)flush -> {
            if (flush.failed()) {
                LOG.warn((Object)"Failed to flush the session to the underlying store", flush.cause());
            }
        }));
        return session;
    }

    @Override
    public Future<Void> setUser(RoutingContext context, User user) {
        if (!this.cookieless) {
            context.removeCookie(this.sessionCookieName, false);
        }
        context.setUser(user);
        context.put(SESSION_STOREUSER_KEY, true);
        Promise promise = Promise.promise();
        this.flush(context, true, true, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    private String getSessionId(RoutingContext context) {
        if (this.cookieless) {
            String path = context.normalizedPath();
            int s = -1;
            int e = -1;
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) == '(') {
                    s = i + 1;
                    continue;
                }
                if (path.charAt(i) != ')' || s == -1) continue;
                e = i;
                break;
            }
            if (s != -1 && e != -1 && s < e) {
                return path.substring(s, e);
            }
        } else {
            Cookie cookie = context.getCookie(this.sessionCookieName);
            if (cookie != null) {
                return cookie.getValue();
            }
        }
        return null;
    }

    private void getSession(Vertx vertx, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.doGetSession(vertx, System.currentTimeMillis(), sessionID, resultHandler);
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.sessionStore.get(sessionID, (Handler<AsyncResult<Session>>)((Handler)res -> {
            long retryTimeout;
            if (res.succeeded() && res.result() == null && (retryTimeout = this.sessionStore.retryTimeout()) > 0L && System.currentTimeMillis() - startTime < retryTimeout) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.handle(res);
        }));
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler((Handler<Void>)((Handler)v -> {
            Boolean flushed = (Boolean)context.get(SESSION_FLUSHED_KEY);
            if (flushed == null || !flushed.booleanValue()) {
                this.flush(context, true, false, (Handler<AsyncResult<Void>>)((Handler)flush -> {
                    if (flush.failed()) {
                        LOG.warn((Object)"Failed to flush the session to the underlying store", flush.cause());
                    }
                }));
            }
        }));
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        context.setSession(session);
        if (!this.cookieless) {
            context.removeCookie(this.sessionCookieName, false);
        }
        context.put(SESSION_STOREUSER_KEY, true);
        this.addStoreSessionHandler(context);
    }

    private Cookie sessionCookie(RoutingContext context, Session session) {
        Cookie cookie = context.getCookie(this.sessionCookieName);
        if (cookie != null) {
            return cookie;
        }
        cookie = Cookie.cookie((String)this.sessionCookieName, (String)session.value());
        this.setCookieProperties(cookie);
        context.addCookie(cookie);
        return cookie;
    }
}

