/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import java.util.Arrays;
import java.util.function.Consumer;

final class SparseArray<H> {
    private Object[] elements;

    SparseArray() {
    }

    void forEachInReverseOrder(Consumer<H> action) {
        if (this.elements != null) {
            for (int i = this.elements.length - 1; i >= 0; --i) {
                Object element = this.elements[i];
                if (element == null) continue;
                action.accept(element);
            }
        }
    }

    void clear() {
        if (this.elements != null) {
            Arrays.fill(this.elements, null);
        }
    }

    void put(int seq, H handler) {
        if (this.elements == null || seq >= this.elements.length) {
            this.resizeToFit(seq);
        }
        this.elements[seq] = handler;
    }

    private void resizeToFit(int seq) {
        int existingLength;
        int n = existingLength = this.elements == null ? 0 : this.elements.length;
        if (existingLength != 0) {
            int targetLength = Math.max(seq + 1, existingLength * 2);
            Object[] newArray = new Object[targetLength];
            System.arraycopy(this.elements, 0, newArray, 0, existingLength);
            this.elements = newArray;
        } else {
            int targetLength = Math.max(seq + 1, 2);
            this.elements = new Object[targetLength];
        }
    }

    H remove(int handlerID) {
        if (handlerID < this.elements.length) {
            Object removed = this.elements[handlerID];
            this.elements[handlerID] = null;
            return (H)removed;
        }
        return null;
    }
}

