/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.webauthn.WebAuthn;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.WebAuthnHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.impl.Origin;

public class WebAuthnHandlerImpl
extends AuthenticationHandlerImpl<WebAuthn>
implements WebAuthnHandler {
    private Route register = null;
    private Route login = null;
    private Route response = null;
    private String origin;
    private String domain;

    public WebAuthnHandlerImpl(WebAuthn webAuthN) {
        super(webAuthN);
    }

    private static boolean containsRequiredString(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            Object s = json.getValue(key);
            return s instanceof String && !"".equals(s);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsOptionalString(JsonObject json, String key) {
        try {
            if (json == null) {
                return true;
            }
            if (!json.containsKey(key)) {
                return true;
            }
            Object s = json.getValue(key);
            return s instanceof String;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsRequiredObject(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            JsonObject s = json.getJsonObject(key);
            return s != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean matchesRoute(RoutingContext ctx, Route route) {
        if (route != null) {
            return ctx.request().method() == HttpMethod.POST && ctx.normalizedPath().equals(route.getPath());
        }
        return false;
    }

    @Override
    public void authenticate(RoutingContext ctx, Handler<AsyncResult<User>> handler) {
        if (this.response == null) {
            handler.handle((Object)Future.failedFuture((Throwable)new HttpException(500, (Throwable)new IllegalStateException("No callback mounted!"))));
            return;
        }
        if (WebAuthnHandlerImpl.matchesRoute(ctx, this.response)) {
            handler.handle((Object)Future.failedFuture((Throwable)new HttpException(500, (Throwable)new IllegalStateException("The callback route is shaded by the WebAuthNAuthHandler, ensure the callback route is added BEFORE the WebAuthNAuthHandler route!"))));
            return;
        }
        if (WebAuthnHandlerImpl.matchesRoute(ctx, this.register)) {
            handler.handle((Object)Future.failedFuture((Throwable)new HttpException(500, (Throwable)new IllegalStateException("The register callback route is shaded by the WebAuthNAuthHandler, ensure the callback route is added BEFORE the WebAuthNAuthHandler route!"))));
            return;
        }
        if (WebAuthnHandlerImpl.matchesRoute(ctx, this.login)) {
            handler.handle((Object)Future.failedFuture((Throwable)new HttpException(500, (Throwable)new IllegalStateException("The login callback route is shaded by the WebAuthNAuthHandler, ensure the callback route is added BEFORE the WebAuthNAuthHandler route!"))));
            return;
        }
        if (ctx.user() == null) {
            handler.handle((Object)Future.failedFuture((Throwable)new HttpException(401)));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)ctx.user()));
        }
    }

    @Override
    public WebAuthnHandler setupCredentialsCreateCallback(Route route) {
        this.register = route.method(HttpMethod.POST).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnRegister = ctx.getBodyAsJson();
                Session session = ctx.session();
                if (!WebAuthnHandlerImpl.containsRequiredString(webauthnRegister, "name")) {
                    ctx.fail(400, new IllegalArgumentException("missing 'name' field from request json"));
                } else {
                    if (session == null) {
                        ctx.fail(500, new IllegalStateException("No session or session handler is missing."));
                        return;
                    }
                    ((WebAuthn)this.authProvider).createCredentialsOptions(webauthnRegister, createCredentialsOptions -> {
                        if (createCredentialsOptions.failed()) {
                            ctx.fail(createCredentialsOptions.cause());
                            return;
                        }
                        JsonObject credentialsOptions = (JsonObject)createCredentialsOptions.result();
                        ctx.session().put("challenge", credentialsOptions.getString("challenge")).put("username", webauthnRegister.getString("name"));
                        ctx.json(credentialsOptions);
                    });
                }
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400, e);
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
        return this;
    }

    @Override
    public WebAuthnHandler setupCredentialsGetCallback(Route route) {
        this.login = route.method(HttpMethod.POST).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnLogin = ctx.getBodyAsJson();
                Session session = ctx.session();
                if (!WebAuthnHandlerImpl.containsRequiredString(webauthnLogin, "name")) {
                    ctx.fail(400, new IllegalArgumentException("Request missing 'name' field"));
                    return;
                }
                if (session == null) {
                    ctx.fail(500, new IllegalStateException("No session or session handler is missing."));
                    return;
                }
                String username = webauthnLogin.getString("name");
                ((WebAuthn)this.authProvider).getCredentialsOptions(username, generateServerGetAssertion -> {
                    if (generateServerGetAssertion.failed()) {
                        ctx.fail(generateServerGetAssertion.cause());
                        return;
                    }
                    JsonObject getAssertion = (JsonObject)generateServerGetAssertion.result();
                    session.put("challenge", getAssertion.getString("challenge")).put("username", username);
                    ctx.json(getAssertion);
                });
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400, e);
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
        return this;
    }

    @Override
    public WebAuthnHandler setupCallback(Route route) {
        this.response = route.method(HttpMethod.POST).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnResp = ctx.getBodyAsJson();
                if (!(WebAuthnHandlerImpl.containsRequiredString(webauthnResp, "id") && WebAuthnHandlerImpl.containsRequiredString(webauthnResp, "rawId") && WebAuthnHandlerImpl.containsRequiredObject(webauthnResp, "response") && WebAuthnHandlerImpl.containsOptionalString(webauthnResp.getJsonObject("response"), "userHandle") && WebAuthnHandlerImpl.containsRequiredString(webauthnResp, "type") && "public-key".equals(webauthnResp.getString("type")))) {
                    ctx.fail(400, new IllegalArgumentException("Response missing one or more of id/rawId/response[.userHandle]/type fields, or type is not public-key"));
                    return;
                }
                Session session = ctx.session();
                if (ctx.session() == null) {
                    ctx.fail(500, new IllegalStateException("No session or session handler is missing."));
                    return;
                }
                ((WebAuthn)this.authProvider).authenticate((Credentials)new WebAuthnCredentials().setOrigin(this.origin).setDomain(this.domain).setChallenge((String)session.get("challenge")).setUsername((String)session.get("username")).setWebauthn(webauthnResp), authenticate -> {
                    session.remove("challenge");
                    if (authenticate.succeeded()) {
                        User user = (User)authenticate.result();
                        ctx.setUser(user);
                        session.regenerateId();
                        ctx.response().end();
                    } else {
                        ctx.fail(authenticate.cause());
                    }
                });
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400, e);
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
        return this;
    }

    @Override
    public WebAuthnHandler setOrigin(String origin) {
        if (origin != null) {
            Origin o = Origin.parse(origin);
            this.origin = o.encode();
            this.domain = o.host();
        } else {
            this.origin = null;
            this.domain = null;
        }
        return this;
    }
}

