/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.CSPHandler;
import org.junit.Test;

public class CSPHandlerTest
extends WebTestBase {
    @Test
    public void testCSPDefault() throws Exception {
        this.router.route().handler((Handler)CSPHandler.create());
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.assertEquals("default-src 'self'", resp.getHeader("Content-Security-Policy")), 200, "OK", null);
    }

    @Test
    public void testCSPCustom() throws Exception {
        this.router.route().handler((Handler)CSPHandler.create().addDirective("default-src", "*.trusted.com"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.assertEquals("default-src 'self' *.trusted.com", resp.getHeader("Content-Security-Policy")), 200, "OK", null);
    }

    @Test
    public void testCSPMulti() throws Exception {
        this.router.route().handler((Handler)CSPHandler.create().addDirective("img-src", "*").addDirective("media-src", "media1.com media2.com").addDirective("script-src", "userscripts.example.com"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String h = resp.getHeader("Content-Security-Policy");
            this.assertEquals("default-src 'self'; img-src *; media-src media1.com media2.com; script-src userscripts.example.com", h);
        }, 200, "OK", null);
    }

    @Test
    public void testCSPReporting() throws Exception {
        this.router.route().handler((Handler)CSPHandler.create().setReportOnly(true).addDirective("report-uri", "http://reportcollector.example.com/collector.cgi"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String h = resp.getHeader("Content-Security-Policy-Report-Only");
            this.assertEquals("default-src 'self'; report-uri http://reportcollector.example.com/collector.cgi", h);
        }, 200, "OK", null);
    }

    @Test
    public void testCSPReportingWithoutUri() throws Exception {
        this.router.route().handler((Handler)CSPHandler.create().setReportOnly(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", 500, "Internal Server Error");
    }
}

