/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.handler.AuthHandlerTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.SimpleAuthenticationHandler;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public class CustomAuthHandlerTest
extends AuthHandlerTestBase {
    @Override
    protected AuthenticationHandler createAuthHandler(AuthenticationProvider authProvider) {
        return this.newAuthHandler(authProvider, null);
    }

    private AuthenticationHandler newAuthHandler(AuthenticationProvider authProvider, Handler<Throwable> exceptionProcessor) {
        return SimpleAuthenticationHandler.create().authenticate(ctx -> {
            Promise promise = Promise.promise();
            authProvider.authenticate((Credentials)new UsernamePasswordCredentials("user", "pass"), authn -> {
                if (authn.failed()) {
                    if (exceptionProcessor != null) {
                        exceptionProcessor.handle((Object)authn.cause());
                    }
                    promise.fail(authn.cause());
                } else {
                    promise.complete(authn.result());
                }
            });
            return promise.future();
        });
    }

    @Test
    public void testCredentialsValidationErrorPropagation() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        IllegalArgumentException rootCause = new IllegalArgumentException("validation of credentials failed");
        AuthenticationProvider authProvider = (AuthenticationProvider)Mockito.mock(AuthenticationProvider.class);
        ((AuthenticationProvider)Mockito.doAnswer(invocation -> {
            Handler resultHandler = (Handler)invocation.getArgument(1);
            resultHandler.handle((Object)Future.failedFuture((Throwable)rootCause));
            return null;
        }).when((Object)authProvider)).authenticate((Credentials)Mockito.any(Credentials.class), (Handler)Mockito.any(Handler.class));
        this.router.route("/protected/*").handler((Handler)this.newAuthHandler(authProvider, (Handler<Throwable>)((Handler)exception -> {
            this.assertTrue(exception instanceof IllegalArgumentException);
            this.assertEquals(rootCause, exception);
        })));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", 401, "Unauthorized");
    }

    @Test
    public void testHttpStatusExceptionFailurePropagation() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        HttpException rootCause = new HttpException(499, "bla");
        AuthenticationProvider authProvider = (AuthenticationProvider)Mockito.mock(AuthenticationProvider.class);
        ((AuthenticationProvider)Mockito.doAnswer(arg_0 -> CustomAuthHandlerTest.lambda$testHttpStatusExceptionFailurePropagation$6((Throwable)rootCause, arg_0)).when((Object)authProvider)).authenticate((Credentials)Mockito.any(Credentials.class), (Handler)Mockito.any(Handler.class));
        this.router.route("/protected/*").handler((Handler)this.newAuthHandler(authProvider, (Handler<Throwable>)((Handler)arg_0 -> this.lambda$testHttpStatusExceptionFailurePropagation$7((Throwable)rootCause, arg_0))));
        this.router.route("/protected/somepage").handler(handler);
        this.router.errorHandler(499, rc -> rc.response().setStatusCode(((HttpException)rc.failure()).getStatusCode()).setStatusMessage(((HttpException)rc.failure()).getPayload()).end());
        this.testRequest(HttpMethod.GET, "/protected/somepage", 499, "bla");
    }

    private /* synthetic */ void lambda$testHttpStatusExceptionFailurePropagation$7(Throwable rootCause, Throwable exception) {
        this.assertTrue(exception instanceof HttpException);
        this.assertEquals(rootCause, exception);
    }

    private static /* synthetic */ Object lambda$testHttpStatusExceptionFailurePropagation$6(Throwable rootCause, InvocationOnMock invocation) throws Throwable {
        Handler resultHandler = (Handler)invocation.getArgument(1);
        resultHandler.handle((Object)Future.failedFuture((Throwable)rootCause));
        return null;
    }
}

