/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.MethodOverrideHandler;
import org.junit.Test;

public class MethodOverrideHandlerTest
extends WebTestBase {
    private MethodOverrideHandler handlerWithSafeDowngrading = MethodOverrideHandler.create();
    private MethodOverrideHandler handlerWithoutSafeDowngrading = MethodOverrideHandler.create((boolean)false);

    @Test
    public void testFoo() {
        this.assertTrue("It is true", true);
    }

    @Test
    public void testOverridingSameMethod() throws Exception {
        this.testOverride(true, HttpMethod.GET, HttpMethod.GET, HttpMethod.GET);
    }

    @Test
    public void testSafeOverridingToIdempotent() throws Exception {
        this.testOverride(true, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.DELETE);
    }

    @Test
    public void testSafeOverridingToSafeFromNonIdempotent() throws Exception {
        this.testOverride(true, HttpMethod.POST, HttpMethod.GET, HttpMethod.GET);
    }

    @Test
    public void testSafeOverridingFromNonSafe() throws Exception {
        this.testOverride(true, HttpMethod.POST, HttpMethod.GET, HttpMethod.GET);
    }

    @Test
    public void testSafeOverridingFromIdempotentShouldFail() throws Exception {
        this.testOverride(true, HttpMethod.GET, HttpMethod.POST, HttpMethod.GET);
    }

    @Test
    public void testUnsafeOverridingFromIdempotent() throws Exception {
        this.testOverride(false, HttpMethod.GET, HttpMethod.POST, HttpMethod.POST);
    }

    private void testOverride(boolean safe, HttpMethod overridedMethod, HttpMethod overridingMethod, HttpMethod expectedMethod) throws Exception {
        MethodOverrideHandler overridingHandler = safe ? this.handlerWithSafeDowngrading : this.handlerWithoutSafeDowngrading;
        this.router.route().handler((Handler)overridingHandler);
        this.router.route().handler(rc -> {
            this.assertEquals(expectedMethod.name(), rc.request().method().name());
            rc.response().end();
        });
        this.testRequestWithMethodOverride(overridedMethod, overridingMethod);
    }

    private void testRequestWithMethodOverride(HttpMethod overridedMethod, HttpMethod overridingMethod) throws Exception {
        this.testRequest(overridedMethod, "/", (HttpClientRequest req) -> req.putHeader("x-http-method-override", overridingMethod.toString()), 200, "OK", null);
    }
}

