/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class SockJSProtocolTest {
    private static final Logger log = LoggerFactory.getLogger(SockJSProtocolTest.class);
    private static Vertx vertx;
    private static HttpServer server;

    @BeforeClass
    public static void before() throws Exception {
        vertx = Vertx.vertx();
        server = vertx.createHttpServer();
        Router router = Router.router((Vertx)vertx);
        SockJSProtocolTest.installTestApplications(router, vertx);
        server.requestHandler((Handler)router).listen(8081);
    }

    @AfterClass
    public static void after() {
        server.close();
        vertx.close();
    }

    public static void installTestApplications(Router router, final Vertx vertx) {
        router.mountSubRouter("/echo", SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.handler(arg_0 -> ((SockJSSocket)sock).write(arg_0))));
        router.mountSubRouter("/close", SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> vertx.setTimer(10L, id -> sock.close(3000, "Go away!"))));
        router.mountSubRouter("/disabled_websocket_echo", SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096).addDisabledTransport("WEBSOCKET")).socketHandler(sock -> sock.handler(arg_0 -> ((SockJSSocket)sock).write(arg_0))));
        router.mountSubRouter("/ticker", SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> {
            long timerID = vertx.setPeriodic(1000L, tid -> sock.write(Buffer.buffer((String)"tick!")));
            sock.endHandler(v -> vertx.cancelTimer(timerID));
        }));
        router.mountSubRouter("/amplify", SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.handler(data -> {
            String str = data.toString();
            int n = Integer.valueOf(str);
            if (n < 0 || n > 19) {
                n = 1;
            }
            int num = (int)Math.pow(2.0, n);
            Buffer buff = Buffer.buffer((int)num);
            for (int i = 0; i < num; ++i) {
                buff.appendByte((byte)120);
            }
            sock.write(buff);
        })));
        router.mountSubRouter("/broadcast", SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096).setRegisterWriteHandler(true)).socketHandler((Handler)new Handler<SockJSSocket>(){
            Set<String> connections = new HashSet<String>();

            public void handle(SockJSSocket sock) {
                String writeHandlerID = sock.writeHandlerID();
                if (writeHandlerID != null) {
                    this.connections.add(writeHandlerID);
                    sock.handler(buffer -> {
                        for (String actorID : this.connections) {
                            vertx.eventBus().publish(actorID, buffer);
                        }
                    });
                    sock.endHandler(v -> this.connections.remove(writeHandlerID));
                }
            }
        }));
        SockJSHandlerOptions options = new SockJSHandlerOptions().setMaxBytesStreaming(4096).setInsertJSESSIONID(true);
        SockJSHandler sockJSHandler = SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)options);
        Router socketHandler = sockJSHandler.socketHandler(sock -> sock.handler(arg_0 -> ((SockJSSocket)sock).write(arg_0)));
        router.mountSubRouter("/cookie_needed_echo", socketHandler);
    }

    @Test
    public void testProtocol() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        Process p = Runtime.getRuntime().exec("python pythonversion.py", null, new File("src/test"));
        int res = p.waitFor();
        if (res == 0) {
            File dir = new File("src/test/sockjs-protocol");
            p = Runtime.getRuntime().exec("python sockjs-protocol.py", new String[]{"SOCKJS_URL=http://localhost:8081"}, dir);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String line;
                while ((line = input.readLine()) != null) {
                    log.info((Object)line);
                }
            }
            res = p.waitFor();
            Assert.assertEquals((String)"Protocol tests failed", (long)0L, (long)res);
        } else {
            System.err.println("*** No Python runtime sockjs tests will be skiped!!!");
        }
    }

    @Test
    public void testQuirks() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        Process p = Runtime.getRuntime().exec("python pythonversion.py", null, new File("src/test"));
        int res = p.waitFor();
        if (res == 0) {
            File dir = new File("src/test/sockjs-protocol");
            p = Runtime.getRuntime().exec("python http-quirks.py", new String[]{"SOCKJS_URL=http://localhost:8081"}, dir);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String line;
                while ((line = input.readLine()) != null) {
                    log.info((Object)line);
                }
            }
            res = p.waitFor();
            Assert.assertEquals((String)"Protocol tests failed", (long)0L, (long)res);
        } else {
            System.err.println("*** No Python runtime sockjs tests will be skiped!!!");
        }
    }
}

