/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.ext.web.impl.SparseArray;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class SparseArrayTest {
    @Test
    public void empty() {
        CapturingConsumer c = new CapturingConsumer();
        SparseArray m = new SparseArray();
        m.clear();
        m.forEachInReverseOrder((Consumer)c);
        Assert.assertEquals((long)0L, (long)c.acceptedInvocations);
    }

    @Test
    public void one() {
        CapturingConsumer c = new CapturingConsumer();
        SparseArray m = new SparseArray();
        m.clear();
        m.forEachInReverseOrder((Consumer)c);
        Assert.assertEquals((long)0L, (long)c.acceptedInvocations);
        Object objectSeven = new Object();
        m.put(7, objectSeven);
        m.forEachInReverseOrder((Consumer)c);
        Assert.assertEquals((long)1L, (long)c.acceptedInvocations);
        Assert.assertEquals((Object)objectSeven, c.accepted.get(0));
    }

    @Test
    public void multi() {
        SparseArray m = new SparseArray();
        Object objectSeven = new Object();
        m.put(7, objectSeven);
        Object objectFour = new Object();
        m.put(4, objectFour);
        Object objectFive = new Object();
        m.put(5, objectFive);
        Object removed = m.remove(5);
        Assert.assertEquals((Object)objectFive, (Object)removed);
        CapturingConsumer c = new CapturingConsumer();
        m.forEachInReverseOrder((Consumer)c);
        Assert.assertEquals((long)2L, (long)c.acceptedInvocations);
        Assert.assertEquals((Object)objectSeven, c.accepted.get(0));
        Assert.assertEquals((Object)objectFour, c.accepted.get(1));
        CapturingConsumer c2 = new CapturingConsumer();
        m.forEachInReverseOrder((Consumer)c2);
        Assert.assertEquals((long)2L, (long)c2.acceptedInvocations);
        Assert.assertEquals((Object)objectSeven, c2.accepted.get(0));
        Assert.assertEquals((Object)objectFour, c2.accepted.get(1));
        m.clear();
        CapturingConsumer c3 = new CapturingConsumer();
        m.forEachInReverseOrder((Consumer)c3);
        Assert.assertEquals((long)0L, (long)c3.acceptedInvocations);
    }

    @Test
    public void deleteOnEmpty() {
        SparseArray m = new SparseArray();
        m.remove(3);
    }

    private static class CapturingConsumer
    implements Consumer {
        private ArrayList accepted = new ArrayList();
        private int acceptedInvocations = 0;

        private CapturingConsumer() {
        }

        public void accept(Object o) {
            this.accepted.add(o);
            ++this.acceptedInvocations;
        }
    }
}

