/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.SimpleAuthenticationHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import org.junit.Test;

public class ChainAuthMixHandlerTest
extends WebTestBase {
    private static final User USER = User.create((JsonObject)new JsonObject().put("id", (Object)"paulo"));
    private final AuthenticationHandler success = SimpleAuthenticationHandler.create().authenticate(ctx -> Future.succeededFuture((Object)USER));
    private final AuthenticationHandler failure = SimpleAuthenticationHandler.create().authenticate(ctx -> Future.failedFuture((Throwable)new HttpException(401)));

    @Test
    public void testFailOrFailOrSuccess() throws Exception {
        ChainAuthHandler chain = ChainAuthHandler.any().add(this.failure).add((AuthenticationHandler)ChainAuthHandler.any().add(this.failure).add(this.success));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)chain);
        this.router.route().handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testFailOrSuccessAndFail() throws Exception {
        ChainAuthHandler chain = ChainAuthHandler.any().add(this.failure).add((AuthenticationHandler)ChainAuthHandler.all().add(this.success).add(this.failure));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)chain);
        this.router.route().handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.GET, "/", 401, "Unauthorized");
    }

    @Test
    public void test2JWTIssuers() throws Exception {
        JsonObject key = new JsonObject().put("kty", (Object)"oct").put("use", (Object)"sig").put("k", (Object)"wuSPxS64NYh4ohDpZWOMNtawhBLHVn8dhKuIxnsLLd-dfKzIb5FL7r-vXTJ3MjtqnBlh_piKjn6qvb8os00MXNEyJWhgbPsnZEfqj6wMsJiH3uDcEgDuBMVbsuMlVbyX3x0Cd6qn0qvF8JZaLxSR6JNEEOGnbkUXqF9ghcI2y8rooN6ivQJ0-SiCqtQSkVrSO4H65lHagUus0XjTErL4GypbcO6PBIZMtHBW4UZHVcl86IhDxj5v0xf3WSuDGxkrbw5rpM_eVUR1eu71XPoTXD4WgDRtq4CoQcIFeSpqJuKZvzDJ47zV3wgnqKZ6G-RkiSKLBUj5_4Ur_YWHw2h-CQ").put("alg", (Object)"HS256");
        JWTAuth me = JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)new JWTAuthOptions().addJwk(key).setJWTOptions(new JWTOptions().setIssuer("me")));
        JWTAuth you = JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)new JWTAuthOptions().addJwk(key).setJWTOptions(new JWTOptions().setIssuer("you")));
        ChainAuthHandler chain = ChainAuthHandler.any().add((AuthenticationHandler)JWTAuthHandler.create((JWTAuth)me)).add((AuthenticationHandler)JWTAuthHandler.create((JWTAuth)you));
        this.router.route().handler((Handler)chain);
        this.router.route().handler(ctx -> ctx.response().end());
        JsonObject payloadA = new JsonObject().put("sub", (Object)"Paulo").put("iss", (Object)"me");
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + me.generateToken(payloadA)), 200, "OK", null);
        JsonObject payloadB = new JsonObject().put("sub", (Object)"Paulo").put("iss", (Object)"you");
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + you.generateToken(payloadB)), 200, "OK", null);
    }

    @Test
    public void testRedirectAndHandler() throws Exception {
        ChainAuthHandler.all().add((AuthenticationHandler)OAuth2AuthHandler.create((Vertx)this.vertx, null)).add((AuthenticationHandler)BasicAuthHandler.create(null));
    }

    @Test(expected=IllegalStateException.class)
    public void testRedirectAndHandlerFail() {
        ChainAuthHandler.all().add((AuthenticationHandler)OAuth2AuthHandler.create((Vertx)this.vertx, null, (String)"http://server.com/callback")).add((AuthenticationHandler)BasicAuthHandler.create(null));
    }
}

