/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.StaticHandler;
import org.junit.Test;

public class StaticHandler3Test
extends WebTestBase {
    protected StaticHandler stat;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stat = StaticHandler.create();
        this.router.route("/*").handler((Handler)this.stat);
    }

    @Test
    public void testGetDefaultIndex() throws Exception {
        this.testRequest(HttpMethod.GET, "", 200, "OK", "<html><body>Index page</body></html>");
        this.testRequest(HttpMethod.GET, "/", 200, "OK", "<html><body>Index page</body></html>");
        this.testRequest(HttpMethod.GET, "/index.html", 200, "OK", "<html><body>Index page</body></html>");
    }

    @Test
    public void testGetDefaultIndexWithSlash() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir/", 200, "OK", "<html><body>Subdirectory index page</body></html>");
    }

    @Test
    public void testGetDefaultIndexWithoutSlash() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir", null, res -> this.assertEquals("/somedir/", res.getHeader("Location")), 301, "Moved Permanently", null);
        this.testRequest(HttpMethod.GET, "/somedir/", 200, "OK", "<html><body>Subdirectory index page</body></html>");
    }
}

