/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class SockJSSessionContextTest
extends SockJSTestBase {
    @Override
    public void setUp() throws Exception {
        this.numServers = 2;
        super.setUp();
    }

    @Test
    public void testHandleMessageFromXhrTransportWithAsyncHandler() throws Exception {
        String msg = "Hello World";
        this.socketHandler = () -> socket -> socket.handler(buffer -> {
            this.assertEquals(msg, buffer.toString());
            socket.write(buffer);
        });
        this.startServers();
        this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr", this.onSuccess(req1 -> req1.send(Buffer.buffer(), this.onSuccess(resp1 -> {
            this.assertEquals(200L, resp1.statusCode());
            this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr", this.onSuccess(req2 -> req2.send(Buffer.buffer(), this.onSuccess(resp2 -> {
                this.assertEquals(200L, resp2.statusCode());
                this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr_send", this.onSuccess(req3 -> req3.send(Buffer.buffer((String)('\"' + msg + '\"')), this.onSuccess(resp3 -> {
                    this.assertEquals(204L, resp3.statusCode());
                    this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr", this.onSuccess(req4 -> req4.send(Buffer.buffer(), this.onSuccess(resp4 -> {
                        this.assertEquals(200L, resp4.statusCode());
                        resp4.body(this.onSuccess(buffer -> {
                            String body = buffer.toString();
                            this.assertThat(body, CoreMatchers.startsWith((String)"a"));
                            JsonArray content = new JsonArray(body.substring(1));
                            this.assertEquals(1L, content.size());
                            this.assertEquals(msg, content.getValue(0));
                            this.complete();
                        }));
                    }))));
                }))));
            }))));
        }))));
        this.await();
    }
}

