/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.web.FakeHttpServerMetrics;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import org.junit.Test;

public class MetricsTest
extends WebTestBase {
    final FakeHttpServerMetrics fakeHttpServerMetrics = new FakeHttpServerMetrics();

    public VertxOptions getOptions() {
        return new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory(options -> new VertxMetrics(){

            public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
                return MetricsTest.this.fakeHttpServerMetrics;
            }
        }));
    }

    @Test
    public void testSimpleRoute() throws Exception {
        this.fakeHttpServerMetrics.reset(new String[]{null});
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testSimpleRouterMultipleRoutes() throws Exception {
        this.fakeHttpServerMetrics.reset("A", "B", "C", "D", "E");
        this.router.route().setName("A").handler(RoutingContext::next);
        this.router.route().setName("B").handler(RoutingContext::next);
        this.router.route().setName("C").handler(RoutingContext::next);
        this.router.route().setName("D").handler(RoutingContext::next);
        this.router.route().setName("E").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testSimpleRouterMultipleRoutesSomeSkiped() throws Exception {
        this.fakeHttpServerMetrics.reset("A", "B", "D", "E");
        this.router.route().setName("A").handler(RoutingContext::next);
        this.router.route().setName("B").handler(RoutingContext::next);
        this.router.route("/skip-me").setName("C").handler(RoutingContext::next);
        this.router.route().setName("D").handler(RoutingContext::next);
        this.router.route().setName("E").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }
}

