/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.sockjs.BridgeEvent;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class SockJSErrorTest
extends VertxTestBase {
    public static final String EVENTBUS_ADDRESS = "addr1";
    public static final String EVENTBUS_REGISTER_MESSAGE = "{\"type\":\"register\",\"address\":\"addr1\",\"headers\":{\"Accept\":\"application/json\"}}";
    public static final String EVENTBUS_UNREGISTER_MESSAGE = "{\"type\":\"unregister\",\"address\":\"addr1\",\"headers\":{\"Accept\":\"application/json\"}}";
    public static final String WSS_PATH = "/wss/";
    public static final String WEBSOCKET_PATH = "/wss/websocket";
    private static final Logger log = LoggerFactory.getLogger(SockJSErrorTest.class);
    public static final int PORT = 8080;
    public static final String LOCALHOST = "localhost";
    private static int counter = 0;
    Vertx vertx;
    HttpServer server;
    private CountDownLatch countDownLatch;

    @Before
    public void before(TestContext context) {
        this.countDownLatch = new CountDownLatch(1);
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(context.exceptionHandler());
        this.server = this.vertx.createHttpServer();
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)LoggerHandler.create());
        router.route("/").handler(event -> event.request().response().end("test"));
        Router sockJSRouter = this.createEventBusRouter();
        router.mountSubRouter(WSS_PATH, sockJSRouter);
        this.server.requestHandler((Handler)router);
        this.server.listen(8080, context.asyncAssertSuccess());
        this.vertx.setPeriodic(100L, id -> {
            log.info((Object)("server sending number: " + ++counter));
            this.vertx.eventBus().send(EVENTBUS_ADDRESS, (Object)counter);
        });
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testEventBusBridgeLeakingConsumers(TestContext context) throws InterruptedException {
        HttpClient client = this.vertx.createHttpClient();
        client.webSocket(8080, LOCALHOST, WEBSOCKET_PATH, this.onSuccess(ws -> {
            ws.writeTextMessage(EVENTBUS_REGISTER_MESSAGE);
            ws.writeTextMessage(EVENTBUS_REGISTER_MESSAGE);
            ws.handler(buff -> {
                log.info((Object)("websocket client 1 received raw message: " + buff.toString("UTF-8")));
                ws.writeTextMessage(EVENTBUS_UNREGISTER_MESSAGE);
                ws.writeTextMessage(EVENTBUS_UNREGISTER_MESSAGE);
                ws.close();
                this.countDownLatch.countDown();
            });
        }));
        this.countDownLatch.await();
        int[] counter = new int[]{-1};
        HttpClient client2 = this.vertx.createHttpClient();
        client2.webSocket(8080, LOCALHOST, WEBSOCKET_PATH, this.onSuccess(ws -> {
            ws.writeTextMessage(EVENTBUS_REGISTER_MESSAGE);
            ws.handler(buff -> {
                log.debug((Object)("websocket client 2 received raw message: " + buff.toString("UTF-8")));
                JsonObject jsonObject = new JsonObject(buff.toString("UTF-8"));
                int number = jsonObject.getInteger("body");
                log.info((Object)("websocket client 2 received number: " + number));
                counter[0] = counter[0] == -1 ? number : counter[0] + 1;
                this.assertEquals("Message was lost, next id not matching.", counter[0], number);
                if (number % 20 == 0) {
                    this.testComplete();
                }
            });
        }));
        this.await();
    }

    @Test
    public void testEventBusBridgeLeakingConsumersClean(TestContext context) throws InterruptedException {
        HttpClient client = this.vertx.createHttpClient();
        client.webSocket(8080, LOCALHOST, WEBSOCKET_PATH, this.onSuccess(ws -> {
            ws.writeTextMessage(EVENTBUS_REGISTER_MESSAGE);
            ws.handler(buff -> {
                log.info((Object)("websocket client 1 received raw message: " + buff.toString("UTF-8")));
                ws.writeTextMessage(EVENTBUS_UNREGISTER_MESSAGE);
                ws.close();
                this.countDownLatch.countDown();
            });
        }));
        this.countDownLatch.await();
        int[] counter = new int[]{-1};
        HttpClient client2 = this.vertx.createHttpClient();
        client2.webSocket(8080, LOCALHOST, WEBSOCKET_PATH, this.onSuccess(ws -> {
            ws.writeTextMessage(EVENTBUS_REGISTER_MESSAGE);
            ws.handler(buff -> {
                log.debug((Object)("websocket client 2 received raw message: " + buff.toString("UTF-8")));
                JsonObject jsonObject = new JsonObject(buff.toString("UTF-8"));
                int number = jsonObject.getInteger("body");
                log.info((Object)("websocket client 2 received number: " + number));
                counter[0] = counter[0] == -1 ? number : counter[0] + 1;
                this.assertEquals("Message was lost, next id not matching.", counter[0], number);
                if (number % 20 == 0) {
                    this.testComplete();
                }
            });
        }));
        this.await();
    }

    private Router createEventBusRouter() {
        PermittedOptions permittedOptions = new PermittedOptions().setAddress(EVENTBUS_ADDRESS);
        SockJSBridgeOptions bridgeOptions = new SockJSBridgeOptions().addInboundPermitted(permittedOptions).addOutboundPermitted(permittedOptions).setPingTimeout(60000L);
        return SockJSHandler.create((Vertx)this.vertx).bridge(bridgeOptions, (Handler)new TestBridgeEventHandler());
    }

    class TestBridgeEventHandler
    implements Handler<BridgeEvent> {
        TestBridgeEventHandler() {
        }

        public void handle(BridgeEvent event) {
            JsonObject rawMessage = event.getRawMessage();
            log.debug((Object)("Bridge event type=" + event.type() + ", raw message=" + this.encode(rawMessage)));
            event.complete((Object)true);
        }

        private String encode(JsonObject rawMessage) {
            return rawMessage != null ? rawMessage.encode() : "null";
        }
    }
}

