/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.ext.web.impl.Origin;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class OriginTest {
    @Test
    public void testOrigin() {
        Origin.parse((String)"http://www.vertx.io");
        Assert.assertTrue((boolean)Origin.isValid((String)"http://www.vertx.io"));
        Origin.parse((String)"http://[::1]");
        Assert.assertTrue((boolean)Origin.isValid((String)"http://[::1]"));
        Origin.parse((String)"http://my-site.com");
        Assert.assertTrue((boolean)Origin.isValid((String)"http://my-site.com"));
        Origin.parse((String)"http://my-site.123.com");
        Assert.assertTrue((boolean)Origin.isValid((String)"http://my-site.123.com"));
    }

    @Test
    public void testBadOrigin() {
        List<String> origins = Arrays.asList("httpss://www.google.com", "http://1[::1]:8080", "http://my_site.com", "http://1[::1]:8080");
        for (String origin : origins) {
            try {
                Origin.parse((String)origin);
                Assert.fail((String)("Should fail as it is a bad origin: " + origin));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)Origin.isValid((String)origin));
        }
    }

    @Test
    public void testNullOrigin() {
        Origin.parse((String)"null");
        Assert.assertTrue((boolean)Origin.isValid((String)"null"));
    }
}

