/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.it;

import io.vertx.core.Future;
import io.vertx.ext.auth.webauthn.Authenticator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class AuthenticatorStore {
    private final List<Authenticator> database = new ArrayList<Authenticator>();

    AuthenticatorStore() {
    }

    public Future<List<Authenticator>> fetcher(Authenticator query) {
        return Future.succeededFuture(this.database.stream().filter(entry -> {
            if (query.getUserName() != null) {
                return query.getUserName().equals(entry.getUserName());
            }
            if (query.getCredID() != null) {
                return query.getCredID().equals(entry.getCredID());
            }
            return false;
        }).collect(Collectors.toList()));
    }

    public Future<Void> updater(Authenticator authenticator) {
        long updated = this.database.stream().filter(entry -> authenticator.getCredID().equals(entry.getCredID())).peek(entry -> entry.setCounter(authenticator.getCounter())).count();
        if (updated > 0L) {
            return Future.succeededFuture();
        }
        this.database.add(authenticator);
        return Future.succeededFuture();
    }

    public void clear() {
        this.database.clear();
    }
}

