/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Supplier;

abstract class SockJSTestBase
extends VertxTestBase {
    int numServers = 1;
    HttpClient client;
    Consumer<Router> preSockJSHandlerSetup;
    Supplier<Handler<SockJSSocket>> socketHandler;

    SockJSTestBase() {
    }

    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080).setKeepAlive(false));
    }

    void startServers() throws Exception {
        this.startServers(new SockJSHandlerOptions());
    }

    void startServers(final SockJSHandlerOptions options) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start(Promise<Void> startFuture) throws Exception {
                Router router = Router.router((Vertx)this.vertx);
                router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)).setNagHttps(false).setSessionTimeout(3600000L));
                if (SockJSTestBase.this.preSockJSHandlerSetup != null) {
                    SockJSTestBase.this.preSockJSHandlerSetup.accept(router);
                }
                options.setHeartbeatInterval(2000L);
                options.setRegisterWriteHandler(true);
                SockJSHandler sockJSHandler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)options);
                router.route("/test/*").subRouter(sockJSHandler.socketHandler(SockJSTestBase.this.socketHandler.get()));
                this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost")).requestHandler((Handler)router).listen(ar -> {
                    if (ar.succeeded()) {
                        startFuture.complete();
                    } else {
                        startFuture.fail(ar.cause());
                    }
                });
            }
        }, new DeploymentOptions().setInstances(this.numServers), this.onSuccess(id -> latch.countDown()));
        this.awaitLatch(latch);
    }
}

