/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.Transport;
import io.vertx.test.fakecluster.FakeClusterManager;

public class SockJSWriteHandlerTestServer {
    public static void main(String[] areags) {
        CompositeFuture.join(SockJSWriteHandlerTestServer.createClusteredAndDeploy((Verticle)new HttpServerVerticle()), SockJSWriteHandlerTestServer.createClusteredAndDeploy((Verticle)new EventBusRelayVerticle())).onSuccess(cf -> System.out.println("SockJS writeHandler tests server started")).onFailure(Throwable::printStackTrace);
    }

    private static Future<String> createClusteredAndDeploy(Verticle verticle) {
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)new FakeClusterManager());
        return Vertx.clusteredVertx((VertxOptions)options).flatMap(vertx -> vertx.deployVerticle(verticle));
    }

    private static void sendToWriteHandler(EventBus eventBus, JsonObject body) {
        String address = body.getString("address");
        String content = body.getString("content");
        eventBus.send(address, (Object)Buffer.buffer((String)content));
    }

    private static class EventBusRelayVerticle
    extends AbstractVerticle {
        private EventBusRelayVerticle() {
        }

        public void start() {
            this.vertx.eventBus().consumer("relay", msg -> SockJSWriteHandlerTestServer.sendToWriteHandler(this.vertx.eventBus(), (JsonObject)msg.body()));
        }
    }

    private static class HttpServerVerticle
    extends AbstractVerticle {
        private HttpServerVerticle() {
        }

        public void start() {
            Router router = Router.router((Vertx)this.vertx);
            router.get("/transports").handler(rc -> {
                JsonArray transports = new JsonArray();
                for (Transport transport : Transport.values()) {
                    if (transport == Transport.HTML_FILE) continue;
                    transports.add((Object)transport.name());
                }
                rc.json((Object)transports);
            });
            for (Transport transport : Transport.values()) {
                this.setupSockJSHandler(router, transport, false, true);
                this.setupSockJSHandler(router, transport, true, true);
                this.setupSockJSHandler(router, transport, true, false);
            }
            router.post("/message").handler((Handler)BodyHandler.create()).handler(rc -> {
                EventBus eventBus = this.vertx.eventBus();
                JsonObject body = rc.body().asJsonObject();
                if (rc.queryParams().contains("relay")) {
                    eventBus.send("relay", (Object)body);
                } else {
                    SockJSWriteHandlerTestServer.sendToWriteHandler(eventBus, body);
                }
                rc.end();
            });
            router.get().handler((Handler)StaticHandler.create());
            router.route().failureHandler((Handler)ErrorHandler.create((Vertx)this.vertx, (boolean)true));
            this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080);
        }

        private void setupSockJSHandler(Router router, Transport transport, boolean register, boolean local) {
            SockJSHandlerOptions options = new SockJSHandlerOptions();
            for (Transport t : Transport.values()) {
                if (t == transport) continue;
                options.addDisabledTransport(t.name());
            }
            options.setRegisterWriteHandler(register).setLocalWriteHandler(local);
            SockJSHandler sockJSHandler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)options);
            String mountPoint = "/transport/" + transport.name() + "/" + (register ? "registered" : "unregistered") + "/" + (local ? "local" : "clustered");
            router.route(mountPoint + "*").subRouter(sockJSHandler.socketHandler(socket -> {
                String id = socket.writeHandlerID();
                socket.write(id != null ? id : "--null--");
            }));
        }
    }
}

