/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CORSHandlerTest
extends WebTestBase {
    @Test(expected=NullPointerException.class)
    public void testNullAllowedOrigin() {
        CorsHandler.create(null);
    }

    @Test
    public void testNotCORSRequest() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptAllAllowedOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create());
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "*", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOriginDenied1() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://foo.io"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptConstantOriginDenied2() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "fooxio"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptDotisAnyCharacter1() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertxxio"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertxxio", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptDotisAnyCharacter2() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOriginDeniedErrorHandler() throws Exception {
        Consumer handler = (Consumer)Mockito.mock(Consumer.class);
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.router.errorHandler(403, handler::accept);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://foo.io"), resp -> ((Consumer)Mockito.verify((Object)handler)).accept(ArgumentMatchers.any()), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptPattern() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://.*\\.vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://foo.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://foo.vertx.io", null, null, null), 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://bar.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://bar.vertx.io", null, null, null), 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://wibble.bar.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://wibble.bar.vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptPatternDenied() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://.*\\.vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://foo.vertx.com"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://barxvertxxio"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testPreflightSimple() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io").allowedMethods(allowedMethods));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "PUT,DELETE", null, null), 204, "No Content", null);
    }

    @Test
    public void testPreflightAllowedHeaders() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        LinkedHashSet<String> allowedHeaders = new LinkedHashSet<String>(Arrays.asList("X-wibble", "X-blah"));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io").allowedMethods(allowedMethods).allowedHeaders(allowedHeaders));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
            req.headers().add("access-control-request-headers", (Iterable)allowedHeaders);
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "PUT,DELETE", "X-wibble,X-blah", null), 204, "No Content", null);
    }

    @Test
    public void testPreflightNoExposeHeaders() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        LinkedHashSet<String> exposeHeaders = new LinkedHashSet<String>(Arrays.asList("X-floob", "X-blurp"));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io").allowedMethods(allowedMethods).exposedHeaders(exposeHeaders));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "PUT,DELETE", null, null), 204, "No Content", null);
    }

    @Test
    public void testPreflightAllowCredentials() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "PUT,DELETE", null, null, "true", null), 204, "No Content", null);
    }

    @Test
    public void testPreflightAllowCredentialsNoWildcardOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx.*").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "PUT,DELETE", null, null, "true", null), 204, "No Content", null);
    }

    @Test
    public void testPreflightMaxAge() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        int maxAge = 131233;
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io").allowedMethods(allowedMethods).maxAgeSeconds(maxAge));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "PUT,DELETE", null, null, null, String.valueOf(maxAge)), 204, "No Content", null);
    }

    @Test
    public void testRealRequestAllowCredentials() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx\\.io").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", null, null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testRealRequestCredentialsNoWildcardOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx.*").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", null, null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testRealRequestCredentialsWildcard() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create().allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", null, null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testChaining() throws Exception {
        CorsHandler cors = CorsHandler.create();
        this.assertNotNull(cors);
        this.assertSame(cors, cors.allowedMethod(HttpMethod.POST));
        this.assertSame(cors, cors.allowedMethod(HttpMethod.DELETE));
        this.assertSame(cors, cors.allowedMethods(new HashSet()));
        this.assertSame(cors, cors.allowedHeader("X-foo"));
        this.assertSame(cors, cors.allowedHeader("X-bar"));
        this.assertSame(cors, cors.allowedHeaders(new HashSet()));
        this.assertSame(cors, cors.exposedHeader("X-wibble"));
        this.assertSame(cors, cors.exposedHeader("X-blah"));
        this.assertSame(cors, cors.exposedHeaders(new HashSet()));
    }

    private void checkHeaders(HttpClientResponse resp, String accessControlAllowOrigin, String accessControlAllowMethods, String accessControlAllowHeaders, String accessControlExposeHeaders) {
        this.checkHeaders(resp, accessControlAllowOrigin, accessControlAllowMethods, accessControlAllowHeaders, accessControlExposeHeaders, null, null);
    }

    private void checkHeaders(HttpClientResponse resp, String accessControlAllowOrigin, String accessControlAllowMethods, String accessControlAllowHeaders, String accessControlExposeHeaders, String allowCredentials, String maxAgeSeconds) {
        this.checkHeaders(resp, accessControlAllowOrigin, accessControlAllowMethods, accessControlAllowHeaders, accessControlExposeHeaders, allowCredentials, maxAgeSeconds, null);
    }

    private void checkHeaders(HttpClientResponse resp, String accessControlAllowOrigin, String accessControlAllowMethods, String accessControlAllowHeaders, String accessControlExposeHeaders, String allowCredentials, String maxAgeSeconds, String privateNetwork) {
        this.assertEquals(accessControlAllowOrigin, resp.headers().get("access-control-allow-origin"));
        this.assertEquals(accessControlAllowMethods, resp.headers().get("access-control-allow-methods"));
        this.assertEquals(accessControlAllowHeaders, resp.headers().get("access-control-allow-headers"));
        this.assertEquals(accessControlExposeHeaders, resp.headers().get("access-control-expose-headers"));
        this.assertEquals(allowCredentials, resp.headers().get("access-control-allow-credentials"));
        this.assertEquals(maxAgeSeconds, resp.headers().get("access-control-max-age"));
        this.assertEquals(privateNetwork, resp.headers().get("access-control-allow-private-network"));
    }

    @Test
    public void testIncludesVaryHeaderForSpecificOrigins() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://example.com"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://example.com"), resp -> this.assertEquals("origin", resp.getHeader("Vary")), 200, "OK", null);
    }

    @Test
    public void testAppendsVaryHeaderForSpecificOriginsWhenVaryIsDefined() throws Exception {
        this.router.route().handler(context -> {
            context.response().putHeader("Vary", "Foo");
            context.next();
        });
        this.router.route().handler((Handler)CorsHandler.create((String)"http://example.com"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "http://example.com"), resp -> this.assertEquals("Foo,origin", resp.getHeader("Vary")), 200, "OK", null);
    }

    @Test
    public void testCanSpecifyAllowedHeaders() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://example.com").allowedHeader("header1").allowedHeader("header2"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> req.headers().add("origin", "http://example.com").add("access-control-request-method", "POST").add("access-control-request-headers", "x-header-1, x-header-2"), resp -> {
            this.assertEquals("header1,header2", resp.getHeader("Access-Control-Allow-Headers"));
            this.assertNull(resp.getHeader("Vary"));
        }, 204, "No Content", null);
    }

    @Test
    public void testMirrorAllowedHeaders() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://example.com"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> req.headers().add("origin", "http://example.com").add("access-control-request-method", "POST").add("access-control-request-headers", "x-header-1, x-header-2"), resp -> {
            this.assertEquals("x-header-1, x-header-2", resp.getHeader("Access-Control-Allow-Headers"));
            this.assertEquals("access-control-request-headers", resp.getHeader("Vary"));
        }, 204, "No Content", null);
    }

    @Test
    public void testMDNExample() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://foo.example").allowedHeader("X-PINGOTHER").allowedHeader("Content-Type").allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.OPTIONS).maxAgeSeconds(86400));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> req.headers().add("origin", "http://foo.example").add("access-control-request-method", "POST").add("access-control-request-headers", "X-PINGOTHER, Content-Type"), resp -> {
            this.assertEquals("http://foo.example", resp.getHeader("Access-Control-Allow-Origin"));
            this.assertEquals("POST,GET,OPTIONS", resp.getHeader("Access-Control-Allow-Methods"));
            this.assertEquals("X-PINGOTHER,Content-Type", resp.getHeader("access-control-allow-headers"));
            this.assertEquals("86400", resp.getHeader("access-control-max-age"));
        }, 204, "No Content", null);
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "http://foo.example").add("X-PINGOTHER", "pingother").add("Content-Type", "text/xml; charset=UTF-8"), resp -> {
            this.assertEquals("http://foo.example", resp.getHeader("Access-Control-Allow-Origin"));
            this.assertEquals("origin", resp.getHeader("Vary"));
        }, 200, "OK", null);
    }

    @Test
    public void testNotCORSRequestMultiOrigins() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOriginMultiOrigins() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "https://www.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOriginDenied1MultiOrigins() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "foo.io"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptConstantOriginDenied2MultiOrigins() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "fooxio"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptConstantOriginDeniedErrorHandlerMultiOrigin() throws Exception {
        Consumer handler = (Consumer)Mockito.mock(Consumer.class);
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")));
        this.router.route().handler(context -> context.response().end());
        this.router.errorHandler(403, handler::accept);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "foo.io"), resp -> ((Consumer)Mockito.verify((Object)handler)).accept(ArgumentMatchers.any()), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testPreflightSimpleMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "https://www.vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", "PUT,DELETE", null, null), 204, "No Content", null);
    }

    @Test
    public void testPreflightAllowedHeadersMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        LinkedHashSet<String> allowedHeaders = new LinkedHashSet<String>(Arrays.asList("X-wibble", "X-blah"));
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods).allowedHeaders(allowedHeaders));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "https://www.vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
            req.headers().add("access-control-request-headers", (Iterable)allowedHeaders);
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", "PUT,DELETE", "X-wibble,X-blah", null), 204, "No Content", null);
    }

    @Test
    public void testPreflightNoExposeHeadersMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        LinkedHashSet<String> exposeHeaders = new LinkedHashSet<String>(Arrays.asList("X-floob", "X-blurp"));
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods).exposedHeaders(exposeHeaders));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "https://www.vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", "PUT,DELETE", null, null), 204, "No Content", null);
    }

    @Test
    public void testPreflightAllowCredentialsMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "https://www.vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", "PUT,DELETE", null, null, "true", null), 204, "No Content", null);
    }

    @Test
    public void testPreflightAllowCredentialsNoWildcardOriginMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "https://www.vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", "PUT,DELETE", null, null, "true", null), 204, "No Content", null);
    }

    @Test
    public void testPreflightMaxAgeMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        int maxAge = 131233;
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods).maxAgeSeconds(maxAge));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "https://www.vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", "PUT,DELETE", null, null, null, String.valueOf(maxAge)), 204, "No Content", null);
    }

    @Test
    public void testRealRequestAllowCredentialsMultiOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create().addOrigins(Arrays.asList("http://www.example.com", "https://www.vertx.io")).allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "https://www.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "https://www.vertx.io", null, null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testAcceptNullOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigin("*"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "null"), resp -> this.checkHeaders((HttpClientResponse)resp, "*", null, null, null), 200, "OK", null);
    }

    @Test
    public void testPreflightAllowPrivateNetwork() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx.*").allowedMethod(HttpMethod.GET).allowPrivateNetwork(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "GET");
            req.headers().add("access-control-request-private-network", "true");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "GET", null, null, null, null, "true"), 204, "No Content", null);
    }

    @Test
    public void testPreflightDenyPrivateNetwork() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"http://vertx.*").allowedMethod(HttpMethod.GET).allowPrivateNetwork(false));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "http://vertx.io");
            req.headers().add("access-control-request-method", "GET");
            req.headers().add("access-control-request-private-network", "true");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "http://vertx.io", "GET", null, null, null, null, null), 204, "No Content", null);
    }

    @Test
    public void testCORSSetup() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigin("https://mydomain.org:3000").addOrigin("https://mydomain.org:9443").allowCredentials(true).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler((Handler)BodyHandler.create().setBodyLimit(1L)).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://mydomain.org:3000"), resp -> {
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.headers().add("origin", "https://mydomain.org:3000");
            req.send("abc");
        }, resp -> {
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
        }, 413, "Request Entity Too Large", null);
    }

    @Test
    public void testCORSSetupSingleOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigin("https://mydomain.org:3000").addOrigin("https://mydomain.org:9443").allowCredentials(true).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://mydomain.org:3000"), resp -> {
            String cred = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS);
            String orig = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN);
            this.assertNotNull(cred);
            this.assertNotNull(orig);
            this.assertEquals("https://mydomain.org:3000", orig);
        }, 200, "OK", null);
    }

    @Test
    public void testCORSSetupSingleRelativeOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addRelativeOrigin("https://.*:3000").addRelativeOrigin("https://.*:9443").allowCredentials(true).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://mydomain.org:3000"), resp -> {
            String cred = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS);
            String orig = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN);
            this.assertNotNull(cred);
            this.assertNotNull(orig);
            this.assertEquals("https://mydomain.org:3000", orig);
        }, 200, "OK", null);
    }

    @Test
    public void testCORSSetupMixedOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addRelativeOrigin("https://f.*").addOrigin("https://foo").allowCredentials(true).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://foo"), resp -> {
            String cred = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS);
            String orig = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN);
            String vary = resp.getHeader(HttpHeaders.VARY);
            this.assertNotNull(cred);
            this.assertNotNull(orig);
            this.assertNotNull(vary);
            this.assertEquals("https://foo", orig);
            this.assertEquals("origin", vary);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://foobar"), resp -> {
            String cred = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS);
            String orig = resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN);
            String vary = resp.getHeader(HttpHeaders.VARY);
            this.assertNotNull(cred);
            this.assertNotNull(orig);
            this.assertNotNull(vary);
            this.assertEquals("https://foobar", orig);
            this.assertEquals("origin", vary);
        }, 200, "OK", null);
    }

    @Test
    public void testCORSSetupSingleOriginShouldNotHaveVary() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().addOrigin("https://mydomain.org:3000").allowCredentials(true).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler((Handler)BodyHandler.create().setBodyLimit(1L)).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://mydomain.org:3000"), resp -> {
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
            this.assertNull(resp.getHeader(HttpHeaders.VARY));
        }, 200, "OK", null);
    }

    @Test
    public void testCORSSetupStarOriginShouldNotHaveVary() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().allowCredentials(false).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler((Handler)BodyHandler.create().setBodyLimit(1L)).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://mydomain.org:3000"), resp -> {
            this.assertNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
            this.assertNull(resp.getHeader(HttpHeaders.VARY));
        }, 200, "OK", null);
    }

    @Test
    public void testCORSSetupStarOriginWithAllowCredentialsShouldHaveVary() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create().allowCredentials(true).allowedHeader("Content-Type").allowedMethod(HttpMethod.GET).allowedMethod(HttpMethod.POST).allowedMethod(HttpMethod.OPTIONS).allowedHeader("Access-Control-Allow-Origin")).handler((Handler)BodyHandler.create().setBodyLimit(1L)).handler(context -> context.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.headers().add("origin", "https://mydomain.org:3000"), resp -> {
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.assertNotNull(resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
            this.assertEquals("origin", resp.getHeader(HttpHeaders.VARY));
        }, 200, "OK", null);
    }
}

