/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import io.vertx.test.core.TestUtils;
import org.junit.Test;

public class SockJSRawTransportTest
extends SockJSTestBase {
    @Test
    public void testWriteText() throws Exception {
        this.testWrite(true);
    }

    @Test
    public void testWriteBinary() throws Exception {
        this.testWrite(false);
    }

    @Test
    public void disableHost() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(expected);
            socket.endHandler(v -> this.testComplete());
        };
        this.startServers(new SockJSHandlerOptions());
        this.client.webSocket(new WebSocketConnectOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/test/websocket").setAllowOriginHeader(false), this.onSuccess(ws -> ws.frameHandler(frame -> {
            if (!frame.isClose()) {
                this.assertTrue(frame.isText());
                this.assertEquals(expected, frame.textData());
                ws.end();
            }
        })));
        this.await();
    }

    @Test
    public void disableHostFailWhenOriginIsRequired() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(expected);
            socket.endHandler(v -> this.testComplete());
        };
        this.startServers(new SockJSHandlerOptions().setOrigin("http://localhost:8080"));
        this.client.webSocket(new WebSocketConnectOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/test/websocket").setAllowOriginHeader(false), this.onFailure(err -> {
            this.assertNotNull(err);
            this.assertEquals("WebSocket upgrade failure: 403", err.getMessage());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void goodOrigin() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(expected);
            socket.endHandler(v -> this.testComplete());
        };
        this.startServers(new SockJSHandlerOptions().setOrigin("http://localhost:8080"));
        this.client.webSocket("/test/websocket", this.onSuccess(ws -> ws.frameHandler(frame -> {
            if (!frame.isClose()) {
                this.assertTrue(frame.isText());
                this.assertEquals(expected, frame.textData());
                ws.end();
            }
        })));
        this.await();
    }

    @Test
    public void badOrigin() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(expected);
            socket.endHandler(v -> this.testComplete());
        };
        this.startServers(new SockJSHandlerOptions().setOrigin("https://www.google.com"));
        this.client.webSocket("/test/websocket", this.onFailure(err -> {
            this.assertNotNull(err);
            this.assertEquals("WebSocket upgrade failure: 403", err.getMessage());
            this.testComplete();
        }));
        this.await();
    }

    private void testWrite(boolean text) throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            if (text) {
                socket.write(expected);
            } else {
                socket.write(Buffer.buffer((String)expected));
            }
            socket.endHandler(v -> this.testComplete());
        };
        this.startServers(new SockJSHandlerOptions());
        this.client.webSocket("/test/websocket", this.onSuccess(ws -> ws.frameHandler(frame -> {
            if (!frame.isClose()) {
                if (text) {
                    this.assertTrue(frame.isText());
                    this.assertEquals(expected, frame.textData());
                } else {
                    this.assertTrue(frame.isBinary());
                    this.assertEquals(Buffer.buffer((String)expected), frame.binaryData());
                }
                ws.end();
            }
        })));
        this.await();
    }
}

