/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocketBase;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import io.vertx.test.core.TestUtils;
import org.junit.Test;

public class SockJSWriteTest
extends SockJSTestBase {
    @Test
    public void testRaw() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.webSocket("/test/websocket", this.onSuccess(ws -> ws.handler(buffer -> {
            if (buffer.toString().equals(expected)) {
                this.complete();
            }
        })));
        this.await();
    }

    @Test
    public void testRawFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.webSocket("/test/websocket", this.onSuccess(WebSocketBase::close));
        this.await();
    }

    @Test
    public void testWebSocket() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.webSocket("/test/400/8ne8e94a/websocket", this.onSuccess(ws -> ws.handler(buffer -> {
            if (buffer.toString().equals("a[\"" + expected + "\"]")) {
                this.complete();
            }
        })));
        this.await();
    }

    @Test
    public void testWebSocketFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.webSocket("/test/400/8ne8e94a/websocket", this.onSuccess(WebSocketBase::close));
        this.await();
    }

    @Test
    public void testEventSource() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.request(HttpMethod.GET, "/test/400/8ne8e94a/eventsource").onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.handler(buffer -> {
            if (buffer.toString().equals("data: a[\"" + expected + "\"]\r\n\r\n")) {
                this.complete();
            }
        })))));
        this.await();
    }

    @Test
    public void testEventSourceFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.request(HttpMethod.GET, "/test/400/8ne8e94a/eventsource").onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> req.connection().close()))));
        this.await();
    }

    @Test
    public void testXHRStreaming() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr_streaming").onComplete(this.onSuccess(req -> req.send(Buffer.buffer(), this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.handler(buffer -> {
                if (buffer.toString().equals("a[\"" + expected + "\"]\n")) {
                    this.complete();
                }
            });
        }))));
        this.await();
    }

    @Test
    public void testXHRStreamingFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr_streaming").onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> req.connection().close()))));
        this.await();
    }

    @Test
    public void testXHRPolling() throws Exception {
        Runnable[] task;
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        task = new Runnable[]{() -> this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr").onComplete(this.onSuccess(req -> req.send(Buffer.buffer(), this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.handler(buffer -> {
                if (buffer.toString().equals("a[\"" + expected + "\"]\n")) {
                    this.complete();
                } else {
                    task[0].run();
                }
            });
        }))))};
        task[0].run();
        this.await();
    }

    @Test
    public void testXHRPollingClose() throws Exception {
        this.waitFor(3);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete()));
            socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete())));
            socket.close();
        };
        this.startServers();
        this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr").onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testXHRPollingShutdown() throws Exception {
        this.waitFor(3);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete()));
            socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete())));
        };
        this.startServers();
        this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr").onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }))));
        this.await();
    }
}

