/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.NetClient;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.impl.Utils;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class ForwardedTest
extends WebTestBase {
    @Test
    public void testXForwardSSL() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("X-Forwarded-Ssl", "On");
    }

    @Test
    public void testXForwardSSLVariation2() throws Exception {
        this.router.allowForward(AllowForwardHeaders.FORWARD).route("/").handler(rc -> {
            this.assertFalse(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "http");
            rc.end();
        });
        this.testRequest("X-Forwarded-Ssl", "On");
    }

    @Test
    public void testXForwardSSLVariation3() throws Exception {
        this.router.allowForward(AllowForwardHeaders.X_FORWARD).route("/").handler(rc -> {
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("X-Forwarded-Ssl", "On");
    }

    @Test
    public void testXForwardedForIpv6() throws Exception {
        String host = "[2001:db8:cafe::17]";
        int port = 4711;
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            this.assertTrue(rc.request().remoteAddress().port() == port);
            rc.end();
        });
        this.testRequest("X-Forwarded-For", host + ":" + port);
    }

    @Test
    public void testXForwardedForIpv6NoPort() throws Exception {
        String host = "[2001:db8:cafe::17]";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            rc.end();
        });
        this.testRequest("X-Forwarded-For", host);
    }

    @Test
    public void testXForwardedForRawIpv6NoPort() throws Exception {
        String host = "2001:db8:85a3:8d3:1319:8a2e:370:9c82";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            rc.end();
        });
        this.testRequest("X-Forwarded-For", host);
    }

    @Test
    public void testForwardedProto() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("Forwarded", "proto=https");
    }

    @Test
    public void testForwardedHostAlongWithXForwardSSL() throws Exception {
        String host = "vertx.io";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("Forwarded", "host=" + host, "X-Forwarded-Ssl", "On");
    }

    @Test
    public void testMultipleForwarded() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("Forwarded", "proto=https,proto=http");
    }

    @Test
    public void testForwardedProtoAlongWIthXForwardSSL() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertFalse(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "http");
            rc.end();
        });
        this.testRequest("Forwarded", "proto=http", "X-Forwarded-Ssl", "On");
    }

    @Test
    public void testForwardedHost() throws Exception {
        String host = "vertx.io";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().host(), host);
            rc.end();
        });
        this.testRequest("Forwarded", "host=" + host);
    }

    @Test
    public void testForwardedHostAndPort() throws Exception {
        String host = "vertx.io:1234";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            rc.end();
        });
        this.testRequest("Forwarded", "host=" + host);
    }

    @Test
    public void testForwardedHostAndPortAndProto() throws Exception {
        String host = "vertx.io:1234";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("Forwarded", "host=" + host + ";proto=https");
    }

    @Test
    public void testXForwardedProto() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "https");
            rc.end();
        });
        this.testRequest("x-forwarded-proto", "https");
    }

    @Test
    public void testXForwardedProtoAlongWIthXForwardSSL() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertFalse(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "http");
            rc.end();
        });
        this.testRequest("x-FORWARDED-proto", "http", "X-Forwarded-Ssl", "On");
    }

    @Test
    public void testXForwardedHost() throws Exception {
        String host = "vertx.io";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            rc.end();
        });
        this.testRequest("X-Forwarded-Host", host);
    }

    @Test
    public void testXForwardedHostAndPort() throws Exception {
        String host = "vertx.io:4321";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            rc.end();
        });
        this.testRequest("X-Forwarded-Host", host);
    }

    @Test
    public void testXForwardedHostRemovesCommonPort() throws Exception {
        String host = "vertx.io";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            rc.end();
        });
        this.testRequest("X-Forwarded-Host", host + ":80");
    }

    @Test
    public void testXForwardedHostMultiple() throws Exception {
        String host = "vertx.io";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertEquals(rc.request().host(), host);
            this.assertEquals(rc.request().authority().toString(), host);
            rc.end();
        });
        this.testRequest("X-Forwarded-Host", host + ",www.google.com");
    }

    @Test
    public void testXForwardedPort() throws Exception {
        String port = "1234";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().host().endsWith(":" + port));
            this.assertTrue(rc.request().authority().toString().endsWith(":" + port));
            rc.end();
        });
        this.testRequest("X-Forwarded-Port", port);
    }

    @Test
    public void testXForwardedPortAndHost() throws Exception {
        String host = "vertx.io";
        String port = "1234";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().host().equals(host + ":" + port));
            this.assertTrue(rc.request().authority().toString().equals(host + ":" + port));
            rc.end();
        });
        this.testRequest("X-Forwarded-Host", host, "X-Forwarded-Port", port);
    }

    @Test
    public void testXForwardedPortAndHostWithPort() throws Exception {
        String host = "vertx.io";
        String port = "1234";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().host().equals(host + ":" + port));
            this.assertTrue(rc.request().authority().toString().equals(host + ":" + port));
            rc.end();
        });
        this.testRequest("X-Forwarded-Host", host + ":4321", "X-Forwarded-Port", port);
    }

    @Test
    public void testIllegalPort() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().host().endsWith(":8080"));
            this.assertTrue(rc.request().authority().toString().endsWith(":8080"));
            rc.end();
        });
        this.testRequest("X-Forwarded-Port", "illegal");
    }

    @Test
    public void testXForwardedFor() throws Exception {
        String host = "1.2.3.4";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            rc.end();
        });
        this.testRequest("X-Forwarded-For", host);
    }

    @Test
    public void testXForwardedForWithPort() throws Exception {
        String host = "1.2.3.4";
        int port = 1111;
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            this.assertTrue(rc.request().remoteAddress().port() == port);
            rc.end();
        });
        this.testRequest("X-Forwarded-For", host + ":" + port);
    }

    @Test
    public void testForwardedFor() throws Exception {
        String host = "1.2.3.4";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            rc.end();
        });
        this.testRequest("Forwarded", "for=" + host);
    }

    @Test
    public void testForwardedForIpv6() throws Exception {
        String host = "[2001:db8:cafe::17]";
        int port = 4711;
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals(host));
            this.assertTrue(rc.request().remoteAddress().port() == port);
            rc.end();
        });
        this.testRequest("Forwarded", "for=\"" + host + ":" + port + "\"");
    }

    @Test
    public void testNoneMissingHostHeader() throws Exception {
        this.testMissingHostHeader(this.router.allowForward(AllowForwardHeaders.NONE).route("/"));
    }

    @Test
    public void testAllMissingHostHeader() throws Exception {
        this.testMissingHostHeader(this.router.allowForward(AllowForwardHeaders.ALL).route("/"));
    }

    @Test
    public void testForwardMissingHostHeader() throws Exception {
        this.testMissingHostHeader(this.router.allowForward(AllowForwardHeaders.FORWARD).route("/"));
    }

    @Test
    public void testXForwardMissingHostHeader() throws Exception {
        this.testMissingHostHeader(this.router.allowForward(AllowForwardHeaders.X_FORWARD).route("/"));
    }

    @Test
    public void testMissingHostHeader() throws Exception {
        this.testMissingHostHeader(this.router.allowForward(AllowForwardHeaders.ALL).route("/"));
    }

    private void testMissingHostHeader(Route route) throws Exception {
        route.handler(rc -> {
            this.assertNull(rc.request().authority());
            this.assertNull(rc.request().host());
            rc.end();
        });
        try (NetClient tcpClient = this.vertx.createNetClient();){
            tcpClient.connect(8080, "localhost").onComplete(this.onSuccess(so -> {
                so.write("GET / HTTP/1.1\r\n\r\n");
                so.handler(buff -> this.testComplete());
            }));
            this.await();
        }
    }

    @Test
    public void testNoForwarded() throws Exception {
        this.router.allowForward(AllowForwardHeaders.ALL).route("/").handler(rc -> {
            this.assertTrue(rc.request().remoteAddress().host().equals("127.0.0.1"));
            this.assertTrue(rc.request().host().equals("localhost:8080"));
            this.assertTrue(rc.request().authority().toString().equals("localhost:8080"));
            this.assertTrue(rc.request().scheme().equals("http"));
            this.assertFalse(rc.request().isSSL());
            rc.end();
        });
        this.testRequest(new String[0]);
    }

    @Test
    public void testForwardedDisabled() throws Exception {
        this.router.allowForward(AllowForwardHeaders.NONE).route("/").handler(rc -> {
            this.assertFalse(rc.request().isSSL());
            this.assertEquals(rc.request().scheme(), "http");
            rc.end();
        });
        this.testRequest("Forwarded", "proto=https");
    }

    private void testRequest(String ... headers) throws Exception {
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> {
            int i = 0;
            while (i < headers.length) {
                req.putHeader(headers[i++], headers[i++]);
            }
        }, 200, "OK", null);
    }

    @Test
    public void testForwardedForAndWebSocket() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        String host = "vertx.io:1234";
        String address = "1.2.3.4";
        this.router.allowForward(AllowForwardHeaders.ALL).route("/ws").handler(rc -> {
            HttpServerRequest request = rc.request();
            if (Utils.canUpgradeToWebsocket((HttpServerRequest)request)) {
                request.toWebSocket(this.onSuccess(socket -> {
                    this.assertTrue(socket.host().equals(host));
                    this.assertTrue(socket.authority().toString().equals(host));
                    this.assertTrue(socket.isSsl());
                    this.assertTrue(socket.remoteAddress().host().equals(address));
                    latch.countDown();
                }));
            } else {
                this.fail("Expected websocket connection");
            }
        });
        this.client.webSocket(new WebSocketConnectOptions().setURI("/ws").addHeader("Forwarded", "host=" + host + ";proto=https;for=" + address), this.onSuccess(e -> latch.countDown()));
        this.awaitLatch(latch);
    }
}

