/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.PlatformHandler;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.test.core.TestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RouterTest
extends WebTestBase {
    @Test
    public void testSimpleRoute() throws Exception {
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testSimpleRoute2() throws Exception {
        this.router.route("/*").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testSimpleFunction() throws Exception {
        this.router.route().respond(rc -> this.vertx.fileSystem().readFile(rc.queryParams().get("file")));
        Buffer expected = this.vertx.fileSystem().readFileBlocking(".htdigest");
        this.testRequestBuffer(HttpMethod.GET, "/?file=.htdigest", null, (HttpClientResponse res) -> this.assertEquals(res.getHeader("Content-Type"), "application/octet-stream"), 200, "OK", expected);
    }

    @Test
    public void testSimpleFunction2() throws Exception {
        this.router.route().respond(ctx -> ctx.response().putHeader("Content-Type", "octet/binary").end(Buffer.buffer((String)"durp")));
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("octet/binary", res.getHeader("Content-Type")), 200, "OK", "durp");
    }

    @Test
    public void testSimpleFunction3() throws Exception {
        this.router.route().respond(ctx -> ctx.response().putHeader("Content-Type", "octet/binary").setChunked(true).write("XYZ"));
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("octet/binary", res.getHeader("Content-Type")), 200, "OK", "XYZ");
    }

    @Test
    public void testRouteFunctionWithBufferedPayload() throws Exception {
        this.router.get("/hello").produces("application/json").handler((Handler)ResponseContentTypeHandler.create()).respond(rc -> Future.succeededFuture((Object)new JsonObject().put("hello", (Object)"world")));
        this.testRequest(HttpMethod.GET, "/hello", null, res -> this.assertEquals("application/json", res.getHeader("Content-Type")), 200, "OK", "{\"hello\":\"world\"}");
    }

    @Test
    public void testRouteFunctionWithException() throws Exception {
        this.router.get("/hello").produces("application/json").handler((Handler)ResponseContentTypeHandler.create()).respond(rc -> {
            throw new RuntimeException("Boom!");
        });
        this.testRequest(HttpMethod.GET, "/hello", 500, "Internal Server Error");
    }

    @Test
    public void testInvalidPath() throws Exception {
        try {
            this.router.route("blah");
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.router.route().path("blah");
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRouteGetPath() throws Exception {
        this.assertEquals("/foo", this.router.route("/foo").getPath());
        this.assertEquals("/foo/:id", this.router.route("/foo/:id").getPath());
    }

    @Test
    public void testRouteGetPathWithParamsInHandler() throws Exception {
        this.router.route("/foo/:id").handler(rc -> {
            this.assertEquals("/foo/123", rc.normalizedPath());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo/123", 200, "OK");
    }

    @Test
    public void testRouteDashVariable() throws Exception {
        this.router.route("/foo/:my-id").handler(rc -> {
            this.assertEquals("123", rc.pathParam("my-id"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo/123", 404, "Not Found");
    }

    @Test
    public void testRouteDashVariableOK() throws Exception {
        this.router.route("/flights/:from-:to").handler(rc -> {
            this.assertEquals("LAX", rc.pathParam("from"));
            this.assertEquals("SFO", rc.pathParam("to"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/flights/LAX-SFO", 200, "OK");
    }

    @Test
    public void testSlashPaths() throws Exception {
        this.router.route("/foo/").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/foo", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo//", 200, "OK");
    }

    @Test
    public void testSlashPaths2() throws Exception {
        this.router.route("/foo").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo//", 200, "OK");
    }

    @Test
    public void testSlashPathsWithParams() throws Exception {
        this.router.route("/foo/:id").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/foo/123", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo/123/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo//123/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo//123//", 200, "OK");
    }

    @Test
    public void testRoutePathAndMethod() throws Exception {
        for (HttpMethod meth : METHODS) {
            this.testRoutePathAndMethod(meth, true);
        }
    }

    @Test
    public void testRoutePathAndMethodBegin() throws Exception {
        for (HttpMethod meth : METHODS) {
            this.testRoutePathAndMethod(meth, false);
        }
    }

    private void testRoutePathAndMethod(HttpMethod method, boolean exact) throws Exception {
        String path = "/blah";
        this.router.clear();
        this.router.route(method, exact ? path : path + "*").handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        if (exact) {
            this.testPathExact(method, path);
        } else {
            this.testPathBegin(method, path);
        }
        for (HttpMethod meth : METHODS) {
            if (meth == method) continue;
            this.testRequest(meth, path, HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
    }

    @Test
    public void testRoutePathOnly() throws Exception {
        String path1 = "/blah";
        this.router.route(path1).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        String path2 = "/quux";
        this.router.route(path2).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathExact(path1);
        this.testPathExact(path2);
    }

    @Test
    public void testRoutePathOnlyBegin() throws Exception {
        String path1 = "/blah";
        this.router.route(path1 + "*").handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        String path2 = "/quux";
        this.router.route(path2 + "*").handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathBegin(path1);
        this.testPathBegin(path2);
    }

    @Test
    public void testRoutePathWithTrailingSlashOnlyBegin() throws Exception {
        String path = "/some/path/";
        this.router.route(path + "*").handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathBegin(path);
    }

    @Test
    public void testRoutePathBuilder() throws Exception {
        String path = "/blah";
        this.router.route().path(path).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathExact(path);
    }

    @Test
    public void testRoutePathBuilderBegin() throws Exception {
        String path = "/blah";
        this.router.route().path(path + "*").handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathBegin(path);
    }

    @Test
    public void testRoutePathAndMethodBuilder() throws Exception {
        String path = "/blah";
        this.router.route().path(path).method(HttpMethod.GET).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathExact(HttpMethod.GET, path);
        this.testRequest(HttpMethod.POST, path, HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testRoutePathAndMethodBuilderBegin() throws Exception {
        String path = "/blah";
        this.router.route().path(path + "*").method(HttpMethod.GET).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathBegin(HttpMethod.GET, path);
        this.testRequest(HttpMethod.POST, path, HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testRoutePathAndMultipleMethodBuilder() throws Exception {
        String path = "/blah";
        this.router.route().path(path).method(HttpMethod.GET).method(HttpMethod.POST).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathExact(HttpMethod.GET, path);
        this.testPathExact(HttpMethod.POST, path);
        this.testRequest(HttpMethod.PUT, path, HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testRoutePathAndMultipleMethodBuilderBegin() throws Exception {
        String path = "/blah";
        this.router.route().path(path + "*").method(HttpMethod.GET).method(HttpMethod.POST).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testPathBegin(HttpMethod.GET, path);
        this.testPathBegin(HttpMethod.POST, path);
        this.testRequest(HttpMethod.PUT, path, HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    private void testPathBegin(String path) throws Exception {
        for (HttpMethod meth : METHODS) {
            this.testPathBegin(meth, path);
        }
    }

    private void testPathExact(String path) throws Exception {
        for (HttpMethod meth : METHODS) {
            this.testPathExact(meth, path);
        }
    }

    private void testPathBegin(HttpMethod method, String path) throws Exception {
        this.testRequest(method, path, 200, path);
        this.testRequest(method, path + "wibble", 200, path + "wibble");
        if (path.endsWith("/")) {
            this.testRequest(method, path.substring(0, path.length() - 1) + "wibble", 404, "Not Found");
            this.testRequest(method, path.substring(0, path.length() - 1) + "/wibble", 200, path.substring(0, path.length() - 1) + "/wibble");
        } else {
            this.testRequest(method, path + "/wibble", 200, path + "/wibble");
            this.testRequest(method, path + "/wibble/floob", 200, path + "/wibble/floob");
            this.testRequest(method, path.substring(0, path.length() - 1), 404, "Not Found");
        }
        this.testRequest(method, "/", 404, "Not Found");
        this.testRequest(method, "/" + UUID.randomUUID().toString(), 404, "Not Found");
    }

    private void testPathExact(HttpMethod method, String path) throws Exception {
        this.testRequest(method, path, 200, path);
        this.testRequest(method, path + "wibble", 404, "Not Found");
        this.testRequest(method, path + "/wibble", 404, "Not Found");
        this.testRequest(method, path + "/wibble/floob", 404, "Not Found");
        this.testRequest(method, path.substring(0, path.length() - 1), 404, "Not Found");
        this.testRequest(method, "/", 404, "Not Found");
        this.testRequest(method, "/" + UUID.randomUUID().toString(), 404, "Not Found");
    }

    @Test
    public void testRouteNoPath() throws Exception {
        this.router.route().handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        for (HttpMethod meth : METHODS) {
            this.testNoPath(meth);
        }
    }

    @Test
    public void testRouteNoPath2() throws Exception {
        this.router.route().handler(rc -> {
            rc.response().setStatusMessage(rc.request().path());
            rc.next();
        });
        this.router.route().handler(rc -> rc.response().setStatusCode(200).end());
        for (HttpMethod meth : METHODS) {
            this.testNoPath(meth);
        }
    }

    @Test
    public void testRouteNoPathWithMethod() throws Exception {
        for (HttpMethod meth : METHODS) {
            this.testRouteNoPathWithMethod(meth);
        }
    }

    private void testRouteNoPathWithMethod(HttpMethod meth) throws Exception {
        this.router.clear();
        this.router.route().method(meth).handler(rc -> rc.response().setStatusCode(200).setStatusMessage(rc.request().path()).end());
        this.testNoPath(meth);
        for (HttpMethod m : METHODS) {
            if (m == meth) continue;
            this.testRequest(m, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
    }

    private void testNoPath(HttpMethod method) throws Exception {
        this.testRequest(method, "/", 200, "/");
        this.testRequest(method, "/wibble", 200, "/wibble");
        String rand = "/" + UUID.randomUUID().toString();
        this.testRequest(method, rand, 200, rand);
    }

    @Test
    public void testChaining() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("apples");
            rc.next();
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("oranges");
            rc.next();
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesorangesbananas");
    }

    @Test
    public void testAsyncChaining() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("apples");
            this.vertx.runOnContext(v -> rc.next());
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("oranges");
            this.vertx.runOnContext(v -> rc.next());
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesorangesbananas");
    }

    @Test
    public void testChainingWithTimers() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("apples");
            this.vertx.setTimer(1L, v -> rc.next());
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("oranges");
            this.vertx.setTimer(1L, v -> rc.next());
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesorangesbananas");
    }

    @Test
    public void testOrdering() throws Exception {
        String path = "/blah";
        this.router.route(path).order(1).handler(rc -> {
            rc.response().write("apples");
            rc.next();
        });
        this.router.route(path).order(2).handler(rc -> {
            rc.response().write("oranges");
            rc.response().end();
        });
        this.router.route(path).order(0).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("bananas");
            rc.next();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "bananasapplesoranges");
    }

    @Test
    public void testLast() throws Exception {
        String path = "/blah";
        Route route = this.router.route(path);
        this.router.route(path).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("oranges");
            rc.next();
        });
        this.router.route(path).handler(rc -> {
            rc.response().write("bananas");
            rc.next();
        });
        route.last();
        route.handler(rc -> {
            rc.response().write("apples");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "orangesbananasapples");
    }

    @Test
    public void testDisableEnable() throws Exception {
        String path = "/blah";
        Route route1 = this.router.route(path).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("apples");
            rc.next();
        });
        Route route2 = this.router.route(path).handler(rc -> {
            rc.response().write("oranges");
            rc.next();
        });
        Route route3 = this.router.route(path).handler(rc -> {
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesorangesbananas");
        route2.disable();
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesbananas");
        route1.disable();
        route3.disable();
        this.testRequest(HttpMethod.GET, path, 404, "Not Found");
        route3.enable();
        route1.enable();
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesbananas");
        route2.enable();
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesorangesbananas");
    }

    @Test
    public void testRemove() throws Exception {
        String path = "/blah";
        Route route1 = this.router.route(path).handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("apples");
            rc.next();
        });
        Route route2 = this.router.route(path).handler(rc -> {
            rc.response().write("oranges");
            rc.next();
        });
        Route route3 = this.router.route(path).handler(rc -> {
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesorangesbananas");
        route2.remove();
        this.testRequest(HttpMethod.GET, path, 200, "OK", "applesbananas");
        route1.remove();
        route3.remove();
        this.testRequest(HttpMethod.GET, path, 404, "Not Found");
    }

    @Test
    public void testClear() throws Exception {
        this.router.route().handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("apples");
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/whatever", 200, "OK", "applesbananas");
        this.router.clear();
        this.router.route().handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("grapes");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/whatever", 200, "OK", "grapes");
    }

    @Test
    public void testChangeOrderAfterActive1() throws Exception {
        String path = "/blah";
        Route route = this.router.route(path).handler(rc -> {
            rc.response().write("apples");
            rc.next();
        });
        try {
            route.order(23);
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testChangeOrderAfterActive2() throws Exception {
        String path = "/blah";
        Route route = this.router.route(path).failureHandler(rc -> {
            rc.response().write("apples");
            rc.next();
        });
        try {
            route.order(23);
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNextAfterResponseEnded() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            rc.response().end();
            rc.next();
        });
        this.router.route(path).handler(rc -> this.assertTrue(rc.response().ended()));
        this.testRequest(HttpMethod.GET, path, 200, "OK");
    }

    @Test
    public void testFailureHandler1() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        }).failureHandler(frc -> frc.response().setStatusCode(555).setStatusMessage("oh dear").end());
        this.testRequest(HttpMethod.GET, path, 555, "oh dear");
    }

    @Test
    public void testFailureinHandlingFailure() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        }).failureHandler(frc -> {
            throw new RuntimeException("super ouch!");
        });
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testFailureUsingInvalidCharsInStatus() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> rc.response().setStatusMessage("Hello\nWorld!").end());
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testFailureinHandlingFailureWithInvalidStatusMessage() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        }).failureHandler(frc -> frc.response().setStatusMessage("Hello\nWorld").end());
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testSetExceptionHandler() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.router.errorHandler(500, ctx -> {
            Throwable t = ctx.failure();
            this.assertEquals("ouch!", t.getMessage());
            latch.countDown();
        });
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
        this.awaitLatch(latch);
    }

    @Test
    public void testFailureHandler1CallFail() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> rc.fail(400)).failureHandler(frc -> {
            this.assertEquals(400L, frc.statusCode());
            frc.response().setStatusCode(400).setStatusMessage("oh dear").end();
        });
        this.testRequest(HttpMethod.GET, path, 400, "oh dear");
    }

    @Test
    public void testFailureHandler2() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        });
        this.router.route("/bl*").failureHandler(frc -> frc.response().setStatusCode(555).setStatusMessage("oh dear").end());
        this.testRequest(HttpMethod.GET, path, 555, "oh dear");
    }

    @Test
    public void testFailureHandler2CallFail() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> rc.fail(400));
        this.router.route("/bl*").failureHandler(frc -> {
            this.assertEquals(400L, frc.statusCode());
            frc.response().setStatusCode(400).setStatusMessage("oh dear").end();
        });
        this.testRequest(HttpMethod.GET, path, 400, "oh dear");
    }

    @Test
    public void testDefaultFailureHandler() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        });
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testDefaultFailureHandlerCallFail() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> rc.fail(400));
        this.testRequest(HttpMethod.GET, path, 400, "Bad Request");
    }

    @Test
    public void testFailureHandlerNoMatch() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> {
            throw new RuntimeException("ouch!");
        });
        this.router.route("/other").failureHandler(frc -> frc.response().setStatusCode(555).setStatusMessage("oh dear").end());
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testFailureWithThrowable() throws Exception {
        String path = "/blah";
        Throwable failure = new Throwable();
        this.router.route(path).handler(rc -> rc.fail(failure)).failureHandler(frc -> {
            this.assertEquals(500L, frc.statusCode());
            this.assertSame(failure, frc.failure());
            frc.response().setStatusCode(500).setStatusMessage("Internal Server Error").end();
        });
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testFailureWithNullThrowable() throws Exception {
        String path = "/blah";
        this.router.route(path).handler(rc -> rc.fail(null)).failureHandler(frc -> {
            this.assertEquals(500L, frc.statusCode());
            this.assertTrue(frc.failure() instanceof NullPointerException);
            frc.response().setStatusCode(500).setStatusMessage("Internal Server Error").end();
        });
        this.testRequest(HttpMethod.GET, path, 500, "Internal Server Error");
    }

    @Test
    public void testPattern1() throws Exception {
        this.router.route("/:abc").handler(rc -> rc.response().setStatusMessage(rc.request().params().get("abc")).end());
        this.testPattern("/tim", "tim");
    }

    @Test
    public void testParamEscape() throws Exception {
        this.router.route("/demo/:abc").handler(rc -> {
            this.assertEquals("Hello World!", rc.request().params().get("abc"));
            rc.response().end(rc.request().params().get("abc"));
        });
        this.testRequest(HttpMethod.GET, "/demo/Hello%20World!", 200, "OK", "Hello World!");
    }

    @Test
    public void testParamEscape2() throws Exception {
        this.router.route("/demo/:abc").handler(rc -> {
            this.assertEquals("Hello/World!", rc.request().params().get("abc"));
            rc.response().end(rc.request().params().get("abc"));
        });
        this.testRequest(HttpMethod.GET, "/demo/Hello%2FWorld!", 200, "OK", "Hello/World!");
    }

    @Test
    public void testParamEscape3() throws Exception {
        this.router.route("/demo/:abc").handler(rc -> {
            this.assertEquals("http://www.google.com", rc.request().params().get("abc"));
            rc.response().end(rc.request().params().get("abc"));
        });
        this.testRequest(HttpMethod.GET, "/demo/http%3A%2F%2Fwww.google.com", 200, "OK", "http://www.google.com");
    }

    @Test
    public void testParamEscape4() throws Exception {
        this.router.route("/:var").handler(rc -> {
            this.assertEquals("/ping", rc.request().params().get("var"));
            rc.response().end(rc.request().params().get("var"));
        });
        this.testRequest(HttpMethod.GET, "/%2Fping", 200, "OK", "/ping");
    }

    @Test
    public void testPattern1WithMethod() throws Exception {
        this.router.route(HttpMethod.GET, "/:abc").handler(rc -> rc.response().setStatusMessage(rc.request().params().get("abc")).end());
        this.testPattern("/tim", "tim");
        this.testRequest(HttpMethod.POST, "/tim", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPattern1WithBuilder() throws Exception {
        this.router.route().path("/:abc").handler(rc -> rc.response().setStatusMessage(rc.request().params().get("abc")).end());
        this.testPattern("/tim", "tim");
    }

    @Test
    public void testPattern2() throws Exception {
        this.router.route("/blah/:abc").handler(rc -> rc.response().setStatusMessage(rc.request().params().get("abc")).end());
        this.testPattern("/blah/tim", "tim");
    }

    @Test
    public void testPattern3() throws Exception {
        this.router.route("/blah/:abc/blah").handler(rc -> rc.response().setStatusMessage(rc.request().params().get("abc")).end());
        this.testPattern("/blah/tim/blah", "tim");
    }

    @Test
    public void testPattern4() throws Exception {
        this.router.route("/blah/:abc/foo").handler(rc -> rc.response().setStatusMessage(rc.request().params().get("abc")).end());
        this.testPattern("/blah/tim/foo", "tim");
    }

    @Test
    public void testPattern5() throws Exception {
        this.router.route("/blah/:abc/:def/:ghi").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("abc") + params.get("def") + params.get("ghi")).end();
        });
        this.testPattern("/blah/tim/julien/nick", "timjuliennick");
    }

    @Test
    public void testPattern6() throws Exception {
        this.router.route("/blah/:abc/:def/:ghi/blah").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("abc") + params.get("def") + params.get("ghi")).end();
        });
        this.testPattern("/blah/tim/julien/nick/blah", "timjuliennick");
    }

    @Test
    public void testPattern7() throws Exception {
        this.router.route("/blah/:abc/quux/:def/eep/:ghi").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("abc") + params.get("def") + params.get("ghi")).end();
        });
        this.testPattern("/blah/tim/quux/julien/eep/nick", "timjuliennick");
    }

    @Test
    public void testPercentEncoding() throws Exception {
        this.router.route("/blah/:percenttext").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("percenttext")).end();
        });
        this.testPattern("/blah/abc%25xyz", "abc%xyz");
    }

    @Test
    public void testPathParamsAreFulfilled() throws Exception {
        this.router.route("/blah/:abc/quux/:def/eep/:ghi").handler(rc -> {
            Map params = rc.pathParams();
            rc.response().setStatusMessage((String)params.get("abc") + (String)params.get("def") + (String)params.get("ghi")).end();
        });
        this.testPattern("/blah/tim/quux/julien/eep/nick", "timjuliennick");
    }

    @Test
    public void testPathParamsDoesNotOverrideQueryParam() throws Exception {
        String paramName = "param";
        String pathParamValue = "pathParamValue";
        String queryParamValue1 = "queryParamValue1";
        String queryParamValue2 = "queryParamValue2";
        String sep = ",";
        this.router.route("/blah/:param/test").handler(rc -> {
            Map params = rc.pathParams();
            MultiMap queryParams = rc.request().params();
            List values = queryParams.getAll("param");
            String qValue = values.stream().collect(Collectors.joining(","));
            rc.response().setStatusMessage((String)params.get("param") + "|" + qValue).end();
        });
        this.testRequest(HttpMethod.GET, "/blah/pathParamValue/test?param=queryParamValue1&param=queryParamValue2", 200, "pathParamValue|queryParamValue1,queryParamValue2");
    }

    @Test
    public void testCorrectQueryParamatersEncapsulation() throws Exception {
        String pathParameterName = "pathParameter";
        String pathParamValue = "awesomePath";
        String qName = "q";
        String qValue1 = "a";
        String qValue2 = "b";
        String sName = "s";
        String sValue = "sample_value";
        String sep = ",";
        this.router.route("/blah/:pathParameter/test").handler(rc -> {
            MultiMap params = rc.queryParams();
            this.assertFalse(params.contains("pathParameter"));
            String qExpected = String.join((CharSequence)",", params.getAll("q"));
            String statusMessage = String.join((CharSequence)"/", qExpected, params.get("s"));
            rc.response().setStatusMessage(statusMessage).end();
        });
        this.testRequest(HttpMethod.GET, "/blah/awesomePath/test?q=a,b&s=sample_value", 200, "a,b/sample_value");
    }

    @Test
    public void testPathParamsWithReroute() throws Exception {
        String paramName = "param";
        String firstParamValue = "fpv";
        String secondParamValue = "secondParamValue";
        this.router.route("/first/:" + paramName + "/route").handler(rc -> {
            this.assertEquals(firstParamValue, rc.pathParam(paramName));
            rc.reroute(HttpMethod.GET, "/second/" + secondParamValue + "/route");
        });
        this.router.route("/second/:" + paramName + "/route").handler(rc -> rc.response().setStatusMessage(rc.pathParam(paramName)).end());
        this.testRequest(HttpMethod.GET, "/first/" + firstParamValue + "/route", 200, secondParamValue);
    }

    private void testPattern(String pathRoot, String expected) throws Exception {
        this.testRequest(HttpMethod.GET, pathRoot, 200, expected);
        this.testRequest(HttpMethod.GET, pathRoot + "/", 200, expected);
        this.testRequest(HttpMethod.GET, pathRoot + "/wibble", 404, "Not Found");
        this.testRequest(HttpMethod.GET, pathRoot + "/wibble/blibble", 404, "Not Found");
    }

    private void testPatternStrict(String pathRoot, String expected) throws Exception {
        this.testRequest(HttpMethod.GET, pathRoot, 200, expected);
        this.testRequest(HttpMethod.GET, pathRoot + "/", 404, "Not Found");
        this.testRequest(HttpMethod.GET, pathRoot + "/wibble", 404, "Not Found");
        this.testRequest(HttpMethod.GET, pathRoot + "/wibble/blibble", 404, "Not Found");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPattern() throws Exception {
        this.router.route("/blah/:!!!/").handler(rc -> {});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPatternWithBuilder() throws Exception {
        this.router.route().path("/blah/:!!!/").handler(rc -> {});
    }

    @Test
    public void testGroupMoreThanOne() throws Exception {
        try {
            this.router.route("/blah/:abc/:abc");
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRegex1() throws Exception {
        this.router.routeWithRegex("\\/([^\\/]+)\\/([^\\/]+)").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("param0") + params.get("param1")).end();
        });
        this.testPatternStrict("/dog/cat", "dogcat");
    }

    @Test
    public void testRegex1WithBuilder() throws Exception {
        this.router.route().pathRegex("\\/([^\\/]+)\\/([^\\/]+)").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("param0") + params.get("param1")).end();
        });
        this.testPatternStrict("/dog/cat", "dogcat");
    }

    @Test
    public void testRegex1WithMethod() throws Exception {
        this.router.routeWithRegex(HttpMethod.GET, "\\/([^\\/]+)\\/([^\\/]+)").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("param0") + params.get("param1")).end();
        });
        this.testPatternStrict("/dog/cat", "dogcat");
        this.testRequest(HttpMethod.POST, "/dog/cat", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testRegex2() throws Exception {
        this.router.routeWithRegex("\\/([^\\/]+)\\/([^\\/]+)/blah").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("param0") + params.get("param1")).end();
        });
        this.testPatternStrict("/dog/cat/blah", "dogcat");
    }

    @Test
    public void testRegex3() throws Exception {
        this.router.routeWithRegex(".*foo.txt").handler(rc -> rc.response().setStatusMessage("ok").end());
        this.testPatternStrict("/dog/cat/foo.txt", "ok");
        this.testRequest(HttpMethod.POST, "/dog/cat/foo.bar", 404, "Not Found");
    }

    @Test
    public void testRegexWithNamedParams() throws Exception {
        this.router.routeWithRegex(HttpMethod.GET, "\\/(?<name>[^\\/]+)\\/(?<surname>[^\\/]+)").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("name") + params.get("surname")).end();
        });
        this.testPatternStrict("/joe/doe", "joedoe");
    }

    @Test
    public void testRegexWithNamedParamsKeepsIndexedParams() throws Exception {
        this.router.routeWithRegex(HttpMethod.GET, "\\/(?<name>[^\\/]+)\\/(?<surname>[^\\/]+)").handler(rc -> {
            MultiMap params = rc.request().params();
            rc.response().setStatusMessage(params.get("param0") + params.get("param1")).end();
        });
        this.testPatternStrict("/joe/doe", "joedoe");
    }

    @Test
    public void testConsumes() throws Exception {
        this.router.route().consumes("text/html").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/json", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "something/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesWithParameterKey() throws Exception {
        this.router.route().consumes("text/html;boo").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=ya;itWorks=4real", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo;itWorks", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=ya", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesWithParameter() throws Exception {
        this.router.route().consumes("text/html;boo=ya").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=ya", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesWithQuotedParameterWithComma() throws Exception {
        this.router.route().consumes("text/html;boo=\"yeah,right\"").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=\"yeah,right\";itWorks=4real", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=\"yeah,right\"", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=\"yeah,right;itWorks=4real\"", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=yeah,right", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesWithQuotedParameterWithQuotes() throws Exception {
        this.router.route().consumes("text/html;boo=\"yeah\\\"right\"").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=\"yeah\\\"right\"", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=\"yeah,right\"", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=yeah,right", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesWithQParameterIgnored() throws Exception {
        this.router.route().consumes("text/html;q").consumes("text/html;q=0.1").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=yeah,right", 200, "OK");
    }

    @Test
    public void testConsumesMultiple() throws Exception {
        this.router.route().consumes("text/html").consumes("application/json").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/json", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "something/html", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/json", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/blah", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesVariableParameters() throws Exception {
        this.router.route().consumes("text/html;boo").consumes("text/html;works").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;works", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo;works", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;boo=done;it=works", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html;yes=no;right", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/book;boo", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/book;works=aright", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesMissingSlash() throws Exception {
        this.router.route().consumes("json").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesSubtypeWildcard() throws Exception {
        this.router.route().consumes("text/*").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesTopLevelTypeWildcard() throws Exception {
        this.router.route().consumes("*/json").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/html", 415, "Unsupported Media Type");
    }

    @Test
    public void testConsumesAll1() throws Exception {
        this.router.route().consumes("*/*").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html; someparam=12", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
    }

    @Test
    public void testConsumesAll2() throws Exception {
        this.router.route().consumes("*").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html; someparam=12", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
    }

    @Test
    public void testConsumesCTParamsIgnored() throws Exception {
        this.router.route().consumes("text/html").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "text/html; someparam=12", 200, "OK");
    }

    @Test
    public void testConsumesNoContentType() throws Exception {
        this.router.route().consumes("text/html").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/foo", HttpResponseStatus.BAD_REQUEST);
    }

    @Test
    public void testProduces() throws Exception {
        this.router.route().produces("text/html").handler(rc -> rc.response().end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/json", 406, "Not Acceptable");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "something/html", 406, "Not Acceptable");
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
    }

    @Test
    public void testProducesWithParameterKey() throws Exception {
        this.router.route().produces("text/html;boo").handler(rc -> rc.response().end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;boo;itWorks", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;boo=ya", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;boo", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html", 406, "Not Acceptable");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "*/*", 200, "OK");
    }

    @Test
    public void testProducesWithParameter() throws Exception {
        this.router.route().produces("text/html;boo=ya").handler(rc -> rc.response().end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;boo=ya", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;boo", 406, "Not Acceptable");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html", 406, "Not Acceptable");
    }

    @Test
    public void testProducesMultiple() throws Exception {
        this.router.route().produces("text/html").produces("application/json").handler(rc -> rc.response().end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "application/json", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/json", 406, "Not Acceptable");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "something/html", 406, "Not Acceptable");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/json", 406, "Not Acceptable");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "application/blah", 406, "Not Acceptable");
    }

    @Test
    public void testProducesWithQParameterIgnored() throws Exception {
        this.router.route().produces("text/html;q").produces("text/html;q=0.1").handler(rc -> rc.response().end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;a", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;q=2", 200, "OK");
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "*/*", 200, "OK");
    }

    @Test
    public void testProducesMissingSlash() throws Exception {
        this.router.route().produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "json", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text", 406, "Not Acceptable");
    }

    @Test
    public void testProducesSubtypeWildcard() throws Exception {
        this.router.route().produces("text/html").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/*", 200, "text/html");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "application/*", 406, "Not Acceptable");
    }

    @Test
    public void testProducesSubtypeWildcardAcceptTextPlain() throws Exception {
        this.router.route().produces("text/*").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/plain", 200, "text/plain");
    }

    @Test
    public void testProducesComponentWildcardAcceptTextPlain() throws Exception {
        this.router.route().produces("*/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/plain", 200, "text/plain");
    }

    @Test
    public void testProducesAllWildcard() throws Exception {
        this.router.route().produces("*/*").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/plain", 200, "text/plain");
    }

    @Test
    public void testProducesTopLevelTypeWildcard() throws Exception {
        this.router.route().produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "*/json", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "*/html", 406, "Not Acceptable");
    }

    @Test
    public void testProducesAll1() throws Exception {
        this.router.route().produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "*/*", 200, "application/json");
    }

    @Test
    public void testProducesAll2() throws Exception {
        this.router.route().produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "*", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple1() throws Exception {
        this.router.route().produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/json,text/plain", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/json;b,text/plain", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple2() throws Exception {
        this.router.route().produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/*,text/plain", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html;a,application/*,text/plain", 200, "application/json");
    }

    @Test
    public void testAcceptsWithSpaces() throws Exception {
        this.router.route("/json").produces("application/json").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/json", "    text/html    , application/*    , text/plain; q= 0.9  ", 200, "application/json");
        this.router.route("/html").produces("text/html").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/html", "    text/html    , application/*    , text/plain; q= 0.9  ", 200, "text/html");
        this.router.route("/text").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/text", "    text/html    , application/*    , text/plain; q= 0.9  ", 200, "text/plain");
    }

    @Test
    public void testAcceptsMultiple3() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/json,text/plain", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/json;a,text/plain", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/json,text/plain;a", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,application/json;c,text/plain;a", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple4() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain,application/json", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;a,application/json", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain,application/json;a", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple5() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain,application/json;q=0.9", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain,application/json;q=0.9;a", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain,application/json;a;q=0.9", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;a,application/json;q=0.9", 200, "text/plain");
    }

    @Test
    public void testAcceptsMultiple6() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json;a", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9;a,application/json", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple7() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json;q=1.0", 200, "application/json");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9;a,application/json;q=1.0", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple8() throws Exception {
        this.router.route().produces("application/json").produces("text/html").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json;q=1.0", 200, "text/html");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9;b,application/json;q=1.0", 200, "text/html");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9;b,application/json;q=1.0;a", 200, "application/json");
    }

    @Test
    public void testAcceptsMultiple9() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json;q=0.8", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9;d,application/json;q=0.8", 200, "text/plain");
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json;q=0.8;s", 200, "text/plain");
    }

    @Test
    public void testAcceptsMultipleWithParams() throws Exception {
        this.router.route().produces("application/json").produces("text/plain").handler(rc -> {
            rc.response().setStatusMessage(rc.getAcceptableContentType());
            rc.response().end();
        });
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "text/html,text/plain;q=0.9,application/json;q=0.8", 200, "text/plain");
    }

    @Test
    public void testGetPutContextData() throws Exception {
        SomeObject obj = new SomeObject();
        this.router.route().handler(ctx -> {
            ctx.put("foo", (Object)"bar");
            ctx.put("blah", (Object)obj);
            ctx.next();
        });
        this.router.route().handler(ctx -> {
            this.assertEquals("bar", ctx.get("foo"));
            this.assertEquals(obj, ctx.get("blah"));
            ctx.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testGetRoutes() throws Exception {
        this.router.route("/abc").handler(rc -> {});
        this.router.route("/abc/def").handler(rc -> {});
        this.router.route("/xyz").handler(rc -> {});
        List routes = this.router.getRoutes();
        this.assertEquals(3L, routes.size());
    }

    @Test
    public void testHeadersEndHandler() throws Exception {
        this.router.route().handler(rc -> {
            rc.addHeadersEndHandler(v -> rc.response().putHeader("header1", "foo"));
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.addHeadersEndHandler(v -> rc.response().putHeader("header2", "foo"));
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.addHeadersEndHandler(v -> rc.response().putHeader("header3", "foo"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            MultiMap headers = resp.headers();
            this.assertTrue(headers.contains("header1"));
            this.assertTrue(headers.contains("header2"));
            this.assertTrue(headers.contains("header3"));
        }, 200, "OK", null);
    }

    @Test
    public void testHeadersEndHandlerCalledBackwards() throws Exception {
        AtomicInteger cnt = new AtomicInteger(0);
        this.router.route().handler(rc -> {
            int val = cnt.incrementAndGet();
            rc.addHeadersEndHandler(v -> this.assertEquals(val, cnt.getAndDecrement()));
            rc.next();
        });
        this.router.route().handler(rc -> {
            int val = cnt.incrementAndGet();
            rc.addHeadersEndHandler(v -> this.assertEquals(val, cnt.getAndDecrement()));
            rc.next();
        });
        this.router.route().handler(rc -> {
            int val = cnt.incrementAndGet();
            rc.addHeadersEndHandler(v -> this.assertEquals(val, cnt.getAndDecrement()));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testHeadersEndHandlerCalledBackwards2() throws Exception {
        AtomicInteger cnt = new AtomicInteger(0);
        this.router.route().handler(rc -> {
            int val = cnt.incrementAndGet();
            rc.addBodyEndHandler(v -> this.assertEquals(val, cnt.getAndDecrement()));
            rc.next();
        });
        this.router.route().handler(rc -> {
            int val = cnt.incrementAndGet();
            rc.addBodyEndHandler(v -> this.assertEquals(val, cnt.getAndDecrement()));
            rc.next();
        });
        this.router.route().handler(rc -> {
            int val = cnt.incrementAndGet();
            rc.addBodyEndHandler(v -> this.assertEquals(val, cnt.getAndDecrement()));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testHeadersEndHandlerRemoveHandler() throws Exception {
        this.router.route().handler(rc -> {
            rc.addHeadersEndHandler(v -> rc.response().putHeader("header1", "foo"));
            rc.next();
        });
        this.router.route().handler(rc -> {
            Handler handler = v -> rc.response().putHeader("header2", "foo");
            int handlerID = rc.addHeadersEndHandler(handler);
            this.vertx.setTimer(1L, tid -> {
                this.assertTrue(rc.removeHeadersEndHandler(handlerID));
                this.assertFalse(rc.removeHeadersEndHandler(handlerID + 1));
                rc.response().end();
            });
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            MultiMap headers = resp.headers();
            this.assertTrue(headers.contains("header1"));
        }, 200, "OK", null);
    }

    @Test
    public void testBodyEndHandler() throws Exception {
        AtomicInteger cnt = new AtomicInteger();
        this.router.route().handler(rc -> {
            rc.addBodyEndHandler(v -> cnt.incrementAndGet());
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.addBodyEndHandler(v -> cnt.incrementAndGet());
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.addBodyEndHandler(v -> cnt.incrementAndGet());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        RouterTest.assertWaitUntil(() -> cnt.get() == 3);
    }

    @Test
    public void testBodyEndHandlerRemoveHandler() throws Exception {
        AtomicInteger cnt = new AtomicInteger();
        this.router.route().handler(rc -> {
            rc.addBodyEndHandler(v -> cnt.incrementAndGet());
            rc.next();
        });
        this.router.route().handler(rc -> {
            Handler handler = v -> cnt.incrementAndGet();
            int handlerID = rc.addBodyEndHandler(handler);
            this.vertx.setTimer(1L, tid -> {
                this.assertTrue(rc.removeBodyEndHandler(handlerID));
                this.assertFalse(rc.removeBodyEndHandler(handlerID + 1));
                rc.response().end();
            });
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        RouterTest.assertWaitUntil(() -> cnt.get() == 1);
    }

    @Test
    public void testEndHandler() throws Exception {
        AtomicInteger cnt = new AtomicInteger();
        this.router.route().handler(rc -> {
            rc.addEndHandler(v -> cnt.incrementAndGet());
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.addEndHandler(v -> cnt.incrementAndGet());
            rc.next();
        });
        this.router.route().handler(rc -> {
            rc.addEndHandler(v -> cnt.incrementAndGet());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        RouterTest.assertWaitUntil(() -> cnt.get() == 3);
    }

    @Test
    public void testExceptionHandler() throws Exception {
        AtomicInteger cnt = new AtomicInteger();
        this.client.request(HttpMethod.GET, this.server.actualPort(), "localhost", "/path").onComplete(this.onSuccess(req -> {
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> {
                    if (done.failed()) {
                        cnt.incrementAndGet();
                    }
                });
                rc.next();
            });
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> {
                    if (done.failed()) {
                        cnt.incrementAndGet();
                    }
                });
                rc.next();
            });
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> {
                    if (done.failed()) {
                        cnt.incrementAndGet();
                    }
                });
                rc.next();
            });
            this.router.route().handler(rc -> req.connection().close());
            req.end();
        }));
        RouterTest.assertWaitUntil(() -> cnt.get() == 3);
    }

    @Test
    public void testCloseHandler() throws Exception {
        AtomicInteger cnt = new AtomicInteger();
        this.client.request(HttpMethod.GET, this.server.actualPort(), "localhost", "/path").onComplete(this.onSuccess(req -> {
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> cnt.incrementAndGet());
                rc.next();
            });
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> cnt.incrementAndGet());
                rc.next();
            });
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> cnt.incrementAndGet());
                rc.next();
            });
            this.router.route().handler(rc -> req.connection().close());
            req.end();
        }));
        RouterTest.assertWaitUntil(() -> cnt.get() == 3);
    }

    @Test
    public void testEndHandlerCalledOnce() throws Exception {
        AtomicInteger endCnt = new AtomicInteger();
        AtomicInteger excCnt = new AtomicInteger();
        AtomicInteger closeCnt = new AtomicInteger();
        this.client.request(HttpMethod.GET, this.server.actualPort(), "localhost", "/path").onComplete(this.onSuccess(req -> {
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> excCnt.incrementAndGet());
                rc.next();
            });
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> endCnt.incrementAndGet());
                rc.next();
            });
            this.router.route().handler(rc -> {
                rc.addEndHandler(done -> closeCnt.incrementAndGet());
                rc.next();
            });
            this.router.route().handler(rc -> req.connection().close());
            req.end();
        }));
        RouterTest.assertWaitUntil(() -> endCnt.get() == 1);
        RouterTest.assertWaitUntil(() -> excCnt.get() == 1);
        RouterTest.assertWaitUntil(() -> closeCnt.get() == 1);
    }

    @Test
    public void testNoRoutes() throws Exception {
        this.testRequest(HttpMethod.GET, "/whatever", 404, "Not Found");
    }

    @Test
    public void testGet() throws Exception {
        this.router.get().handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.GET, "/whatever", 200, "foo");
        this.testRequest(HttpMethod.POST, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testGetWithPathExact() throws Exception {
        this.router.get("/somepath/").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.GET, "/somepath", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/", 200, "foo");
        this.testRequest(HttpMethod.GET, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 404, "Not Found");
    }

    @Test
    public void testGetWithPathBegin() throws Exception {
        this.router.get("/somepath/*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testGetWithPathBeginShouldNotMatchPrefix() throws Exception {
        this.router.get("/swagger-ui/*").handler(rc -> rc.response().setStatusMessage("/swagger-ui/*").end());
        this.router.get("/swagger-ui").handler(rc -> rc.response().setStatusMessage("/swagger-ui").end());
        this.router.get("/swagger").handler(rc -> rc.response().setStatusMessage("/swagger").end());
        this.testRequest(HttpMethod.GET, "/swagger-ui/", 200, "/swagger-ui/*");
        this.testRequest(HttpMethod.GET, "/swagger-ui/whatever", 200, "/swagger-ui/*");
        this.testRequest(HttpMethod.GET, "/swagger", 200, "/swagger");
        this.testRequest(HttpMethod.GET, "/swagger/", 200, "/swagger");
        this.testRequest(HttpMethod.GET, "/swagger/whatever", 404, "Not Found");
    }

    @Test
    public void testGetWithRegex() throws Exception {
        this.router.getWithRegex("\\/somepath\\/.*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPost() throws Exception {
        this.router.post().handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.POST, "/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPostWithPathExact() throws Exception {
        this.router.post("/somepath/").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.POST, "/somepath/", 200, "foo");
        this.testRequest(HttpMethod.POST, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 404, "Not Found");
    }

    @Test
    public void testPostWithPathBegin() throws Exception {
        this.router.post("/somepath/*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.POST, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPostWithRegex() throws Exception {
        this.router.postWithRegex("\\/somepath\\/.*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.POST, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPut() throws Exception {
        this.router.put().handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.PUT, "/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPutWithPathExact() throws Exception {
        this.router.put("/somepath/").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.PUT, "/somepath/", 200, "foo");
        this.testRequest(HttpMethod.PUT, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 404, "Not Found");
    }

    @Test
    public void testPutWithPathBegin() throws Exception {
        this.router.put("/somepath/*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.PUT, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testPutWithRegex() throws Exception {
        this.router.putWithRegex("\\/somepath\\/.*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.PUT, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testDelete() throws Exception {
        this.router.delete().handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.DELETE, "/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testDeleteWithPathExact() throws Exception {
        this.router.delete("/somepath/").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.DELETE, "/somepath/", 200, "foo");
        this.testRequest(HttpMethod.DELETE, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 404, "Not Found");
    }

    @Test
    public void testDeleteWithPathBegin() throws Exception {
        this.router.delete("/somepath/*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.DELETE, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testDeleteWithRegex() throws Exception {
        this.router.deleteWithRegex("\\/somepath\\/.*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.DELETE, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testOptions() throws Exception {
        this.router.options().handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.OPTIONS, "/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testOptionsWithPathExact() throws Exception {
        this.router.options("/somepath/").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.OPTIONS, "/somepath/", 200, "foo");
        this.testRequest(HttpMethod.OPTIONS, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 404, "Not Found");
    }

    @Test
    public void testOptionsWithPathBegin() throws Exception {
        this.router.options("/somepath/*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.OPTIONS, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testOptionsWithRegex() throws Exception {
        this.router.optionsWithRegex("\\/somepath\\/.*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.OPTIONS, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testHead() throws Exception {
        this.router.head().handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.HEAD, "/whatever", 200, "foo");
        this.testRequest(HttpMethod.GET, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testHeadWithPathExact() throws Exception {
        this.router.head("/somepath/").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.HEAD, "/somepath/", 200, "foo");
        this.testRequest(HttpMethod.HEAD, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.POST, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", 404, "Not Found");
    }

    @Test
    public void testHeadWithPathBegin() throws Exception {
        this.router.head("/somepath/*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.HEAD, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testHeadWithRegex() throws Exception {
        this.router.headWithRegex("\\/somepath\\/.*").handler(rc -> rc.response().setStatusMessage("foo").end());
        this.testRequest(HttpMethod.HEAD, "/somepath/whatever", 200, "foo");
        this.testRequest(HttpMethod.HEAD, "/otherpath/whatever", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.POST, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.PUT, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.OPTIONS, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
        this.testRequest(HttpMethod.DELETE, "/somepath/whatever", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testRouteNormalized1() throws Exception {
        this.router.route("/foo").handler(rc -> rc.response().setStatusMessage("socks").end());
        this.testRequest(HttpMethod.GET, "/foo", 200, "socks");
        this.testRequest(HttpMethod.GET, "/foo/", 200, "socks");
        this.testRequest(HttpMethod.GET, "//foo/", 200, "socks");
        this.testRequest(HttpMethod.GET, "//foo//", 200, "socks");
        this.testRequest(HttpMethod.GET, "//foo/////", 200, "socks");
    }

    @Test
    public void testRouteNormalized2() throws Exception {
        this.router.route("/foo/").handler(rc -> rc.response().setStatusMessage("socks").end());
        this.testRequest(HttpMethod.GET, "/foo", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/", 200, "socks");
        this.testRequest(HttpMethod.GET, "//foo/", 200, "socks");
        this.testRequest(HttpMethod.GET, "//foo//", 200, "socks");
        this.testRequest(HttpMethod.GET, "//foo/////", 200, "socks");
    }

    @Test
    public void testRouteNormalized3() throws Exception {
        this.router.route("/").handler(rc -> rc.response().setStatusMessage("pants").end());
        this.testRequest(HttpMethod.GET, "/", 200, "pants");
        this.testRequest(HttpMethod.GET, "//", 200, "pants");
        this.testRequest(HttpMethod.GET, "///", 200, "pants");
    }

    @Test
    public void testIssue170() throws Exception {
        try {
            this.router.route("").handler(rc -> rc.response().end());
        }
        catch (IllegalArgumentException e) {
            this.testComplete();
            return;
        }
        this.fail("Should fail");
    }

    @Test
    public void testIssue170b() throws Exception {
        this.router.route("/").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testIssue176() throws Exception {
        this.router.route().order(0).handler(context -> {
            context.response().headers().add("X-Here-1", "1");
            context.next();
        });
        this.router.route().order(0).handler(context -> {
            context.response().headers().add("X-Here-2", "2");
            context.next();
        });
        this.router.route().handler(context -> {
            context.response().headers().add("X-Here-3", "3");
            context.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            MultiMap headers = resp.headers();
            this.assertTrue(headers.contains("X-Here-1"));
            this.assertTrue(headers.contains("X-Here-2"));
            this.assertTrue(headers.contains("X-Here-3"));
        }, 200, "OK", null);
    }

    @Test
    public void testLocaleWithCountry() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(3L, rc.acceptableLanguages().size());
            this.assertEquals("da", rc.preferredLanguage().tag());
            this.assertEquals("DK", rc.preferredLanguage().subtag());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo", (HttpClientRequest req) -> req.putHeader("Accept-Language", "en-gb;q=0.8, en;q=0.7, da_DK;q=0.9"), 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/foo", (HttpClientRequest req) -> req.putHeader("Accept-Language", "en-gb;q=0.8, en;q=0.7, da-DK;q=0.9"), 200, "OK", null);
    }

    @Test
    public void testLocaleSimple() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(3L, rc.acceptableLanguages().size());
            this.assertEquals("da", rc.preferredLanguage().tag());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo", (HttpClientRequest req) -> req.putHeader("Accept-Language", "da, en-gb;q=0.8, en;q=0.7"), 200, "OK", null);
    }

    @Test
    public void testLocaleWithoutQuality() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(1L, rc.acceptableLanguages().size());
            this.assertEquals("en", rc.preferredLanguage().tag());
            this.assertEquals("GB", rc.preferredLanguage().subtag().toUpperCase());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo", (HttpClientRequest req) -> req.putHeader("Accept-Language", "en-gb"), 200, "OK", null);
    }

    @Test
    public void testLocaleSameQuality() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(2L, rc.acceptableLanguages().size());
            this.assertEquals("pt", rc.preferredLanguage().tag());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo", (HttpClientRequest req) -> req.putHeader("Accept-Language", "pt;q=0.9, en-gb;q=0.9"), 200, "OK", null);
    }

    @Test
    public void testLocaleNoHeaderFromClient() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(0L, rc.acceptableLanguages().size());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
    }

    @Test
    public void testUnderscoreOnRoutePath() throws Exception {
        this.router.route("/:account_id").handler(rc -> {
            this.assertEquals("foo", rc.request().params().get("account_id"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo", 200, "OK");
    }

    @Test
    public void testBadURL() throws Exception {
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/%7B%channel%%7D", 200, "OK");
    }

    @Test
    public void testDuplicateParams() throws Exception {
        this.router.route("/test/:p").handler(RoutingContext::next);
        this.router.route("/test/:p").handler(RoutingContext::next);
        this.router.route("/test/:p").handler(routingContext -> {
            this.assertEquals(1L, routingContext.request().params().getAll("p").size());
            this.assertEquals("abc", routingContext.request().getParam("p"));
            routingContext.response().end();
        });
        this.testRequest(HttpMethod.GET, "/test/abc", 200, "OK");
    }

    @Test
    public void testDuplicateParams2() throws Exception {
        this.router.route("/test/:p").handler(RoutingContext::next);
        this.router.route("/test/:p").handler(ctx -> ctx.reroute("/done/abc/cde"));
        this.router.route("/done/:a/:p").handler(routingContext -> {
            this.assertEquals(1L, routingContext.request().params().getAll("p").size());
            this.assertEquals("cde", routingContext.request().getParam("p"));
            routingContext.response().end();
        });
        this.testRequest(HttpMethod.GET, "/test/abc", 200, "OK");
    }

    @Test
    public void testSubRouterNPE() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.route("/*").subRouter(subRouter);
        this.testRequest(HttpMethod.GET, "foo", 404, "Not Found");
    }

    @Test
    public void testParamFirst() throws Exception {
        this.router.route("/:p/*").handler(context -> {
            context.response().headers().add("X-Here-1", "1");
            context.next();
        });
        this.router.route("/:p/test").handler(context -> {
            context.response().headers().add("X-Here-2", "2");
            context.response().end();
        });
        this.testRequest(HttpMethod.GET, "/abc/test", null, resp -> {
            MultiMap headers = resp.headers();
            this.assertTrue(headers.contains("X-Here-1"));
            this.assertTrue(headers.contains("X-Here-2"));
        }, 200, "OK", null);
    }

    @Test
    public void testGetWithPlusPath2() throws Exception {
        this.router.get("/:param1").useNormalizedPath(false).handler(rc -> {
            this.assertEquals("/some+path", rc.normalizedPath());
            this.assertEquals("some+path", rc.pathParam("param1"));
            this.assertEquals("some query", rc.request().getParam("q1"));
            rc.response().setStatusMessage("foo").end();
        });
        this.testRequest(HttpMethod.GET, "/some+path?q1=some+query", 200, "foo");
    }

    @Test
    public void testMultipleSetHandler() throws Exception {
        this.router.get("/path").handler(routingContext -> {
            routingContext.put("response", (Object)"handler1");
            routingContext.next();
        }).handler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.next();
        }).handler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.end(routingContext.get("response") + "handler3");
        });
        this.testRequest(HttpMethod.GET, "/path", 200, "OK", "handler1handler2handler3");
    }

    @Test
    public void testMultipleSetFailureHandler() throws Exception {
        this.router.get("/path").handler(routingContext -> routingContext.fail(500)).failureHandler(routingContext -> {
            routingContext.put("response", (Object)"handler1");
            routingContext.next();
        }).failureHandler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.next();
        }).failureHandler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.setStatusMessage("ERROR");
            response.setStatusCode(500);
            response.end(routingContext.get("response") + "handler3");
        });
        this.testRequest(HttpMethod.GET, "/path", 500, "ERROR", "handler1handler2handler3");
    }

    @Test
    public void testMultipleSetFailureHandlerCorrectOrder() throws Exception {
        this.router.route().failureHandler(routingContext -> {
            routingContext.put("response", (Object)"handler1");
            routingContext.next();
        });
        this.router.get("/path").handler(routingContext -> routingContext.fail(500)).failureHandler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.next();
        }).failureHandler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.setStatusMessage("ERROR");
            response.setStatusCode(500);
            response.end(routingContext.get("response") + "handler3");
        });
        this.testRequest(HttpMethod.GET, "/path", 500, "ERROR", "handler1handler2handler3");
    }

    @Test
    public void testMultipleHandlersMixed() throws Exception {
        this.router.route().failureHandler(routingContext -> {
            routingContext.put("response", (Object)"fhandler1");
            routingContext.next();
        });
        this.router.get("/:param").handler(routingContext -> {
            if (routingContext.pathParam("param").equals("fail")) {
                routingContext.fail(500);
            }
            routingContext.put("response", (Object)"handler1");
            routingContext.next();
        }).handler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.next();
        }).handler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.end(routingContext.get("response") + "handler3");
        }).failureHandler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "fhandler2"));
            routingContext.next();
        }).failureHandler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.setStatusMessage("ERROR");
            response.setStatusCode(500);
            response.end(routingContext.get("response") + "fhandler3");
        });
        this.testRequest(HttpMethod.GET, "/path", 200, "OK", "handler1handler2handler3");
        this.testRequest(HttpMethod.GET, "/fail", 500, "ERROR", "fhandler1fhandler2fhandler3");
    }

    @Test
    public void testMultipleHandlersMultipleConnections() throws Exception {
        this.router.get("/path").handler(routingContext -> {
            routingContext.put("response", (Object)"handler1");
            routingContext.next();
        }).handler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.next();
        }).handler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.end(routingContext.get("response") + "handler3");
        });
        CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            this.vertx.executeBlocking(future -> {
                try {
                    this.testSyncRequest("GET", "/path", 200, "OK", "handler1handler2handler3");
                    future.complete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    future.fail((Throwable)e);
                }
            }, asyncResult -> {
                this.assertFalse(asyncResult.failed());
                this.assertNull(asyncResult.cause());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
    }

    @Test
    public void testMultipleHandlersMultipleConnectionsDelayed() throws Exception {
        this.router.get("/path").handler(routingContext -> {
            routingContext.put("response", (Object)"handler1");
            routingContext.vertx().setTimer((long)((int)(1.0 + Math.random() * 10.0)), asyncResult -> routingContext.next());
        }).handler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.vertx().setTimer((long)((int)(1.0 + Math.random() * 10.0)), asyncResult -> routingContext.next());
        }).handler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.end(routingContext.get("response") + "handler3");
        });
        CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            this.vertx.executeBlocking(future -> {
                try {
                    Thread.sleep((int)(1.0 + Math.random() * 10.0));
                    this.testSyncRequest("GET", "/path", 200, "OK", "handler1handler2handler3");
                    future.complete();
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            }, asyncResult -> {
                this.assertFalse(asyncResult.failed());
                this.assertNull(asyncResult.cause());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
    }

    @Test
    public void testMultipleHandlersMultipleConnectionsDelayedMixed() throws Exception {
        this.router.get("/:param").handler(routingContext -> {
            if (routingContext.pathParam("param").equals("fail")) {
                routingContext.fail(400);
            } else {
                routingContext.put("response", (Object)"handler1");
                routingContext.vertx().setTimer((long)((int)(1.0 + Math.random() * 10.0)), asyncResult -> routingContext.next());
            }
        }).failureHandler(routingContext -> {
            routingContext.put("response", (Object)"fhandler1");
            routingContext.vertx().setTimer((long)((int)(1.0 + Math.random() * 10.0)), asyncResult -> routingContext.next());
        }).handler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.vertx().setTimer((long)((int)(1.0 + Math.random() * 10.0)), asyncResult -> routingContext.next());
        }).handler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.end(routingContext.get("response") + "handler3");
        }).failureHandler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "fhandler2"));
            routingContext.vertx().setTimer((long)((int)(1.0 + Math.random() * 10.0)), asyncResult -> routingContext.next());
        }).failureHandler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.setStatusMessage("ERROR");
            response.setStatusCode(400);
            response.end(routingContext.get("response") + "fhandler3");
        });
        int multipleConnections = 500;
        CountDownLatch latch = new CountDownLatch(500);
        Handler execute200Request = future -> {
            try {
                Thread.sleep((int)(1.0 + Math.random() * 10.0));
                this.testSyncRequest("GET", "/path", 200, "OK", "handler1handler2handler3");
                future.complete();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                future.fail((Throwable)e);
            }
        };
        Handler execute400Request = future -> {
            try {
                Thread.sleep((int)(1.0 + Math.random() * 10.0));
                this.testSyncRequest("GET", "/fail", 400, "ERROR", "fhandler1fhandler2fhandler3");
                future.complete();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                future.fail((Throwable)e);
            }
        };
        for (int i = 0; i < 500; ++i) {
            this.vertx.executeBlocking(new Random().nextBoolean() ? execute200Request : execute400Request, false, objectAsyncResult -> {
                this.assertTrue(objectAsyncResult.succeeded());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
    }

    @Test
    public void testMultipleSetHandlerMultipleRouteObject() throws Exception {
        this.router.get("/path").handler(routingContext -> {
            routingContext.put("response", (Object)"handler1");
            routingContext.next();
        });
        this.router.get("/path").handler(routingContext -> {
            routingContext.put("response", (Object)(routingContext.get("response") + "handler2"));
            routingContext.next();
        }).handler(routingContext -> {
            HttpServerResponse response = routingContext.response();
            response.setChunked(true);
            response.end(routingContext.get("response") + "handler3");
        });
        this.testRequest(HttpMethod.GET, "/path", 200, "OK", "handler1handler2handler3");
    }

    @Test
    public void testSetRegexGroupsNamesMethod() throws Exception {
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add("hello");
        Route route1 = this.router.getWithRegex("\\/(?<p0>[a-z]{2})");
        route1.setRegexGroupsNames(groupNames);
        route1.handler(routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.pathParam("hello")).end());
        this.testRequest(HttpMethod.GET, "/hi", 200, "hi");
    }

    @Test
    public void testRegexGroupsNamesWithMethodOverride() throws Exception {
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add("FirstParam");
        groupNames.add("SecondParam");
        Route route = this.router.getWithRegex("\\/([a-z]{2})([a-z]{2})");
        route.setRegexGroupsNames(groupNames);
        route.handler(routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.pathParam("FirstParam") + "-" + routingContext.pathParam("SecondParam")).end());
        this.testRequest(HttpMethod.GET, "/aabb", 200, "aa-bb");
    }

    @Test
    public void testSetRegexGroupsNamesMethodWithUnorderedGroups() throws Exception {
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add("firstParam");
        groupNames.add("secondParam");
        Route route1 = this.router.getWithRegex("\\/(?<p1>[a-z]{2})(?<p0>[a-z]{2})");
        route1.setRegexGroupsNames(groupNames);
        route1.handler(routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.pathParam("firstParam") + "-" + routingContext.pathParam("secondParam")).end());
        this.testRequest(HttpMethod.GET, "/bbaa", 200, "aa-bb");
    }

    @Test
    public void testSetRegexGroupsNamesMethodWithNestedRegex() throws Exception {
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add("firstParam");
        groupNames.add("secondParam");
        Route route1 = this.router.getWithRegex("\\/(?<p1>[a-z]{2}(?<p0>[a-z]{2}))");
        route1.setRegexGroupsNames(groupNames);
        route1.handler(routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.pathParam("firstParam") + "-" + routingContext.pathParam("secondParam")).end());
        this.testRequest(HttpMethod.GET, "/bbaa", 200, "aa-bbaa");
    }

    @Test
    public void testRegexGroupsNames() throws Exception {
        this.router.getWithRegex("\\/(?<firstParam>[a-z]{2})(?<secondParam>[a-z]{2})").handler(routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.pathParam("firstParam") + "-" + routingContext.pathParam("secondParam")).end());
        this.testRequest(HttpMethod.GET, "/aabb", 200, "aa-bb");
    }

    @Test
    public void testRegexGroupsNamesWithNestedGroups() throws Exception {
        this.router.getWithRegex("\\/(?<secondParam>[a-z]{2}(?<firstParam>[a-z]{2}))").handler(routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.pathParam("firstParam") + "-" + routingContext.pathParam("secondParam")).end());
        this.testRequest(HttpMethod.GET, "/bbaa", 200, "aa-bbaa");
    }

    private Handler<RoutingContext> generateHandler(int i) {
        return routingContext -> routingContext.put(Integer.toString(i), (Object)i).next();
    }

    @Test
    public void stressTestMultipleHandlers() throws Exception {
        int i;
        int HANDLERS_NUMBER = 100;
        int REQUESTS_NUMBER = 200;
        Route r = this.router.get("/path");
        for (int i2 = 0; i2 < 100; ++i2) {
            r.handler(this.generateHandler(i2));
        }
        r.handler(routingContext -> {
            StringBuilder sum = new StringBuilder();
            for (int i = 0; i < 100; ++i) {
                sum.append((Integer)routingContext.get(Integer.toString(i)));
            }
            routingContext.response().setStatusCode(200).setStatusMessage("OK").end(sum.toString());
        });
        CountDownLatch latch = new CountDownLatch(200);
        StringBuilder sum = new StringBuilder();
        for (i = 0; i < 100; ++i) {
            sum.append(i);
        }
        for (i = 0; i < 200; ++i) {
            this.vertx.executeBlocking(future -> {
                try {
                    Thread.sleep((int)(1.0 + Math.random() * 10.0));
                    this.testSyncRequest("GET", "/path", 200, "OK", sum.toString());
                    future.complete();
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            }, asyncResult -> {
                this.assertFalse(asyncResult.failed());
                this.assertNull(asyncResult.cause());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
    }

    @Test
    public void testDecodingError() throws Exception {
        String BAD_PARAM = "~!@\\||$%^&*()_=-%22;;%27%22:%3C%3E/?]}{";
        this.router.route().handler(rc -> {
            rc.queryParams();
            rc.next();
        });
        this.router.route("/path").handler(rc -> rc.response().setStatusCode(500).end());
        this.testRequest(HttpMethod.GET, "/path?q=" + BAD_PARAM, 400, "Bad Request");
    }

    @Test
    public void testRoutePathNoSlashBegin() throws Exception {
        String path = "?test=something";
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, path, 400, "Bad Request");
    }

    @Test
    public void testMultipleHandlersWithFailuresDeadlock() throws Exception {
        AtomicBoolean first = new AtomicBoolean(true);
        CountDownLatch firstHandlerLatch = new CountDownLatch(1);
        CountDownLatch secondHandlerLatch = new CountDownLatch(1);
        this.router.get("/path").handler(event -> {
            if (!first.compareAndSet(true, false)) {
                try {
                    firstHandlerLatch.countDown();
                    this.awaitLatch(secondHandlerLatch);
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                event.next();
            } else {
                this.vertx.executeBlocking(future -> {
                    event.next();
                    future.complete();
                }, asyncResult -> {});
            }
        });
        this.router.get("/path").handler(event -> {
            try {
                this.awaitLatch(firstHandlerLatch);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            secondHandlerLatch.countDown();
            event.fail((Throwable)new NullPointerException());
        });
        CountDownLatch latch = new CountDownLatch(2);
        for (int i = 0; i < 2; ++i) {
            this.vertx.executeBlocking(future -> {
                HttpServerRequest request = (HttpServerRequest)Mockito.mock(HttpServerRequestInternal.class);
                HttpServerResponse response = (HttpServerResponse)Mockito.mock(HttpServerResponse.class);
                Mockito.when((Object)request.method()).thenReturn((Object)HttpMethod.GET);
                Mockito.when((Object)request.scheme()).thenReturn((Object)"http");
                Mockito.when((Object)request.uri()).thenReturn((Object)"http://localhost/path");
                Mockito.when((Object)request.absoluteURI()).thenReturn((Object)"http://localhost/path");
                Mockito.when((Object)request.host()).thenReturn((Object)"localhost");
                Mockito.when((Object)request.authority()).thenReturn((Object)HostAndPort.create((String)"localhost", (int)80));
                Mockito.when((Object)request.path()).thenReturn((Object)"/path");
                Mockito.when((Object)request.response()).thenReturn((Object)response);
                Mockito.when((Object)response.ended()).thenReturn((Object)true);
                this.router.handle((Object)request);
                future.complete();
            }, false, asyncResult -> {
                this.assertFalse(asyncResult.failed());
                this.assertNull(asyncResult.cause());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
    }

    @Test
    public void testCustom404ErrorHandler() throws Exception {
        this.testRequest(HttpMethod.GET, "/blah", 404, "Not Found", "<html><body><h1>Resource not found</h1></body></html>");
        this.router.errorHandler(404, routingContext -> routingContext.response().setStatusMessage("Not Found").setStatusCode(404).end("Not Found custom error"));
        this.testRequest(HttpMethod.GET, "/blah", 404, "Not Found", "Not Found custom error");
    }

    @Test
    public void testDecodingErrorCustomHandler() throws Exception {
        String BAD_PARAM = "~!@\\||$%^&*()_=-%22;;%27%22:%3C%3E/?]}{";
        this.router.errorHandler(400, context -> context.response().setStatusCode(500).setStatusMessage("Dumb").end());
        this.router.route().handler(rc -> {
            rc.queryParams();
            rc.next();
        }).handler(rc -> rc.response().setStatusCode(500).end());
        this.testRequest(HttpMethod.GET, "/path?q=" + BAD_PARAM, 500, "Dumb");
    }

    @Test
    public void testCustomErrorHandler() throws Exception {
        this.router.route("/path").handler(rc -> rc.fail(410));
        this.router.errorHandler(410, context -> context.response().setStatusCode(500).setStatusMessage("Dumb").end());
        this.testRequest(HttpMethod.GET, "/path", 500, "Dumb");
    }

    @Test
    public void testErrorInCustomErrorHandler() throws Exception {
        this.router.route("/path").handler(rc -> rc.fail(410));
        this.router.errorHandler(410, rc -> {
            throw new RuntimeException();
        });
        this.testRequest(HttpMethod.GET, "/path", 410, "Gone");
    }

    @Test
    public void testErrorHandlingResponseClosed() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.request(HttpMethod.GET, this.server.actualPort(), "localhost", "/path").onComplete(this.onSuccess(req -> {
            this.router.route().handler(rc -> {
                req.connection().close();
                rc.response().closeHandler(v -> rc.next());
            });
            this.router.route("/path").handler(rc -> rc.response().write(""));
            this.router.errorHandler(500, rc -> {
                this.assertEquals(1L, latch.getCount());
                latch.countDown();
            });
            req.end();
        }));
        latch.await();
    }

    @Test
    public void testMethodNotAllowedCustomErrorHandler() throws Exception {
        this.router.get("/path").handler(rc -> rc.response().end());
        this.router.post("/path").handler(rc -> rc.response().end());
        this.router.errorHandler(405, context -> context.response().setStatusCode(context.statusCode()).setStatusMessage("Dumb").end());
        this.testRequest(HttpMethod.PUT, "/path", 405, "Dumb");
    }

    @Test
    public void testNotAcceptableCustomErrorHandler() throws Exception {
        this.router.route().produces("text/html").handler(rc -> rc.response().end());
        this.router.errorHandler(406, context -> context.response().setStatusCode(context.statusCode()).setStatusMessage("Dumb").end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "something/html", 406, "Dumb");
    }

    @Test
    public void testUnsupportedMediaTypeCustomErrorHandler() throws Exception {
        this.router.route().consumes("text/html").handler(rc -> rc.response().end());
        this.router.errorHandler(415, context -> context.response().setStatusCode(context.statusCode()).setStatusMessage("Dumb").end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "something/html", 415, "Dumb");
    }

    @Test
    public void testMethodNotAllowedStatusCode() throws Exception {
        this.router.get("/path").handler(rc -> rc.response().end());
        this.router.post("/path").handler(rc -> rc.response().end());
        this.router.put("/hello").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.PUT, "/path", HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testMethodNotAllowedHeader() throws Exception {
        this.router.get("/path").handler(rc -> rc.response().end());
        this.router.post("/path").handler(rc -> rc.response().end());
        this.router.put("/hello").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.PUT, "/path", null, res -> {
            this.assertEquals(2L, res.getHeader("allow").split(",").length);
            this.assertTrue(res.getHeader("allow").contains("GET"));
            this.assertTrue(res.getHeader("allow").contains("POST"));
        }, HttpResponseStatus.METHOD_NOT_ALLOWED.code(), HttpResponseStatus.METHOD_NOT_ALLOWED.reasonPhrase(), null);
    }

    @Test
    public void testNotAcceptableStatusCode() throws Exception {
        this.router.route().produces("text/html").handler(rc -> rc.response().end());
        this.router.route("/hello").produces("something/html").handler(rc -> rc.response().end());
        this.testRequestWithAccepts(HttpMethod.GET, "/foo", "something/html", 406, HttpResponseStatus.NOT_ACCEPTABLE.reasonPhrase());
    }

    @Test
    public void testUnsupportedMediaTypeStatusCode() throws Exception {
        this.router.route().consumes("text/html").handler(rc -> rc.response().end());
        this.router.get("/hello").consumes("something/html").handler(rc -> rc.response().end());
        this.testRequestWithContentType(HttpMethod.GET, "/foo", "something/html", 415, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.reasonPhrase());
    }

    @Test
    public void testVHost() throws Exception {
        this.router.route().virtualHost("*.com").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setPort(Integer.valueOf(80)).setHost("www.mysite.com"), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostShouldFail() throws Exception {
        this.router.route().virtualHost("*.com").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setPort(Integer.valueOf(80)).setHost("www.mysite.net"), (HttpClientRequest req) -> {}, 500, "Internal Server Error", null);
    }

    @Test
    public void testOverlappingRoutes() throws Exception {
        this.router.route(HttpMethod.PUT, "/foo/:param1").order(1).handler(routingContext -> this.fail("Should not route to PUT"));
        this.router.route(HttpMethod.GET, "/foo/:param2").order(10).handler(routingContext -> {
            if (routingContext.pathParam("param1") != null) {
                this.fail("Should not have parameter from the other route.");
            }
            if (routingContext.pathParam("param2") == null) {
                this.fail("Should have parameter from the other route.");
            }
            routingContext.response().end("done");
        });
        this.testRequest(HttpMethod.GET, "/foo/bar", HttpResponseStatus.OK);
    }

    @Test
    public void testToString() {
        this.assertNotNull(this.router.toString());
        Route route = this.router.route("/foo/:param1");
        this.assertNotNull(this.router.toString());
        this.assertNotNull(route.toString());
    }

    @Test
    public void testRouteMatching() throws Exception {
        this.router.route("/foo/bar/").handler(rc -> rc.response().setStatusMessage("socks").end());
        this.testRequest(HttpMethod.GET, "/foo/bar", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/bar/", 200, "socks");
        this.testRequest(HttpMethod.GET, "/foo/bar/baz", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/b", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/f", 404, "Not Found");
    }

    @Test
    public void testRouteMatchingUnsupportedMediaType() throws Exception {
        this.router.post("/api").consumes("application/json").handler(rc -> rc.response().setStatusMessage("post api").end());
        this.router.put("/api").consumes("application/json").handler(rc -> rc.response().setStatusMessage("put api").end());
        this.testRequestWithContentType(HttpMethod.POST, "/api", "application/json", 200, "post api");
        this.testRequestWithContentType(HttpMethod.POST, "/api", "application/xml", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.PUT, "/api", "application/json", 200, "put api");
        this.testRequestWithContentType(HttpMethod.PUT, "/api", "application/xml", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.PATCH, "/api", "application/json", 405, "Method Not Allowed");
    }

    @Test
    public void testRouteMatchingUnsupportedMediaTypeOrder() throws Exception {
        this.router.put("/api").consumes("application/json").handler(rc -> rc.response().setStatusMessage("put api").end());
        this.router.post("/api").consumes("application/json").handler(rc -> rc.response().setStatusMessage("post api").end());
        this.router.get("/api").handler(rc -> rc.response().setStatusMessage("get api").end());
        this.router.put("/api").consumes("application/xml").handler(rc -> rc.response().setStatusMessage("put api xml").end());
        this.testRequestWithContentType(HttpMethod.POST, "/api", "application/json", 200, "post api");
        this.testRequestWithContentType(HttpMethod.POST, "/api", "application/xml", 415, "Unsupported Media Type");
        this.testRequestWithContentType(HttpMethod.PUT, "/api", "application/json", 200, "put api");
        this.testRequestWithContentType(HttpMethod.PUT, "/api", "application/xml", 200, "put api xml");
        this.testRequestWithContentType(HttpMethod.PATCH, "/api", "application/json", 405, "Method Not Allowed");
    }

    @Test
    public void testRouteMatchingSupportedMediaTypes() throws Exception {
        this.router.post("/api").consumes("application/json").handler(rc -> rc.response().setStatusMessage("post api").end());
        this.router.post("/api").consumes("application/xml").handler(rc -> rc.response().setStatusMessage("post api xml").end());
        this.router.put("/api").consumes("application/json").handler(rc -> rc.response().setStatusMessage("put api").end());
        this.router.put("/api").consumes("application/xml").handler(rc -> rc.response().setStatusMessage("put api xml").end());
        this.testRequestWithContentType(HttpMethod.POST, "/api", "application/json", 200, "post api");
        this.testRequestWithContentType(HttpMethod.POST, "/api", "application/xml", 200, "post api xml");
        this.testRequestWithContentType(HttpMethod.PUT, "/api", "application/json", 200, "put api");
        this.testRequestWithContentType(HttpMethod.PUT, "/api", "application/xml", 200, "put api xml");
        this.testRequestWithContentType(HttpMethod.PATCH, "/api", "application/json", 405, "Method Not Allowed");
    }

    @Test
    public void testRouteCustomVerb() throws Exception {
        this.router.route().method(HttpMethod.valueOf((String)"MKCOL")).handler(rc -> rc.response().setStatusMessage("socks").end());
        this.testRequest(HttpMethod.MKCOL, "/", 200, "socks");
    }

    @Test
    public void testStatusCodeUncatchedException() throws Exception {
        Route route1 = this.router.get("/somepath/path1");
        route1.handler(ctx -> {
            throw new RuntimeException("something happened!");
        });
        Route route3 = this.router.get("/somepath/*");
        route3.failureHandler(failureRoutingContext -> {
            int statusCode = failureRoutingContext.statusCode();
            this.assertEquals(500L, statusCode);
            HttpServerResponse response = failureRoutingContext.response();
            response.setStatusCode(statusCode).end("Sorry! Not today");
        });
        this.testRequest(HttpMethod.GET, "/somepath/path1", 500, "Internal Server Error");
    }

    @Test
    public void testRouteRestParam() throws Exception {
        this.router.route("/p*").handler(rc -> {
            if (rc.pathParam("*") != null) {
                rc.response().setStatusMessage(rc.pathParam("*")).end();
            } else {
                rc.fail(500);
            }
        });
        this.testRequest(HttpMethod.GET, "/p", 200, "");
        this.testRequest(HttpMethod.GET, "/pa", 200, "a");
        this.testRequest(HttpMethod.GET, "/q", 404, "Not Found");
    }

    @Test
    public void testEscapeURIParam() throws Exception {
        String source = "\u00e9";
        String utf8 = URLEncoder.encode(source, "UTF8");
        String latin1 = URLEncoder.encode(source, "ISO-8859-1");
        this.router.route().handler(rc -> {
            this.assertEquals(source, rc.queryParams().get("u"));
            Assert.assertNotEquals((Object)source, (Object)rc.queryParams().get("l"));
            Assert.assertNotEquals((Object)source, (Object)rc.queryParams(StandardCharsets.ISO_8859_1).get("u"));
            this.assertEquals(source, rc.queryParams(StandardCharsets.ISO_8859_1).get("l"));
            rc.end();
        });
        this.testRequest(HttpMethod.GET, "/?u=" + utf8 + "&l=" + latin1, 200, "OK");
    }

    @Test
    public void testETag() throws Exception {
        this.router.route("/check/e-tag").handler(ctx -> {
            ctx.etag("1234");
            if (ctx.isFresh()) {
                ctx.response().setStatusCode(304).end("Not Modified");
            } else {
                ctx.response().setStatusCode(200).end("OK");
            }
        });
        this.testRequest(HttpMethod.GET, "/check/e-tag", (HttpClientRequest req) -> req.putHeader("IF-NONE-MATCH", "\"1234\","), 304, "Not Modified", "");
        this.testRequest(HttpMethod.GET, "/check/e-tag", (HttpClientRequest req) -> req.putHeader("IF-NONE-MATCH", "\"1234\""), 304, "Not Modified", "");
    }

    @Test
    public void testRegexOptionals() throws Exception {
        this.router.routeWithRegex("/help/(.+)/(txt|tab)?").setRegexGroupsNames(Arrays.asList("id", "format")).handler(rc -> {
            MultiMap params = rc.request().params();
            this.assertNotNull(params.get("id"));
            rc.end();
        });
        this.testRequest(HttpMethod.GET, "/help/abcd/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/help/abcd/txt", 200, "OK");
    }

    @Test
    public void testQuarkusStar() throws Exception {
        this.router.clear();
        Router swagger = Router.router((Vertx)this.vertx);
        swagger.route("/swagger/*").handler(RoutingContext::end);
        this.router.route("/q*").subRouter(swagger);
        this.testRequest(HttpMethod.GET, "/q/swagge", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/q/swagger", 200, "OK");
        this.testRequest(HttpMethod.GET, "/q/swaggery", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/q/swagger/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/q/swagger/index.html", 200, "OK");
    }

    @Test
    public void testSpecialParams() throws Exception {
        this.router.route().handler(ctx -> ctx.end());
        this.testRequest(HttpMethod.GET, "/?a=b&c:d=e", 200, "OK");
    }

    @Test
    public void testSpecialParams2() throws Exception {
        this.router.route().handler(ctx -> ctx.end());
        this.testRequest(HttpMethod.GET, "/?a=a&A=b", 200, "OK");
    }

    @Test
    public void testRouteMetadata() throws Exception {
        this.router.route("/metadata").putMetadata("abc", (Object)"123").handler(rc -> {
            Route route = rc.currentRoute();
            String value = (String)route.getMetadata("abc");
            rc.end(value);
        });
        this.testRequest(HttpMethod.GET, "/metadata", 200, "OK", "123");
    }

    @Test
    public void testRouterMetadata() throws Exception {
        this.router.putMetadata("parent", (Object)"abc");
        Router sub = Router.router((Vertx)this.vertx).putMetadata("sub", (Object)"123");
        sub.route("/metadata").handler(rc -> {
            String subVal = (String)((RoutingContextInternal)rc).currentRouter().getMetadata("sub");
            String parentVal = (String)((RoutingContextInternal)rc).parent().currentRouter().getMetadata("parent");
            rc.end(parentVal + "-" + subVal);
        });
        this.router.route("/sub*").subRouter(sub);
        this.testRequest(HttpMethod.GET, "/sub/metadata", 200, "OK", "abc-123");
    }

    @Test
    public void testMultiExceptionCallBug() throws Exception {
        this.router.route().failureHandler(ctx -> ctx.response().setStatusCode(400).end("returned in first error handler")).failureHandler(ctx -> this.fail("Second error handler, don't expect to get here"));
        this.router.route(HttpMethod.GET, "/fail").handler((Handler)BodyHandler.create()).handler(ctx -> ctx.response().setStatusCode(200).end(ctx.body().asString()));
        this.testRequest(HttpMethod.GET, "/fail", (HttpClientRequest req) -> {
            req.putHeader("Content-Type", "application/x-www-form-urlencoded");
            req.end("{\"confidence\":\"56%\",\"info\":\"a&b\"}");
        }, 400, "Bad Request", "returned in first error handler");
    }

    @Test
    public void testPauseResumeRelaxed() throws Exception {
        this.router.route().handler(ctx -> ctx.request().endHandler(x -> ctx.response().end("Hello")));
        this.testRequest(HttpMethod.GET, "/", 200, "OK", "Hello");
    }

    @Test
    public void testPauseResumeRelaxed2() throws Exception {
        this.router.route().handler(ctx -> {
            ctx.request().pause();
            ctx.vertx().setTimer(1L, t -> {
                ctx.request().resume();
                ctx.next();
            });
        }).handler(ctx -> {
            switch (ctx.normalizedPath()) {
                case "/end": {
                    ctx.request().end(x -> ctx.response().end("Hello"));
                    break;
                }
                case "/endHandler": {
                    ctx.request().endHandler(x -> ctx.response().end("Hello"));
                    break;
                }
                case "/end/Future": {
                    ctx.request().end().onSuccess(x -> ctx.response().end("Hello"));
                    break;
                }
                case "/bodyHandler": {
                    ctx.request().bodyHandler(x -> ctx.response().end("Hello"));
                    break;
                }
                case "/body": {
                    ctx.request().body(x -> ctx.response().end("Hello"));
                    break;
                }
                case "/body/Future": {
                    ctx.request().body().onSuccess(x -> ctx.response().end("Hello"));
                }
            }
        });
        this.testRequest(HttpMethod.GET, "/endHandler", 200, "OK");
        this.testRequest(HttpMethod.GET, "/bodyHandler", 200, "OK");
        this.testRequest(HttpMethod.GET, "/body", 200, "OK");
        this.testRequest(HttpMethod.GET, "/body/Future", 200, "OK");
        this.testRequest(HttpMethod.GET, "/end", 200, "OK");
        this.testRequest(HttpMethod.GET, "/end/Future", 200, "OK");
    }

    @Test
    public void testBytesReadOnPause() throws Exception {
        this.router.route().handler(ctx -> {
            this.assertEquals(0L, ctx.request().bytesRead());
            ctx.end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testPauseResumeOnPipeline() {
        this.router.route().handler(ctx -> {
            ctx.request().pause();
            ctx.vertx().setTimer(1L, t -> {
                ctx.request().resume();
                ctx.next();
            });
        });
        this.router.route("/parse/*").handler((Handler)BodyHandler.create());
        this.router.route("/").handler(ctx -> {
            this.assertTrue(ctx.body().isEmpty());
            ctx.response().end(ctx.normalizedPath() + "\n");
        });
        this.router.route("/parse/ok").handler(ctx -> {
            this.assertFalse(ctx.body().isEmpty());
            ctx.response().end(ctx.normalizedPath() + "\n");
        });
        this.router.route("/expect/end").handler(ctx -> ctx.request().end(x -> ctx.response().end(ctx.normalizedPath() + "\n")));
        Function<List, String> test = reqs -> {
            try (Socket socket = new Socket("localhost", 8080);){
                int ch;
                OutputStream output = socket.getOutputStream();
                PrintWriter writer = new PrintWriter(output, true);
                for (String req : reqs) {
                    writer.print(req);
                }
                writer.println();
                InputStream input = socket.getInputStream();
                StringBuilder buffer = new StringBuilder();
                while ((ch = input.read()) != -1) {
                    if (ch == 13) continue;
                    buffer.append((char)ch);
                }
                String string = buffer.toString();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.assertEquals("HTTP/1.1 200 OK\ncontent-length: 2\n\n/\nHTTP/1.1 200 OK\nconnection: close\ncontent-length: 10\n\n/parse/ok\n", test.apply(Arrays.asList("POST / HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nABC", "POST /parse/ok HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nDEF")));
        this.assertEquals("HTTP/1.1 200 OK\ncontent-length: 10\n\n/parse/ok\nHTTP/1.1 200 OK\nconnection: close\ncontent-length: 2\n\n/\n", test.apply(Arrays.asList("POST /parse/ok HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nDEF", "POST / HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nABC")));
        this.assertEquals("HTTP/1.1 200 OK\ncontent-length: 10\n\n/parse/ok\nHTTP/1.1 200 OK\nconnection: close\ncontent-length: 12\n\n/expect/end\n", test.apply(Arrays.asList("POST /parse/ok HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nDEF", "POST /expect/end HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nABC")));
        this.assertEquals("HTTP/1.1 200 OK\ncontent-length: 12\n\n/expect/end\nHTTP/1.1 200 OK\nconnection: close\ncontent-length: 10\n\n/parse/ok\n", test.apply(Arrays.asList("POST /expect/end HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nABC", "POST /parse/ok HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nDEF")));
        this.assertEquals("HTTP/1.1 200 OK\ncontent-length: 2\n\n/\nHTTP/1.1 200 OK\nconnection: close\ncontent-length: 12\n\n/expect/end\n", test.apply(Arrays.asList("POST / HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nDEF", "POST /expect/end HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nABC")));
        this.assertEquals("HTTP/1.1 200 OK\ncontent-length: 12\n\n/expect/end\nHTTP/1.1 200 OK\nconnection: close\ncontent-length: 2\n\n/\n", test.apply(Arrays.asList("POST /expect/end HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nABC", "POST / HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nDEF")));
        this.assertEquals("HTTP/1.1 404 Not Found\ncontent-type: text/html; charset=utf-8\ncontent-length: 53\n\n<html><body><h1>Resource not found</h1></body></html>HTTP/1.1 200 OK\nconnection: close\ncontent-length: 12\n\n/expect/end\n", test.apply(Arrays.asList("POST /not/found HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nDEF", "POST /expect/end HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nABC")));
        this.assertEquals("HTTP/1.1 404 Not Found\ncontent-type: text/html; charset=utf-8\ncontent-length: 53\n\n<html><body><h1>Resource not found</h1></body></html>HTTP/1.1 200 OK\nconnection: close\ncontent-length: 2\n\n/\n", test.apply(Arrays.asList("POST /not/found HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nABC", "POST / HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nDEF")));
        this.assertEquals("HTTP/1.1 404 Not Found\ncontent-type: text/html; charset=utf-8\ncontent-length: 53\n\n<html><body><h1>Resource not found</h1></body></html>HTTP/1.1 200 OK\nconnection: close\ncontent-length: 10\n\n/parse/ok\n", test.apply(Arrays.asList("POST /not/found HTTP/1.1\nHost: localhost\nConnection: keep-alive\nContent-Length: 3\n\nABC", "POST /parse/ok HTTP/1.1\nHost: localhost\nConnection: close\nContent-Length: 3\n\nDEF")));
    }

    @Test
    public void testPausedConnection() {
        this.router.route().handler((Handler)((PlatformHandler)ctx -> {
            ctx.request().pause();
            ctx.vertx().setTimer(1L, t -> {
                ctx.request().resume();
                ctx.next();
            });
        }));
        this.router.route("/").handler(ctx -> ctx.response().end(ctx.normalizedPath() + "\n"));
        int numRequests = 20;
        this.waitFor(numRequests);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        for (int i = 0; i < numRequests; ++i) {
            client.request(new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8080)), this.onSuccess(req -> req.send(TestUtils.randomBuffer((int)65536)).onComplete(this.onSuccess(resp -> this.complete()))));
        }
        this.await();
    }

    @Test
    public void testPausedConnection2() {
        this.router.route().handler((Handler)((PlatformHandler)ctx -> {
            ctx.request().pause();
            ctx.vertx().setTimer(1L, t -> {
                ctx.request().resume();
                ctx.next();
            });
        }));
        this.router.route("/").handler((Handler)BodyHandler.create());
        int numRequests = 20;
        this.waitFor(numRequests);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        for (int i = 0; i < numRequests; ++i) {
            client.request(new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8080)), this.onSuccess(req -> req.send(TestUtils.randomBuffer((int)65536)).onComplete(this.onSuccess(resp -> {
                this.assertEquals(404L, resp.statusCode());
                this.complete();
            }))));
        }
        this.await();
    }

    @Test
    public void testPausedConnection3() {
        this.router.route().handler((Handler)((PlatformHandler)ctx -> {
            ctx.request().pause();
            ctx.vertx().setTimer(1L, t -> {
                ctx.request().resume();
                ctx.next();
            });
        }));
        this.router.route("/").handler(ctx -> ctx.request().endHandler(done -> ctx.response().end(ctx.normalizedPath() + "\n")));
        int numRequests = 20;
        this.waitFor(numRequests);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        for (int i = 0; i < numRequests; ++i) {
            client.request(new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8080)), this.onSuccess(req -> req.send(TestUtils.randomBuffer((int)65536)).onComplete(this.onSuccess(resp -> this.complete()))));
        }
        this.await();
    }

    @Test
    public void testPausedConnection4() {
        this.router.route().handler((Handler)((PlatformHandler)ctx -> ctx.vertx().setTimer(1L, t -> ctx.next())));
        int numRequests = 20;
        this.waitFor(numRequests);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        for (int i = 0; i < numRequests; ++i) {
            client.request(new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8080)), this.onSuccess(req -> req.send(TestUtils.randomBuffer((int)65536)).onComplete(this.onSuccess(resp -> this.complete()))));
        }
        this.await();
    }

    class SomeObject {
        SomeObject() {
        }
    }
}

