/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.StaticHandler;
import org.junit.Test;

public class StaticHandlerWindowsTest
extends WebTestBase {
    @Test
    public void testEscapeToClasspathFromWildcard() throws Exception {
        this.router.clear();
        this.router.route("/*").handler((Handler)StaticHandler.create((String)"www"));
        this.testRequest(HttpMethod.GET, "/..\\.htdigest", 404, "Not Found");
    }

    @Test
    public void testEscapeToClasspathFromNull() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)StaticHandler.create((String)"www"));
        this.testRequest(HttpMethod.GET, "/..\\.htdigest", 404, "Not Found");
    }

    @Test
    public void testEscapeToClasspathFromRegEx() throws Exception {
        this.router.clear();
        this.router.routeWithRegex(".*").handler((Handler)StaticHandler.create((String)"www"));
        this.testRequest(HttpMethod.GET, "/..\\.htdigest", 404, "Not Found");
    }

    @Test
    public void testEscapeToClasspathFromFixedPath() throws Exception {
        this.router.clear();
        this.router.routeWithRegex("/").handler((Handler)StaticHandler.create((String)"www"));
        this.testRequest(HttpMethod.GET, "/..\\.htdigest", 404, "Not Found");
    }
}

