/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.sockjs.SockJSProtocolTest;
import org.junit.Test;

public class SockJSCORSTest
extends WebTestBase {
    @Test
    public void testSockJSInternalCORSHandling() {
        this.router.route().handler((Handler)BodyHandler.create());
        SockJSProtocolTest.installTestApplications(this.router, this.vertx);
        this.client.request(HttpMethod.GET, "/echo/info?t=21321").compose(req -> req.putHeader(HttpHeaders.ORIGIN, (CharSequence)"http://example.com").send()).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("http://example.com", resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
            this.assertEquals("true", resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testNoConflictsSockJSAndCORSHandler() {
        this.router.route().handler((Handler)CorsHandler.create((String)"*").allowCredentials(false)).handler((Handler)BodyHandler.create());
        SockJSProtocolTest.installTestApplications(this.router, this.vertx);
        this.client.request(HttpMethod.GET, "/echo/info?t=21321").compose(req -> req.putHeader(HttpHeaders.ORIGIN, (CharSequence)"http://example.com").send()).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("*", resp.getHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN));
            this.assertFalse(resp.headers().contains(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS));
            this.complete();
        }));
        this.await();
    }

    @Test(expected=IllegalStateException.class)
    public void testNoConflictsSockJSAndCORSHandlerBadSetup() {
        this.router.route().handler((Handler)BodyHandler.create()).handler((Handler)CorsHandler.create((String)"*").allowCredentials(false));
        SockJSProtocolTest.installTestApplications(this.router, this.vertx);
    }

    @Test
    public void testNoConflictsSockJSAndCORSHandlerBadSetupLenient() {
        try {
            System.setProperty("io.vertx.web.router.setup.lenient", "true");
            this.router.route().handler((Handler)BodyHandler.create()).handler((Handler)CorsHandler.create((String)"*").allowCredentials(false));
            SockJSProtocolTest.installTestApplications(this.router, this.vertx);
        }
        finally {
            System.clearProperty("io.vertx.web.router.setup.lenient");
        }
    }
}

