/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.impl.ParsableHeaderValue;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParsableHeaderValueTest {
    private ParsableHeaderValue headerValue;

    @Before
    public void initialize() {
        this.headerValue = new ParsableHeaderValue("application/json; charset=UTF-8");
    }

    @Test
    public void testIsMatchedByEqualsCases() {
        ParsableMIMEValue value = new ParsableMIMEValue("application/json; charset=UTF-8").forceParse();
        Assert.assertTrue((boolean)this.headerValue.isMatchedBy((ParsedHeaderValue)value));
    }

    @Test
    public void testIsMatchedByDiffCases() {
        ParsableMIMEValue value = new ParsableMIMEValue("application/json; charset=utf-8").forceParse();
        Assert.assertTrue((boolean)this.headerValue.isMatchedBy((ParsedHeaderValue)value));
    }

    @Test
    public void testIsMatchedByDiff() {
        ParsableMIMEValue value = new ParsableMIMEValue("application/json; charset=UTF-16").forceParse();
        Assert.assertFalse((boolean)this.headerValue.isMatchedBy((ParsedHeaderValue)value));
    }
}

