/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.SessionHandlerTestBase;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import org.junit.Test;

public class LocalSessionHandlerTest
extends SessionHandlerTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.store = LocalSessionStore.create((Vertx)this.vertx);
    }

    @Test
    public void testRetryTimeout() throws Exception {
        this.assertTrue(this.doTestSessionRetryTimeout() < 3000L);
    }

    @Test
    public void test2123() throws Exception {
        SessionHandler sessionHandler = SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)).setSessionTimeout(10000L).setLazySession(true);
        this.router.clear();
        this.router.route().handler((Handler)sessionHandler);
        this.router.route().handler(ctx -> {
            ctx.session();
            ctx.response().setStatusCode(500);
            sessionHandler.flush(ctx, asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                ctx.end();
            });
        });
        this.testRequest(HttpMethod.GET, "/", 500, "Internal Server Error");
    }
}

