/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.auth.properties.PropertyFileAuthorization;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class BasicAuthImpersonationTest
extends WebTestBase {
    AuthenticationProvider authn;
    AuthorizationProvider authz;
    private static final String USER_SWITCH_KEY = "__vertx.user-switch-ref";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.authn = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.authz = PropertyFileAuthorization.create((Vertx)this.vertx, (String)"login/loginusers.properties");
    }

    @Test
    public void testSwitchUser() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)SessionStore.create((Vertx)this.vertx)));
        this.router.route("/user-switch/impersonate").handler(ctx -> ctx.userContext().loginHint(ctx.request().getParam("login_hint")).impersonate(ctx.request().getParam("redirect_uri")).onFailure(err -> {
            if (err instanceof HttpException) {
                ctx.fail(err);
            } else {
                ctx.fail(500);
            }
        }));
        this.router.route("/user-switch/undo").handler(ctx -> ctx.userContext().loginHint(ctx.request().getParam("login_hint")).restore(ctx.request().getParam("redirect_uri")).onFailure(err -> {
            if (err instanceof HttpException) {
                ctx.fail(err);
            } else {
                ctx.fail(500);
            }
        }));
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)this.authn));
        AtomicReference userRef = new AtomicReference();
        this.router.route("/protected/base").handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"read")).addAuthorizationProvider(this.authz)).handler(rc -> {
            this.assertNotNull(rc.user());
            userRef.set(rc.user());
            rc.end("OK");
        });
        this.router.route("/protected/admin").handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"write")).addAuthorizationProvider(this.authz)).handler(rc -> {
            this.assertNotNull(rc.user());
            User oldUser = (User)userRef.get();
            this.assertNotNull(oldUser);
            User newUser = rc.user();
            this.assertFalse(oldUser.equals(newUser));
            User prevUser = (User)rc.session().get(USER_SWITCH_KEY);
            this.assertNotNull(prevUser);
            this.assertEquals(prevUser, oldUser);
            rc.response().end("Welcome to the 2nd protected resource!");
        });
        AtomicReference sessionRef = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/protected/base", null, resp -> {
            String redirectURL = resp.getHeader("WWW-Authenticate");
            this.assertNotNull(redirectURL);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNull(setCookie);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/base", req -> req.putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)"Basic cmVndWxhcjpyZWd1bGFy"), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            sessionRef.set(setCookie.substring(0, setCookie.indexOf(59)));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/protected/base", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {}, 200, "OK", "OK");
        this.testRequest(HttpMethod.GET, "/protected/admin", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {}, 403, "Forbidden", null);
        this.testRequest(HttpMethod.GET, "/user-switch/impersonate?redirect_uri=/protected/admin&login_hint=admin", req -> {}, resp -> {}, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/user-switch/impersonate?redirect_uri=/protected/admin&login_hint=admin", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            this.assertFalse(setCookie.substring(0, setCookie.indexOf(59)).equals(sessionRef.get()));
            sessionRef.set(setCookie.substring(0, setCookie.indexOf(59)));
            String destination = resp.getHeader(HttpHeaders.LOCATION);
            this.assertNotNull(destination);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/protected/admin", req -> {}, resp -> {}, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/admin", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {
            String redirectURL = resp.getHeader("WWW-Authenticate");
            this.assertNotNull(redirectURL);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNull(setCookie);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/admin", req -> {
            req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get());
            req.putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)"Basic YWRtaW46YWRtaW4=");
        }, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            sessionRef.set(setCookie.substring(0, setCookie.indexOf(59)));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/protected/admin", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {}, 200, "OK", "Welcome to the 2nd protected resource!");
        this.testRequest(HttpMethod.GET, "/user-switch/undo?redirect_uri=/protected/base", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            this.assertFalse(setCookie.substring(0, setCookie.indexOf(59)).equals(sessionRef.get()));
            sessionRef.set(setCookie.substring(0, setCookie.indexOf(59)));
            String destination = resp.getHeader(HttpHeaders.LOCATION);
            this.assertNotNull(destination);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/protected/base", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {}, 200, "OK", "OK");
        this.testRequest(HttpMethod.GET, "/protected/admin", req -> req.putHeader(HttpHeaders.COOKIE, (CharSequence)sessionRef.get()), resp -> {}, 403, "Forbidden", null);
    }
}

