/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.FormLoginHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.List;
import org.junit.Test;

public class ChainAuthHandlerTest
extends WebTestBase {
    private AuthenticationProvider authProvider;
    protected ChainAuthHandler chain;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        RedirectAuthHandler redirectAuthHandler = RedirectAuthHandler.create((AuthenticationProvider)this.authProvider);
        this.chain = ChainAuthHandler.any().add((AuthenticationHandler)JWTAuthHandler.create(null)).add((AuthenticationHandler)BasicAuthHandler.create((AuthenticationProvider)this.authProvider)).add((AuthenticationHandler)redirectAuthHandler);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)this.chain);
        this.router.route().handler(ctx -> ctx.response().end());
    }

    @Test
    public void testWithoutAuthorization() throws Exception {
        this.testRequest(HttpMethod.GET, "/", 302, "Found", "Redirecting to /loginpage.");
    }

    @Test
    public void testWithAuthorization() throws Exception {
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), 200, "OK", "");
    }

    @Test
    public void testWithBadAuthorization() throws Exception {
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcX=="), 302, "Found", null);
    }

    @Test
    public void testWithBasicAuthAsLastHandlerInChain() throws Exception {
        this.router.clear();
        this.chain = ChainAuthHandler.any().add((AuthenticationHandler)JWTAuthHandler.create(null)).add((AuthenticationHandler)BasicAuthHandler.create((AuthenticationProvider)this.authProvider));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)this.chain);
        this.router.route().handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcX=="), resp -> this.assertEquals("Basic realm=\"vertx-web\"", resp.getHeader("WWW-Authenticate")), 401, "Unauthorized", "Unauthorized");
    }

    @Test
    public void testWithMultipleWWWAuthenticate() throws Exception {
        this.router.clear();
        this.chain = ChainAuthHandler.any().add((AuthenticationHandler)BasicAuthHandler.create((AuthenticationProvider)this.authProvider)).add((AuthenticationHandler)DigestAuthHandler.create((Vertx)this.vertx, (HtdigestAuth)HtdigestAuth.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)this.chain);
        this.router.route().handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.assertNotNull(resp.getHeader("WWW-Authenticate"));
            List headers = resp.headers().getAll("WWW-Authenticate");
            this.assertNotNull(headers);
            this.assertEquals(2L, headers.size());
            this.assertTrue(((String)headers.get(0)).startsWith("Basic realm=\"vertx-web\""));
            this.assertTrue(((String)headers.get(1)).startsWith("Digest realm=\"testrealm@host.com\""));
        }, 401, "Unauthorized", "Unauthorized");
    }

    @Test
    public void testWithPostAuthenticationAction() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.chain = ChainAuthHandler.any().add((AuthenticationHandler)FormLoginHandler.create((AuthenticationProvider)this.authProvider).setDirectLoggedInOKURL("/welcome"));
        this.router.post("/login").handler((Handler)BodyHandler.create()).handler((Handler)this.chain);
        this.testRequest(HttpMethod.POST, "/login", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "username" + "\"\r\n\r\ntim\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "password" + "\"\r\n\r\ndelicious:sausages\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.putHeader("content-length", String.valueOf(buffer.length()));
            req.putHeader("content-type", "multipart/form-data; boundary=" + boundary);
            req.write((Object)buffer);
        }, resp -> {
            MultiMap headers = resp.headers();
            String setCookie = headers.get("set-cookie");
            this.assertNotNull(setCookie);
            this.assertTrue(headers.contains(HttpHeaders.LOCATION, (CharSequence)"/welcome", false));
        }, 302, "Found", null);
    }
}

