/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.TimeoutHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;

public class TimeoutHandlerTest
extends WebTestBase {
    @Test
    public void testTimeout() throws Exception {
        long timeout = 500L;
        this.router.route().handler((Handler)TimeoutHandler.create((long)timeout));
        this.router.route().handler(rc -> {});
        this.testRequest(HttpMethod.GET, "/", 503, "Service Unavailable");
    }

    @Test
    public void testTimeoutWithCustomBodyEndHandler() throws Exception {
        long timeout = 500L;
        AtomicBoolean ended = new AtomicBoolean();
        this.router.route().handler(routingContext -> {
            routingContext.addBodyEndHandler(event -> ended.set(true));
            routingContext.next();
        });
        this.router.route().handler((Handler)TimeoutHandler.create((long)timeout));
        this.router.route().handler(rc -> {});
        this.testRequest(HttpMethod.GET, "/", 503, "Service Unavailable");
        TimeoutHandlerTest.waitUntil(ended::get);
    }

    @Test
    public void testTimeoutCancelled() throws Exception {
        long timeout = 500L;
        this.router.route().handler((Handler)TimeoutHandler.create((long)timeout));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        Thread.sleep(1000L);
    }

    @Test
    public void testTimeoutWithReroute() throws Exception {
        this.router.route().handler((Handler)TimeoutHandler.create((long)500L));
        this.router.get("/a").handler(rc -> rc.reroute("/b"));
        this.router.get("/b").handler(RoutingContext::end);
        this.router.errorHandler(503, rc -> this.fail());
        this.testRequest(HttpMethod.GET, "/a", 200, "OK");
        Thread.sleep(1000L);
    }
}

