/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.it;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;

public class SessionHandlerRegression {
    public static void main(String[] args) {
        Vertx vertx = Vertx.vertx();
        LocalSessionStore store = LocalSessionStore.create((Vertx)vertx);
        vertx.deployVerticle(() -> new MyVerticle((SessionStore)store), new DeploymentOptions().setInstances(1));
    }

    public static class MyVerticle
    extends AbstractVerticle {
        SessionStore sessionStore;

        public MyVerticle(SessionStore sessionStore) {
            this.sessionStore = sessionStore;
        }

        public MyVerticle() {
        }

        public void start(Promise<Void> startPromise) {
            if (this.sessionStore == null) {
                this.sessionStore = LocalSessionStore.create((Vertx)this.vertx);
            }
            Router router = Router.router((Vertx)this.vertx);
            router.route().handler((Handler)SessionHandler.create((SessionStore)this.sessionStore));
            router.route().handler(context -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                context.request().endHandler(unused -> context.response().end("hello"));
            });
            HttpServerOptions options = new HttpServerOptions();
            this.vertx.createHttpServer(options).requestHandler((Handler)router).listen(8080, ar -> startPromise.complete());
        }
    }
}

