/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import org.junit.Test;

public class VirtualHostTest
extends WebTestBase {
    @Test
    public void testVHost() throws Exception {
        this.router.route().virtualHost("*.com").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("www.mysite.com").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostPort() throws Exception {
        this.router.route().virtualHost("*.com").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("www.mysite.com:8080").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostIPv6Any() throws Exception {
        this.router.route().virtualHost("::").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("[::]").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostIPv6AnyPort() throws Exception {
        this.router.route().virtualHost("::").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("[::]:8080").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostIPv6Home() throws Exception {
        this.router.route().virtualHost("::1").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("[::1]").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostIPv6HomePort() throws Exception {
        this.router.route().virtualHost("::1").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("[::1]:8080").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 200, "OK", null);
    }

    @Test
    public void testVHostShouldFail() throws Exception {
        this.router.route().virtualHost("*.com").handler(ctx -> ctx.response().end());
        this.router.route().handler(ctx -> ctx.fail(500));
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("www.mysite.net").setPort(Integer.valueOf(80)), (HttpClientRequest req) -> {}, 500, "Internal Server Error", null);
    }

    @Test
    public void testVHostSubRouter() throws Exception {
        Router a = Router.router((Vertx)this.vertx);
        a.get("/somepath").handler(RoutingContext::end);
        this.router.route("/*").virtualHost("*.com").subRouter(a);
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("www.mysite.com").setPort(Integer.valueOf(80)).setURI("/somepath"), (HttpClientRequest req) -> {}, 200, "OK", null);
        this.router.route().virtualHost("*.com").subRouter(a);
        this.testRequest(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)8080, (String)"localhost")).setHost("www.mysite.com").setPort(Integer.valueOf(80)).setURI("/somepath"), (HttpClientRequest req) -> {}, 200, "OK", null);
    }
}

