/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.APIKeyHandler;
import org.junit.Before;
import org.junit.Test;

public class APIKeyHandlerTest
extends WebTestBase {
    AuthenticationProvider authProvider;

    @Before
    public void setup() throws Exception {
        this.authProvider = (credentials, resultHandler) -> {
            if ("APIKEY".equals(credentials.getString("token"))) {
                resultHandler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)new JsonObject())));
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"Uknown APIKEY"));
            }
        };
    }

    @Test
    public void testHeader() throws Exception {
        this.router.route("/protected/*").handler((Handler)APIKeyHandler.create((AuthenticationProvider)this.authProvider));
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, null, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("x-api-key", "APIKEY"), 200, "OK", "Welcome to the protected resource!");
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("x-api-key", "APIKEY2"), 401, "Unauthorized", null);
    }

    @Test
    public void testCustomHeader() throws Exception {
        this.router.route("/protected/*").handler((Handler)APIKeyHandler.create((AuthenticationProvider)this.authProvider).header("xyz-api-key"));
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, null, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("xyz-api-key", "APIKEY"), 200, "OK", "Welcome to the protected resource!");
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("xyz-api-key", "APIKEY2"), 401, "Unauthorized", null);
    }

    @Test
    public void testCustomParam() throws Exception {
        this.router.route("/protected/*").handler((Handler)APIKeyHandler.create((AuthenticationProvider)this.authProvider).parameter("api_key"));
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, null, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage?api_key=APIKEY", null, 200, "OK", "Welcome to the protected resource!");
        this.testRequest(HttpMethod.GET, "/protected/somepage?api_key=APIKEY2", null, 401, "Unauthorized", null);
    }

    @Test
    public void testCustomCookie() throws Exception {
        this.router.route("/protected/*").handler((Handler)APIKeyHandler.create((AuthenticationProvider)this.authProvider).cookie("api-key"));
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, null, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("Cookie", "api-key=APIKEY"), 200, "OK", "Welcome to the protected resource!");
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("Cookie", "api-key=APIKEY2"), 401, "Unauthorized", null);
    }
}

