/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.AuthHandlerTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class BasicAuthHandlerTest
extends AuthHandlerTestBase {
    @Test
    public void testLoginDefaultRealm() throws Exception {
        this.doLogin("vertx-web");
    }

    @Test
    public void testLoginNonDefaultRealm() throws Exception {
        this.doLogin("aardvarks");
    }

    private void doLogin(String realm) throws Exception {
        Handler handler = rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("tim", rc.user().principal().getString("username"));
            rc.response().end("Welcome to the protected resource!");
        };
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)authProvider, (String)realm));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 200, "OK", "Welcome to the protected resource!");
    }

    @Test
    public void testWithSessions() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        SerializingSessionStore store = new SerializingSessionStore();
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)authProvider));
        AtomicReference sessionID = new AtomicReference();
        AtomicInteger count = new AtomicInteger();
        Handler handler = rc -> {
            int c = count.incrementAndGet();
            this.assertNotNull(rc.session());
            String sessID = (String)sessionID.get();
            if (sessID != null) {
                this.assertEquals(sessID, rc.session().id());
            }
            this.assertNotNull(rc.user());
            this.assertEquals("tim", rc.user().principal().getString("username"));
            if (c == 7) {
                rc.clearUser();
            }
            rc.response().end("Welcome to the protected resource!");
        };
        this.router.route("/protected/somepage").handler(handler);
        AtomicReference sessionCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"vertx-web\"", wwwAuth);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNull(setCookie);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            sessionCookie.set(setCookie);
        }, 200, "OK", "Welcome to the protected resource!");
        for (int i = 0; i < 5; ++i) {
            this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("cookie", (String)sessionCookie.get()), resp -> {
                String wwwAuth = resp.headers().get("WWW-Authenticate");
                this.assertNull(wwwAuth);
            }, 200, "OK", "Welcome to the protected resource!");
        }
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"vertx-web\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 200, "OK", "Welcome to the protected resource!");
    }

    @Test
    public void testLoginFail() throws Exception {
        String realm = "vertx-web";
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOn5hdXdhZ2Vz"), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
    }

    @Test
    public void testLoginFailWithBadBase64() throws Exception {
        String realm = "vertx-web";
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOn5hdXdhZ2Vz="), resp -> {}, 400, "Bad Request", null);
    }

    @Override
    protected AuthenticationHandler createAuthHandler(AuthenticationProvider authProvider) {
        return BasicAuthHandler.create((AuthenticationProvider)authProvider);
    }

    @Test
    public void testSecurityBypass() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.router.route().pathRegex("/api/.*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)authProvider));
        this.router.route("/api/v1/standard-job-profiles").handler(handler);
        this.testRequest(HttpMethod.GET, "//api/v1/standard-job-profiles", 401, "Unauthorized");
    }

    static /* synthetic */ Vertx access$100(BasicAuthHandlerTest x0) {
        return x0.vertx;
    }

    private class SerializingSessionStore
    implements SessionStore {
        private final Map<String, Buffer> sessions = new ConcurrentHashMap<String, Buffer>();
        private final VertxContextPRNG prng = VertxContextPRNG.current((Vertx)BasicAuthHandlerTest.access$100(BasicAuthHandlerTest.this));

        private SerializingSessionStore() {
        }

        public SessionStore init(Vertx vertx, JsonObject options) {
            return this;
        }

        public long retryTimeout() {
            return 0L;
        }

        public Session createSession(long timeout) {
            return new SharedDataSessionImpl(this.prng, timeout, 16);
        }

        public Session createSession(long timeout, int length) {
            return new SharedDataSessionImpl(this.prng, timeout, length);
        }

        public Future<@Nullable Session> get(String id) {
            SharedDataSessionImpl sess;
            PromiseInternal promise = ((VertxInternal)BasicAuthHandlerTest.this.vertx).promise();
            Buffer buff = this.sessions.get(id);
            if (buff != null) {
                sess = new SharedDataSessionImpl(this.prng);
                sess.readFromBuffer(0, buff);
            } else {
                sess = null;
            }
            BasicAuthHandlerTest.this.vertx.runOnContext(arg_0 -> SerializingSessionStore.lambda$get$0((Promise)promise, sess, arg_0));
            return promise.future();
        }

        public Future<Void> delete(String id) {
            PromiseInternal promise = ((VertxInternal)BasicAuthHandlerTest.this.vertx).promise();
            this.sessions.remove(id);
            BasicAuthHandlerTest.this.vertx.runOnContext(arg_0 -> SerializingSessionStore.lambda$delete$1((Promise)promise, arg_0));
            return promise.future();
        }

        public Future<Void> put(Session session) {
            PromiseInternal promise = ((VertxInternal)BasicAuthHandlerTest.this.vertx).promise();
            ClusterSerializable cs = (ClusterSerializable)session;
            Buffer buff = Buffer.buffer();
            cs.writeToBuffer(buff);
            this.sessions.put(session.id(), buff);
            BasicAuthHandlerTest.this.vertx.runOnContext(arg_0 -> SerializingSessionStore.lambda$put$2((Promise)promise, arg_0));
            return promise.future();
        }

        public Future<Void> clear() {
            PromiseInternal promise = ((VertxInternal)BasicAuthHandlerTest.this.vertx).promise();
            this.sessions.clear();
            BasicAuthHandlerTest.this.vertx.runOnContext(arg_0 -> SerializingSessionStore.lambda$clear$3((Promise)promise, arg_0));
            return promise.future();
        }

        public Future<Integer> size() {
            PromiseInternal promise = ((VertxInternal)BasicAuthHandlerTest.this.vertx).promise();
            BasicAuthHandlerTest.this.vertx.runOnContext(arg_0 -> this.lambda$size$4((Promise)promise, arg_0));
            return promise.future();
        }

        public void close() {
            this.sessions.clear();
        }

        private /* synthetic */ void lambda$size$4(Promise promise, Void v) {
            promise.complete((Object)this.sessions.size());
        }

        private static /* synthetic */ void lambda$clear$3(Promise promise, Void v) {
            promise.complete();
        }

        private static /* synthetic */ void lambda$put$2(Promise promise, Void v) {
            promise.complete();
        }

        private static /* synthetic */ void lambda$delete$1(Promise promise, Void v) {
            promise.complete();
        }

        private static /* synthetic */ void lambda$get$0(Promise promise, SharedDataSessionImpl sess, Void v) {
            promise.complete((Object)sess);
        }
    }
}

