/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.DigestAuthHandler;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class DigestAuthHandlerTest
extends WebTestBase {
    private static final MessageDigest MD5;
    private static final String DEFAULT_NONCE_MAP_NAME = "htdigest.nonces";

    @Test
    public void testLoginDefaultRealm() throws Exception {
        this.doLogin("testrealm@host.com");
    }

    @Test
    public void checkNoncesCleanup() throws Exception {
        this.router.clear();
        HtdigestAuth authProvider = HtdigestAuth.create((Vertx)this.vertx);
        this.router.route("/dir/*").handler((Handler)DigestAuthHandler.create((Vertx)this.vertx, (HtdigestAuth)authProvider, (long)-100L));
        int initialNoncesSize = this.vertx.sharedData().getLocalMap(DEFAULT_NONCE_MAP_NAME).size();
        int numRequests = 5;
        for (int i = 0; i < numRequests; ++i) {
            this.testRequest(HttpMethod.GET, "/dir/index.html", null, null, 401, "Unauthorized", null);
        }
        int finalNoncesSize = this.vertx.sharedData().getLocalMap(DEFAULT_NONCE_MAP_NAME).size();
        this.assertEquals(initialNoncesSize + 1, finalNoncesSize);
    }

    private void doLogin(String realm) throws Exception {
        this.router.clear();
        Handler handler = rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("Mufasa", rc.user().principal().getString("username"));
            rc.response().end("Welcome to the protected resource!");
        };
        HtdigestAuth authProvider = HtdigestAuth.create((Vertx)this.vertx);
        this.router.route("/dir/*").handler((Handler)DigestAuthHandler.create((Vertx)this.vertx, (HtdigestAuth)authProvider));
        this.router.route("/dir/index.html").handler(handler);
        AtomicReference nonce = new AtomicReference();
        AtomicReference opaque = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/dir/index.html", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertTrue(wwwAuth.startsWith("Digest realm=\"" + realm + "\", qop=\"auth\", nonce=\""));
            int pos = wwwAuth.indexOf("nonce=\"") + 7;
            nonce.set(wwwAuth.substring(pos, DigestAuthHandlerTest.endOfVariable(wwwAuth, pos, '\"')));
            pos = wwwAuth.indexOf("opaque=\"") + 8;
            opaque.set(wwwAuth.substring(pos, DigestAuthHandlerTest.endOfVariable(wwwAuth, pos, '\"')));
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/dir/index.html", req -> {
            String response = DigestAuthHandlerTest.md5("939e7578ed9e3c518a452acee763bce9:" + (String)nonce.get() + ":00000001:0a4f113b:auth:39aff3a2bab6126f332b942af96d3366");
            req.putHeader("Authorization", "Digest username=\"Mufasa\", realm=\"testrealm@host.com\", nonce=\"" + (String)nonce.get() + "\", uri=\"/dir/index.html\", qop=auth, nc=00000001, cnonce=\"0a4f113b\", response=\"" + response + "\", opaque=\"" + (String)opaque.get() + "\"");
        }, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 200, "OK", "Welcome to the protected resource!");
    }

    private static int endOfVariable(String header, int pos, char delim) {
        int i;
        for (i = pos; i < header.length() && header.charAt(i) != delim; ++i) {
        }
        return i;
    }

    private static synchronized String md5(String payload) {
        MD5.reset();
        return Codec.base16Encode((byte[])MD5.digest(payload.getBytes(StandardCharsets.UTF_8)));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

