/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import io.vertx.test.core.TestUtils;
import org.junit.Test;

public class SockJSEventBusTest
extends SockJSTestBase {
    @Test
    public void testWriteText() throws Exception {
        this.testWrite(true);
    }

    @Test
    public void testWriteBinary() throws Exception {
        this.testWrite(false);
    }

    private void testWrite(boolean text) throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            if (text) {
                this.vertx.eventBus().send(socket.writeHandlerID(), (Object)expected);
            } else {
                this.vertx.eventBus().send(socket.writeHandlerID(), (Object)Buffer.buffer((String)expected));
            }
            socket.endHandler(v -> this.testComplete());
        };
        this.startServers();
        this.client.webSocket("/test/websocket", this.onSuccess(ws -> ws.frameHandler(frame -> {
            if (!frame.isClose()) {
                if (text) {
                    this.assertTrue(frame.isText());
                    this.assertEquals(expected, frame.textData());
                } else {
                    this.assertTrue(frame.isBinary());
                    this.assertEquals(Buffer.buffer((String)expected), frame.binaryData());
                }
                ws.end();
            }
        })));
        this.await();
    }
}

