/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.Utils;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class SockJSProtocolTest {
    private static Vertx vertx;
    private static HttpServer server;

    @BeforeClass
    public static void before() throws Exception {
        vertx = Vertx.vertx();
        server = vertx.createHttpServer();
        Router router = Router.router((Vertx)vertx);
        SockJSProtocolTest.installTestApplications(router, vertx);
        server.requestHandler((Handler)router).listen(8081, "localhost");
    }

    @AfterClass
    public static void after() {
        server.close();
        vertx.close();
    }

    private String runPython(String cmd, Predicate<String> exitTest) throws Exception {
        StringBuilder output = new StringBuilder();
        String path = new File("./src/test/sockjs-protocol/").getCanonicalPath();
        try (GenericContainer container = new GenericContainer(DockerImageName.parse((String)"python:2.7-alpine"));){
            container.withFileSystemBind(path, "/usr/src/myapp");
            container.withWorkingDirectory("/usr/src/myapp");
            container.addEnv("SOCKJS_URL", "http://host.docker.internal:8081");
            CountDownLatch latch = new CountDownLatch(1);
            container.withLogConsumer(frame -> {
                String s = frame.getUtf8String();
                output.append(frame.getUtf8String());
                if (exitTest.test(s)) {
                    latch.countDown();
                }
            });
            container.setNetworkMode("host");
            container.withCommand(cmd);
            container.start();
            latch.await(50L, TimeUnit.SECONDS);
        }
        return output.toString();
    }

    public static void installTestApplications(Router router, final Vertx vertx) {
        router.post().handler((Handler)BodyHandler.create());
        router.route("/echo*").subRouter(SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.handler(arg_0 -> ((SockJSSocket)sock).write(arg_0))));
        router.route("/close*").subRouter(SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> vertx.setTimer(10L, id -> sock.close(3000, "Go away!"))));
        router.route("/disabled_websocket_echo*").subRouter(SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096).addDisabledTransport("WEBSOCKET")).socketHandler(sock -> sock.handler(arg_0 -> ((SockJSSocket)sock).write(arg_0))));
        router.route("/ticker*").subRouter(SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> {
            long timerID = vertx.setPeriodic(1000L, tid -> sock.write(Buffer.buffer((String)"tick!")));
            sock.endHandler(v -> vertx.cancelTimer(timerID));
        }));
        router.route("/amplify*").subRouter(SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.handler(data -> {
            String str = data.toString();
            int n = Integer.valueOf(str);
            if (n < 0 || n > 19) {
                n = 1;
            }
            int num = (int)Math.pow(2.0, n);
            Buffer buff = Buffer.buffer((int)num);
            for (int i = 0; i < num; ++i) {
                buff.appendByte((byte)120);
            }
            sock.write(buff);
        })));
        router.route("/broadcast*").subRouter(SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)new SockJSHandlerOptions().setMaxBytesStreaming(4096).setRegisterWriteHandler(true)).socketHandler((Handler)new Handler<SockJSSocket>(){
            Set<String> connections = new HashSet<String>();

            public void handle(SockJSSocket sock) {
                String writeHandlerID = sock.writeHandlerID();
                if (writeHandlerID != null) {
                    this.connections.add(writeHandlerID);
                    sock.handler(buffer -> {
                        for (String actorID : this.connections) {
                            vertx.eventBus().publish(actorID, buffer);
                        }
                    });
                    sock.endHandler(v -> this.connections.remove(writeHandlerID));
                }
            }
        }));
        SockJSHandlerOptions options = new SockJSHandlerOptions().setMaxBytesStreaming(4096).setInsertJSESSIONID(true);
        SockJSHandler sockJSHandler = SockJSHandler.create((Vertx)vertx, (SockJSHandlerOptions)options);
        Router socketHandler = sockJSHandler.socketHandler(sock -> sock.handler(arg_0 -> ((SockJSSocket)sock).write(arg_0)));
        router.route("/cookie_needed_echo*").subRouter(socketHandler);
    }

    @Test
    public void testProtocol() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String output = this.runPython("python sockjs-protocol.py", s -> s.startsWith("OK"));
        Assert.assertTrue((String)output, (boolean)output.contains("Ran 67 tests"));
    }

    @Test
    public void testQuirks() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String output = this.runPython("python http-quirks.py", s -> s.startsWith("OK"));
        Assert.assertTrue((String)output, (boolean)output.contains("Ran 1 test"));
    }
}

