/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.impl.HandlersList;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HandlersListTest {
    private final HandlersList<Object> handlersList = new HandlersList();
    private int counter = 0;

    @Test
    public void one() {
        CapturingHandler ch = new CapturingHandler();
        this.handlersList.put((Handler)ch);
        Object event = new Object();
        this.handlersList.invokeInReverseOrder(event);
        Assert.assertEquals((long)1L, (long)ch.events.size());
        Assert.assertEquals((Object)event, (Object)ch.events.get(0));
    }

    @Test
    public void removeOutOfBounds() {
        this.handlersList.put((Handler)new CapturingHandler());
        Assert.assertFalse((boolean)this.handlersList.remove(-1));
        Assert.assertFalse((boolean)this.handlersList.remove(1));
    }

    @Test
    public void multi() {
        CapturingHandler ch1 = new CapturingHandler();
        this.handlersList.put((Handler)ch1);
        CapturingHandler ch2 = new CapturingHandler();
        int id2 = this.handlersList.put((Handler)ch2);
        CapturingHandler ch3 = new CapturingHandler();
        this.handlersList.put((Handler)ch3);
        Assert.assertTrue((boolean)this.handlersList.remove(id2));
        Assert.assertFalse((boolean)this.handlersList.remove(id2));
        Object event1 = new Object();
        this.handlersList.invokeInReverseOrder(event1);
        Assert.assertEquals((long)0L, (long)ch3.index);
        Assert.assertEquals((long)1L, (long)ch3.events.size());
        Assert.assertEquals((Object)event1, (Object)ch3.events.get(0));
        Assert.assertEquals((long)0L, (long)ch2.events.size());
        Assert.assertEquals((long)1L, (long)ch1.index);
        Assert.assertEquals((long)1L, (long)ch1.events.size());
        Assert.assertEquals((Object)event1, (Object)ch1.events.get(0));
        Object event2 = new Object();
        this.handlersList.invokeInReverseOrder(event2);
        Assert.assertEquals((long)2L, (long)ch3.index);
        Assert.assertEquals((long)2L, (long)ch3.events.size());
        Assert.assertEquals((Object)event2, (Object)ch3.events.get(1));
        Assert.assertEquals((long)0L, (long)ch2.events.size());
        Assert.assertEquals((long)3L, (long)ch1.index);
        Assert.assertEquals((long)2L, (long)ch1.events.size());
        Assert.assertEquals((Object)event2, (Object)ch1.events.get(1));
        this.handlersList.clear();
        this.handlersList.invokeInReverseOrder(new Object());
        Assert.assertEquals((long)2L, (long)ch3.events.size());
        Assert.assertEquals((long)0L, (long)ch2.events.size());
        Assert.assertEquals((long)2L, (long)ch1.events.size());
    }

    @Test
    public void deleteOnEmpty() {
        Assert.assertFalse((boolean)this.handlersList.remove(3));
    }

    private class CapturingHandler
    implements Handler<Object> {
        List<Object> events = new ArrayList<Object>();
        int index;

        private CapturingHandler() {
        }

        public void handle(Object event) {
            this.events.add(event);
            this.index = HandlersListTest.this.counter++;
        }
    }
}

