/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.ext.web.impl.Origin;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class OriginTests {

    @RunWith(value=Parameterized.class)
    public static class InvalidOriginTest {
        private final String origin;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"httpss://www.google.com"}, {"http://1[::1]:8080"}, {"http://my_site.com"}, {"http://1[::1]:8080"}, {"chrome-extension://gmbg0klkmjakoegficnlkhebmhkjfich"}, {"chrome-extension://gmbgaklkmjako"});
        }

        public InvalidOriginTest(String origin) {
            this.origin = origin;
        }

        @Test
        public void testInvalidOrigin() {
            try {
                Origin.parse((String)this.origin);
                Assert.fail((String)("Should fail as it is a invalid origin: " + this.origin));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)Origin.isValid((String)this.origin));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ValidOriginTest {
        private final String origin;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"null"}, {"http://www.vertx.io"}, {"http://[::1]"}, {"http://my-site.com"}, {"http://my-site.123.com"}, {"chrome-extension://gmbgaklkmjakoegficnlkhebmhkjfich"});
        }

        public ValidOriginTest(String origin) {
            this.origin = origin;
        }

        @Test
        public void testValidOrigin() {
            Origin.parse((String)this.origin);
            Assert.assertTrue((boolean)Origin.isValid((String)this.origin));
        }
    }
}

