/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.it;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import org.junit.AfterClass;
import org.junit.Test;

public class RoutingContextDatabindTest
extends WebTestBase {
    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().handler((Handler)BodyHandler.create());
    }

    @Test
    public void testJsonBean() throws Exception {
        this.router.route().handler(ctx -> {
            Point p = new Point();
            p.setX(10);
            p.setY(20);
            ctx.json((Object)p);
        }).failureHandler(ctx -> ctx.failure().printStackTrace());
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("application/json", res.getHeader("Content-Type")), HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), "{\"x\":10,\"y\":20}");
    }

    static class Point {
        public int x;
        public int y;

        Point() {
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

