/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

public abstract class HTTPAuthorizationHandler<T extends AuthenticationProvider>
extends AuthenticationHandlerImpl<T> {
    protected final Type type;
    protected final String realm;

    public HTTPAuthorizationHandler(T authProvider, Type type, String realm) {
        super(authProvider);
        this.type = type;
        String string = this.realm = realm == null ? null : realm.replaceAll("\"", "\\\"");
        if (this.realm != null && (this.realm.indexOf(13) != -1 || this.realm.indexOf(10) != -1)) {
            throw new IllegalArgumentException("Not allowed [\\r|\\n] characters detected on realm name");
        }
    }

    protected final Future<String> parseAuthorization(RoutingContext ctx) {
        return this.parseAuthorization(ctx, false);
    }

    protected final Future<String> parseAuthorization(RoutingContext ctx, boolean optional) {
        HttpServerRequest request = ctx.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            if (optional) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((Throwable)UNAUTHORIZED);
        }
        try {
            int idx = authorization.indexOf(32);
            if (idx <= 0) {
                return Future.failedFuture((Throwable)BAD_REQUEST);
            }
            if (!this.type.is(authorization.substring(0, idx))) {
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
            return Future.succeededFuture((Object)authorization.substring(idx + 1));
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    @Override
    public boolean setAuthenticateHeader(RoutingContext context) {
        if (this.realm != null && this.realm.length() > 0) {
            context.response().headers().add("WWW-Authenticate", this.type + " realm=\"" + this.realm + "\"");
            return true;
        }
        return false;
    }

    public static enum Type {
        BASIC("Basic"),
        DIGEST("Digest"),
        BEARER("Bearer"),
        HOBA("HOBA"),
        MUTUAL("Mutual"),
        NEGOTIATE("Negotiate"),
        OAUTH("OAuth"),
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public boolean is(String other) {
            return this.label.equalsIgnoreCase(other);
        }

        public String toString() {
            return this.label;
        }
    }
}

