/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.APIKeyHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.function.Function;

public class APIKeyHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements APIKeyHandler {
    private Type source = Type.HEADER;
    private String value = "X-API-KEY";
    private Function<String, Future<String>> tokenExtractor = null;

    public APIKeyHandlerImpl(AuthenticationProvider authProvider) {
        super(authProvider);
    }

    @Override
    public APIKeyHandler header(String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("'headerName' cannot be null");
        }
        this.source = Type.HEADER;
        this.value = headerName;
        return this;
    }

    @Override
    public APIKeyHandler parameter(String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException("'paramName' cannot be null");
        }
        this.source = Type.PARAMETER;
        this.value = paramName;
        return this;
    }

    @Override
    public APIKeyHandler cookie(String cookieName) {
        if (cookieName == null) {
            throw new IllegalArgumentException("'cookieName' cannot be null");
        }
        this.source = Type.COOKIE;
        this.value = cookieName;
        return this;
    }

    @Override
    public Future<User> authenticate(RoutingContext context) {
        String token;
        SecurityAudit audit = ((RoutingContextInternal)context).securityAudit();
        switch (this.source) {
            case HEADER: {
                MultiMap headers = context.request().headers();
                if (headers != null && headers.contains(this.value)) {
                    token = headers.get(this.value);
                    break;
                }
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
            case PARAMETER: {
                MultiMap params = context.request().params();
                if (params != null && params.contains(this.value)) {
                    token = params.get(this.value);
                    break;
                }
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
            case COOKIE: {
                Cookie cookie = context.request().getCookie(this.value);
                if (cookie != null) {
                    token = cookie.getValue();
                    break;
                }
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
            default: {
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
        }
        if (this.tokenExtractor != null) {
            return this.tokenExtractor.apply(token).compose(processedToken -> this.authenticate(audit, (String)processedToken));
        }
        return this.authenticate(audit, token);
    }

    private Future<User> authenticate(SecurityAudit audit, String token) {
        TokenCredentials credentials = new TokenCredentials(token);
        audit.credentials((Credentials)credentials);
        return this.authProvider.authenticate((Credentials)credentials).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).recover(err -> Future.failedFuture((Throwable)new HttpException(401, (Throwable)err)));
    }

    @Override
    public APIKeyHandler tokenExtractor(Function<String, Future<String>> tokenExtractor) {
        this.tokenExtractor = tokenExtractor;
        return this;
    }

    static enum Type {
        HEADER,
        PARAMETER,
        COOKIE;

    }
}

