/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.MimeMapping;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.RFC3986;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.Http2PushMapping;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.impl.LRUCache;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.Utils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticHandlerImpl
implements StaticHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHandlerImpl.class);
    private String webRoot = "webroot";
    private long maxAgeSeconds = 86400L;
    private boolean directoryListing = false;
    private String directoryTemplateResource = "META-INF/vertx/web/vertx-web-directory.html";
    private String directoryTemplate;
    private boolean includeHidden = true;
    private boolean filesReadOnly = true;
    private String indexPage = "index.html";
    private List<Http2PushMapping> http2PushMappings;
    private boolean rangeSupport = true;
    private boolean allowRootFileSystemAccess = false;
    private boolean sendVaryHeader = true;
    private String defaultContentEncoding = Charset.defaultCharset().name();
    private Set<String> compressedMediaTypes = Collections.emptySet();
    private Set<String> compressedFileSuffixes = Collections.emptySet();
    private final FSTune tune = new FSTune();
    private final FSPropsCache cache = new FSPropsCache();
    private static final Pattern RANGE = Pattern.compile("^bytes=(\\d+)-(\\d*)$");
    private static final Collection<MIMEHeader> DIRECTORY_LISTING_ACCEPT = Arrays.asList(new ParsableMIMEValue("text/html").forceParse(), new ParsableMIMEValue("text/plain").forceParse(), new ParsableMIMEValue("application/json").forceParse());

    public StaticHandlerImpl(FileSystemAccess visibility, String staticRootDirectory) {
        switch (visibility) {
            case ROOT: {
                this.allowRootFileSystemAccess = true;
                break;
            }
            case RELATIVE: {
                this.allowRootFileSystemAccess = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported visibility: " + String.valueOf((Object)visibility));
            }
        }
        this.setRoot(staticRootDirectory != null ? staticRootDirectory : "webroot");
    }

    private String directoryTemplate(FileSystem fileSystem) {
        if (this.directoryTemplate == null) {
            this.directoryTemplate = fileSystem.readFileBlocking(this.directoryTemplateResource).toString(StandardCharsets.UTF_8);
        }
        return this.directoryTemplate;
    }

    private void writeCacheHeaders(HttpServerRequest request, FileProps props) {
        MultiMap headers = request.response().headers();
        if (this.cache.enabled()) {
            Utils.addToMapIfAbsent(headers, HttpHeaders.CACHE_CONTROL, "public, immutable, max-age=" + this.maxAgeSeconds);
            Utils.addToMapIfAbsent(headers, HttpHeaders.LAST_MODIFIED, Utils.formatRFC1123DateTime(props.lastModifiedTime()));
            if (this.sendVaryHeader && request.headers().contains(HttpHeaders.ACCEPT_ENCODING)) {
                Utils.addToMapIfAbsent(headers, HttpHeaders.VARY, "accept-encoding");
            }
        }
        headers.set("date", Utils.formatRFC1123DateTime(System.currentTimeMillis()));
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Not GET or HEAD so ignoring request");
            }
            context.next();
        } else {
            String uriDecodedPath;
            if (!request.isEnded()) {
                request.pause();
            }
            if ((uriDecodedPath = RFC3986.decodeURIComponent((String)context.normalizedPath(), (boolean)false)) == null) {
                LOG.warn((Object)("Invalid path: " + context.request().path()));
                context.next();
                return;
            }
            String path = RFC3986.removeDotSegments((CharSequence)uriDecodedPath.replace('\\', '/'));
            FileSystem fs = context.vertx().fileSystem();
            this.sendStatic(context, fs, path, !this.directoryListing && "/".equals(path));
        }
    }

    private void sendStatic(RoutingContext context, FileSystem fileSystem, String path, boolean index) {
        Object localFile;
        boolean dirty;
        int idx;
        String name;
        String file = null;
        if (!this.includeHidden && (name = (file = this.getFile(path, context)).substring((idx = file.lastIndexOf(47)) + 1)).length() > 0 && name.charAt(0) == '.') {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.next();
            return;
        }
        CacheEntry entry = this.cache.get(path);
        if (entry != null && (this.filesReadOnly || !entry.isOutOfDate())) {
            if (entry.isMissing()) {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.next();
                return;
            }
            long lastModified = Utils.secondsFactor(entry.props.lastModifiedTime());
            if (Utils.fresh(context, lastModified)) {
                context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                return;
            }
        }
        boolean bl = dirty = this.cache.enabled() && entry != null;
        if (file == null) {
            String ctxFile = this.getFile(path, context);
            localFile = index ? ctxFile + this.indexPage : ctxFile;
        } else {
            localFile = index ? file + this.indexPage : file;
        }
        fileSystem.exists((String)localFile).onFailure(err -> {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.fail((Throwable)err);
        }).onSuccess(arg_0 -> this.lambda$sendStatic$3(path, context, fileSystem, (String)localFile, dirty, index, arg_0));
    }

    private void sendDirectory(RoutingContext context, FileSystem fileSystem, String path, String file) {
        if (!path.endsWith("/")) {
            context.response().putHeader(HttpHeaders.LOCATION, (CharSequence)(path + "/")).setStatusCode(301).end();
            return;
        }
        if (this.directoryListing) {
            this.sendDirectoryListing(fileSystem, file, context);
        } else if (this.indexPage != null) {
            this.sendStatic(context, fileSystem, path, true);
        } else {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.fail(HttpResponseStatus.FORBIDDEN.code());
        }
    }

    private Future<FileProps> getFileProps(FileSystem fileSystem, String file) {
        if (this.tune.useAsyncFS()) {
            return fileSystem.props(file);
        }
        try {
            boolean tuneEnabled = this.tune.enabled();
            long start = tuneEnabled ? System.nanoTime() : 0L;
            FileProps props = fileSystem.propsBlocking(file);
            if (tuneEnabled) {
                this.tune.update(start, System.nanoTime());
            }
            return Future.succeededFuture((Object)props);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e.getCause());
        }
    }

    private void sendFile(RoutingContext context, FileSystem fileSystem, String file, FileProps fileProps) {
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        Long offset = null;
        Long end = null;
        MultiMap headers = null;
        if (response.closed()) {
            return;
        }
        if (this.rangeSupport) {
            Matcher m;
            String range = request.getHeader("Range");
            end = fileProps.size() - 1L;
            if (range != null && (m = RANGE.matcher(range)).matches()) {
                try {
                    String part = m.group(1);
                    offset = Long.parseLong(part);
                    if (offset < 0L || offset >= fileProps.size()) {
                        throw new IndexOutOfBoundsException();
                    }
                    part = m.group(2);
                    if (part != null && part.length() > 0 && (end = Long.valueOf(Math.min(end, Long.parseLong(part)))) < offset) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    context.response().putHeader(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes */" + fileProps.size()));
                    if (!context.request().isEnded()) {
                        context.request().resume();
                    }
                    context.fail(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code());
                    return;
                }
            }
            headers = response.headers();
            headers.set(HttpHeaders.ACCEPT_RANGES, (CharSequence)"bytes");
            headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(end + 1L - (offset == null ? 0L : offset)));
        }
        this.writeCacheHeaders(request, fileProps);
        if (request.method() == HttpMethod.HEAD) {
            response.end();
        } else if (this.rangeSupport && offset != null) {
            headers.set(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes " + offset + "-" + end + "/" + fileProps.size()));
            response.setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code());
            long finalOffset = offset;
            long finalLength = end + 1L - offset;
            String contentType = MimeMapping.mimeTypeForFilename((String)file);
            if (contentType != null) {
                if (contentType.startsWith("text")) {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                } else {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                }
            }
            response.sendFile(file, finalOffset, finalLength).onFailure(err -> {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.fail((Throwable)err);
            });
        } else {
            String extension = this.getFileExtension(file);
            String contentType = MimeMapping.mimeTypeForExtension((String)extension);
            if (this.compressedMediaTypes.contains(contentType) || this.compressedFileSuffixes.contains(extension)) {
                response.putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY);
            }
            if (contentType != null) {
                if (contentType.startsWith("text")) {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                } else {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                }
            }
            if (request.version() == HttpVersion.HTTP_2 && this.http2PushMappings != null) {
                for (Http2PushMapping dependency : this.http2PushMappings) {
                    if (dependency.isNoPush()) continue;
                    String dep = this.webRoot + "/" + dependency.getFilePath();
                    this.getFileProps(fileSystem, dep).onSuccess(fprops -> {
                        this.writeCacheHeaders(request, (FileProps)fprops);
                        response.push(HttpMethod.GET, "/" + dependency.getFilePath()).onSuccess(res -> {
                            String depContentType = MimeMapping.mimeTypeForExtension((String)file);
                            if (depContentType != null) {
                                if (depContentType.startsWith("text")) {
                                    res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                                } else {
                                    res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                                }
                            }
                            res.sendFile(this.webRoot + "/" + dependency.getFilePath());
                        });
                    });
                }
            } else if (this.http2PushMappings != null) {
                ArrayList links = new ArrayList();
                for (Http2PushMapping dependency : this.http2PushMappings) {
                    String dep = this.webRoot + "/" + dependency.getFilePath();
                    this.getFileProps(fileSystem, dep).onSuccess(fprops -> {
                        this.writeCacheHeaders(request, (FileProps)fprops);
                        links.add("<" + dependency.getFilePath() + ">; rel=preload; as=" + dependency.getExtensionTarget() + (dependency.isNoPush() ? "; nopush" : ""));
                    });
                }
                response.putHeader("Link", links);
            }
            response.sendFile(file).onFailure(err -> {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.fail((Throwable)err);
            });
        }
    }

    @Override
    public StaticHandler setFilesReadOnly(boolean readOnly) {
        this.filesReadOnly = readOnly;
        return this;
    }

    @Override
    public StaticHandler setMaxAgeSeconds(long maxAgeSeconds) {
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.maxAgeSeconds = maxAgeSeconds;
        return this;
    }

    @Override
    public StaticHandler setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    @Override
    public StaticHandler setCachingEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
        return this;
    }

    @Override
    public StaticHandler setDirectoryListing(boolean directoryListing) {
        this.directoryListing = directoryListing;
        return this;
    }

    @Override
    public StaticHandler setDirectoryTemplate(String directoryTemplate) {
        this.directoryTemplateResource = directoryTemplate;
        this.directoryTemplate = null;
        return this;
    }

    @Override
    public StaticHandler setEnableRangeSupport(boolean enableRangeSupport) {
        this.rangeSupport = enableRangeSupport;
        return this;
    }

    @Override
    public StaticHandler setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        return this;
    }

    @Override
    public StaticHandler setCacheEntryTimeout(long timeout) {
        this.cache.setCacheEntryTimeout(timeout);
        return this;
    }

    @Override
    public StaticHandler setIndexPage(String indexPage) {
        Objects.requireNonNull(indexPage);
        this.indexPage = indexPage.charAt(0) == '/' ? indexPage.substring(1) : indexPage;
        return this;
    }

    @Override
    public StaticHandler setAlwaysAsyncFS(boolean alwaysAsyncFS) {
        this.tune.setAlwaysAsyncFS(alwaysAsyncFS);
        return this;
    }

    @Override
    public StaticHandler setHttp2PushMapping(List<Http2PushMapping> http2PushMap) {
        if (http2PushMap != null) {
            this.http2PushMappings = new ArrayList<Http2PushMapping>(http2PushMap);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForMediaTypes(Set<String> mediaTypes) {
        if (mediaTypes != null) {
            this.compressedMediaTypes = new HashSet<String>(mediaTypes);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForSuffixes(Set<String> fileSuffixes) {
        if (fileSuffixes != null) {
            this.compressedFileSuffixes = new HashSet<String>(fileSuffixes);
        }
        return this;
    }

    @Override
    public synchronized StaticHandler setEnableFSTuning(boolean enableFSTuning) {
        this.tune.setEnabled(enableFSTuning);
        return this;
    }

    @Override
    public StaticHandler setMaxAvgServeTimeNs(long maxAvgServeTimeNanoSeconds) {
        this.tune.maxAvgServeTimeNanoSeconds = maxAvgServeTimeNanoSeconds;
        return this;
    }

    @Override
    public StaticHandler setSendVaryHeader(boolean sendVaryHeader) {
        this.sendVaryHeader = sendVaryHeader;
        return this;
    }

    @Override
    public StaticHandler setDefaultContentEncoding(String contentEncoding) {
        this.defaultContentEncoding = contentEncoding;
        return this;
    }

    private String getFile(String path, RoutingContext context) {
        String file = this.webRoot + Utils.pathOffset(path, context);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("File to serve is " + file));
        }
        return file;
    }

    private void setRoot(String webRoot) {
        Objects.requireNonNull(webRoot);
        if (!this.allowRootFileSystemAccess) {
            for (File root : File.listRoots()) {
                if (!webRoot.startsWith(root.getAbsolutePath())) continue;
                throw new IllegalArgumentException("root cannot start with '" + root.getAbsolutePath() + "'");
            }
        }
        this.webRoot = webRoot;
    }

    private void sendDirectoryListing(FileSystem fileSystem, String dir, RoutingContext context) {
        HttpServerResponse response = context.response();
        fileSystem.readDir(dir).onFailure(err -> {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.fail((Throwable)err);
        }).onSuccess(list -> {
            MIMEHeader header;
            List<MIMEHeader> accepts = context.parsedHeaders().accept();
            Object accept = "text/plain";
            if (accepts != null && (header = context.parsedHeaders().findBestUserAcceptedIn(context.parsedHeaders().accept(), DIRECTORY_LISTING_ACCEPT)) != null) {
                accept = header.component() + "/" + header.subComponent();
            }
            switch (accept) {
                case "text/html": {
                    Object normalizedDir = context.normalizedPath();
                    if (!((String)normalizedDir).endsWith("/")) {
                        normalizedDir = (String)normalizedDir + "/";
                    }
                    StringBuilder files = new StringBuilder("<ul id=\"files\">");
                    Collections.sort(list);
                    for (String s : list) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        files.append("<li><a href=\"");
                        files.append((String)normalizedDir);
                        files.append(file);
                        files.append("\" title=\"");
                        files.append(file);
                        files.append("\">");
                        files.append(file);
                        files.append("</a></li>");
                    }
                    files.append("</ul>");
                    int slashPos = 0;
                    for (int i = ((String)normalizedDir).length() - 2; i > 0; --i) {
                        if (((String)normalizedDir).charAt(i) != '/') continue;
                        slashPos = i;
                        break;
                    }
                    String parent = "<a href=\"" + ((String)normalizedDir).substring(0, slashPos + 1) + "\">..</a>";
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html").end(this.directoryTemplate(fileSystem).replace("{directory}", (CharSequence)normalizedDir).replace("{parent}", parent).replace("{files}", files.toString()));
                    break;
                }
                case "application/json": {
                    JsonArray json = new JsonArray();
                    for (String s : list) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        json.add((Object)file);
                    }
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.encode());
                    break;
                }
                default: {
                    StringBuilder buffer = new StringBuilder();
                    for (String s : list) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        buffer.append(file);
                        buffer.append('\n');
                    }
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain").end(buffer.toString());
                }
            }
        });
    }

    private String getFileExtension(String file) {
        int li = file.lastIndexOf(46);
        if (li != -1 && li != file.length() - 1) {
            return file.substring(li + 1);
        }
        return null;
    }

    private /* synthetic */ void lambda$sendStatic$3(String path, RoutingContext context, FileSystem fileSystem, String localFile, boolean dirty, boolean index, Boolean exists) {
        if (!exists.booleanValue()) {
            if (this.cache.enabled()) {
                this.cache.put(path, null);
            }
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.next();
            return;
        }
        this.getFileProps(fileSystem, localFile).onSuccess(fprops -> {
            if (fprops == null) {
                if (dirty) {
                    this.cache.remove(path);
                }
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.next();
            } else if (fprops.isDirectory()) {
                if (index) {
                    if (this.cache.enabled()) {
                        this.cache.put(path, null);
                    }
                    if (!context.request().isEnded()) {
                        context.request().resume();
                    }
                    context.next();
                } else {
                    if (dirty) {
                        this.cache.remove(path);
                    }
                    this.sendDirectory(context, fileSystem, path, localFile);
                }
            } else {
                if (this.cache.enabled()) {
                    this.cache.put(path, (FileProps)fprops);
                    if (Utils.fresh(context, Utils.secondsFactor(fprops.lastModifiedTime()))) {
                        context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                        return;
                    }
                }
                this.sendFile(context, fileSystem, localFile, (FileProps)fprops);
            }
        }).onFailure(err -> {
            if (!context.request().isEnded()) {
                context.request().resume();
            }
            context.fail((Throwable)err);
        });
    }

    private static class FSPropsCache {
        private Map<String, CacheEntry> propsCache;
        private long cacheEntryTimeout = 30000L;
        private int maxCacheSize = 10000;

        FSPropsCache() {
            this.setEnabled(StaticHandler.DEFAULT_CACHING_ENABLED);
        }

        boolean enabled() {
            return this.propsCache != null;
        }

        synchronized void setMaxSize(int maxCacheSize) {
            if (maxCacheSize < 1) {
                throw new IllegalArgumentException("maxCacheSize must be >= 1");
            }
            if (this.maxCacheSize != maxCacheSize) {
                this.maxCacheSize = maxCacheSize;
                this.setEnabled(this.enabled(), true);
            }
        }

        void setEnabled(boolean enable) {
            this.setEnabled(enable, false);
        }

        private synchronized void setEnabled(boolean enable, boolean force) {
            if (force || enable != this.enabled()) {
                if (this.propsCache != null) {
                    this.propsCache.clear();
                }
                this.propsCache = enable ? new LRUCache<String, CacheEntry>(this.maxCacheSize) : null;
            }
        }

        void setCacheEntryTimeout(long timeout) {
            if (timeout < 1L) {
                throw new IllegalArgumentException("timeout must be >= 1");
            }
            this.cacheEntryTimeout = timeout;
        }

        private void remove(String path) {
            if (this.propsCache != null) {
                this.propsCache.remove(path);
            }
        }

        CacheEntry get(String key) {
            if (this.propsCache != null) {
                return this.propsCache.get(key);
            }
            return null;
        }

        void put(String path, FileProps props) {
            if (this.propsCache != null) {
                CacheEntry now = new CacheEntry(props, this.cacheEntryTimeout);
                this.propsCache.put(path, now);
            }
        }
    }

    private static class FSTune {
        private static final int NUM_SERVES_TUNING_FS_ACCESS = 1000;
        private volatile boolean enabled = true;
        private volatile boolean useAsyncFS;
        private long totalTime;
        private long numServesBlocking;
        private long nextAvgCheck = 1000L;
        private long maxAvgServeTimeNanoSeconds = 1000000L;
        private boolean alwaysAsyncFS = false;

        private FSTune() {
        }

        boolean enabled() {
            return this.enabled;
        }

        boolean useAsyncFS() {
            return this.alwaysAsyncFS || this.useAsyncFS;
        }

        synchronized void setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (!enabled) {
                this.reset();
            }
        }

        void setAlwaysAsyncFS(boolean alwaysAsyncFS) {
            this.alwaysAsyncFS = alwaysAsyncFS;
        }

        synchronized void update(long start, long end) {
            long dur = end - start;
            this.totalTime += dur;
            ++this.numServesBlocking;
            if (this.numServesBlocking == Long.MAX_VALUE) {
                this.reset();
            } else if (this.numServesBlocking == this.nextAvgCheck) {
                double avg = (double)this.totalTime / (double)this.numServesBlocking;
                if (avg > (double)this.maxAvgServeTimeNanoSeconds) {
                    this.useAsyncFS = true;
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Switching to async file system access in static file server as fs access is slow! (Average access time of " + avg + " ns)"));
                    }
                    this.enabled = false;
                }
                this.nextAvgCheck += 1000L;
            }
        }

        synchronized void reset() {
            this.nextAvgCheck = 1000L;
            this.totalTime = 0L;
            this.numServesBlocking = 0L;
        }
    }

    private static final class CacheEntry {
        final long createDate = System.currentTimeMillis();
        final FileProps props;
        final long cacheEntryTimeout;

        private CacheEntry(FileProps props, long cacheEntryTimeout) {
            this.props = props;
            this.cacheEntryTimeout = cacheEntryTimeout;
        }

        boolean isOutOfDate() {
            return System.currentTimeMillis() - this.createDate > this.cacheEntryTimeout;
        }

        public boolean isMissing() {
            return this.props == null;
        }
    }
}

