/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.impl.ClusteredSessionStoreImpl;
import io.vertx.ext.web.sstore.impl.LocalSessionStoreImpl;
import java.util.Iterator;
import java.util.ServiceLoader;

@VertxGen
public interface SessionStore {
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public static SessionStore create(Vertx vertx) {
        return SessionStore.create(vertx, new JsonObject());
    }

    public static SessionStore create(Vertx vertx, JsonObject options) {
        SessionStore defaultStore = null;
        try {
            ServiceLoader<SessionStore> loader = ServiceLoader.load(SessionStore.class);
            Iterator<SessionStore> it = loader.iterator();
            if (it.hasNext()) {
                defaultStore = it.next();
            }
            if (defaultStore != null) {
                return defaultStore.init(vertx, options);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        defaultStore = vertx.isClustered() ? new ClusteredSessionStoreImpl() : new LocalSessionStoreImpl();
        return defaultStore.init(vertx, options);
    }

    @Fluent
    public SessionStore init(Vertx var1, JsonObject var2);

    public long retryTimeout();

    public Session createSession(long var1);

    public Session createSession(long var1, int var3);

    public Future<@Nullable Session> get(String var1);

    public Future<Void> delete(String var1);

    public Future<Void> put(Session var1);

    public Future<Void> clear();

    public Future<Integer> size();

    public void close();
}

