/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.Tracing;
import brave.http.HttpTracing;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.zipkin.ZipkinTracer;
import io.vertx.tracing.zipkin.ZipkinTracingOptions;
import zipkin2.reporter.Sender;

public class ZipkinTracerFactory
implements VertxTracerFactory {
    static final ZipkinTracerFactory INSTANCE = new ZipkinTracerFactory();
    private final HttpTracing httpTracing;
    private final Sender sender;

    public ZipkinTracerFactory() {
        this.httpTracing = null;
        this.sender = null;
    }

    public ZipkinTracerFactory(Tracing tracing) {
        this(tracing, null);
    }

    public ZipkinTracerFactory(Tracing tracing, Sender sender) {
        this.httpTracing = HttpTracing.newBuilder((Tracing)tracing).build();
        this.sender = sender;
    }

    public ZipkinTracerFactory(HttpTracing httpTracing) {
        this(httpTracing, null);
    }

    public ZipkinTracerFactory(HttpTracing httpTracing, Sender sender) {
        this.httpTracing = httpTracing;
        this.sender = sender;
    }

    public ZipkinTracer tracer(TracingOptions options) {
        if (this.httpTracing != null) {
            return new ZipkinTracer(false, this.httpTracing, this.sender);
        }
        ZipkinTracingOptions zipkinOptions = options instanceof ZipkinTracingOptions ? (ZipkinTracingOptions)options : new ZipkinTracingOptions(options.toJson());
        return zipkinOptions.buildTracer();
    }

    public TracingOptions newOptions() {
        return new ZipkinTracingOptions();
    }

    public TracingOptions newOptions(JsonObject jsonObject) {
        return new ZipkinTracingOptions(jsonObject);
    }
}

