/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.sampler.Sampler;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.zipkin.HttpSenderOptions;
import io.vertx.tracing.zipkin.VertxSender;
import io.vertx.tracing.zipkin.ZipkinTracer;
import io.vertx.tracing.zipkin.ZipkinTracerFactory;
import io.vertx.tracing.zipkin.ZipkinTracingOptionsConverter;
import java.util.Map;
import java.util.Objects;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;

@DataObject
@JsonGen(publicConverter=false)
public class ZipkinTracingOptions
extends TracingOptions {
    public static final String DEFAULT_SERVICE_NAME = "a-service";
    public static final boolean DEFAULT_SUPPORTS_JOIN = true;
    private String serviceName = "a-service";
    private Sampler sampler = Sampler.ALWAYS_SAMPLE;
    private boolean supportsJoin = true;
    private HttpSenderOptions senderOptions = new HttpSenderOptions();
    private HttpTracing httpTracing;

    @Deprecated
    public ZipkinTracingOptions(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.setFactory(ZipkinTracerFactory.INSTANCE);
    }

    @Deprecated
    public ZipkinTracingOptions(Tracing tracing) {
        this.httpTracing = HttpTracing.newBuilder((Tracing)tracing).build();
        this.setFactory(ZipkinTracerFactory.INSTANCE);
    }

    public ZipkinTracingOptions() {
        this.setFactory(ZipkinTracerFactory.INSTANCE);
    }

    public ZipkinTracingOptions(ZipkinTracingOptions other) {
        this.serviceName = other.serviceName;
        this.sampler = other.sampler;
        this.supportsJoin = other.supportsJoin;
        this.senderOptions = other.senderOptions == null ? null : new HttpSenderOptions(other.senderOptions);
        this.httpTracing = other.httpTracing == null ? null : other.httpTracing.toBuilder().build();
        this.setFactory(ZipkinTracerFactory.INSTANCE);
    }

    public ZipkinTracingOptions(JsonObject json) {
        super(json);
        ZipkinTracingOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.setFactory(ZipkinTracerFactory.INSTANCE);
    }

    public ZipkinTracingOptions copy() {
        return new ZipkinTracingOptions(this);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ZipkinTracingOptions setServiceName(String serviceName) {
        Objects.requireNonNull(serviceName, "Service name cannot be null");
        this.serviceName = serviceName;
        return this;
    }

    public boolean isSupportsJoin() {
        return this.supportsJoin;
    }

    public ZipkinTracingOptions setSupportsJoin(boolean supportsJoin) {
        this.supportsJoin = supportsJoin;
        return this;
    }

    public HttpSenderOptions getSenderOptions() {
        return this.senderOptions;
    }

    public ZipkinTracingOptions setSenderOptions(HttpSenderOptions senderOptions) {
        this.senderOptions = senderOptions;
        return this;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public ZipkinTracingOptions setSampler(Sampler sampler) {
        this.sampler = sampler;
        return this;
    }

    public ZipkinTracer buildTracer() {
        if (this.httpTracing != null) {
            return new ZipkinTracer(false, this.httpTracing, null);
        }
        if (this.senderOptions != null) {
            String localServiceName = this.serviceName;
            VertxSender sender = new VertxSender(this.senderOptions);
            Tracing tracing = Tracing.newBuilder().supportsJoin(this.supportsJoin).localServiceName(localServiceName).spanReporter((Reporter)AsyncReporter.builder((Sender)sender).build()).sampler(this.sampler).build();
            return new ZipkinTracer(true, tracing, sender);
        }
        return null;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ZipkinTracingOptionsConverter.toJson(this, json);
        return json;
    }
}

