/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.tracing.zipkin.HttpSenderOptionsConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class HttpSenderOptions
extends HttpClientOptions {
    public static final String DEFAULT_SENDER_ENDPOINT = "http://localhost:9411/api/v2/spans";
    private String senderEndpoint;

    public HttpSenderOptions() {
        this.init();
    }

    private void init() {
        this.senderEndpoint = DEFAULT_SENDER_ENDPOINT;
        this.setDecompressionSupported(true);
    }

    public HttpSenderOptions(HttpSenderOptions other) {
        super((HttpClientOptions)other);
        this.init();
        this.senderEndpoint = other.senderEndpoint;
    }

    public HttpSenderOptions(JsonObject json) {
        super(json);
        this.init();
        HttpSenderOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getSenderEndpoint() {
        return this.senderEndpoint;
    }

    public HttpSenderOptions setSenderEndpoint(String endpoint) {
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            throw new IllegalArgumentException("Sender endpoint must be an absolute URL");
        }
        this.senderEndpoint = endpoint;
        return this;
    }

    public HttpSenderOptions setSendBufferSize(int sendBufferSize) {
        return (HttpSenderOptions)super.setSendBufferSize(sendBufferSize);
    }

    public HttpSenderOptions setReceiveBufferSize(int receiveBufferSize) {
        return (HttpSenderOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public HttpSenderOptions setReuseAddress(boolean reuseAddress) {
        return (HttpSenderOptions)super.setReuseAddress(reuseAddress);
    }

    public HttpSenderOptions setReusePort(boolean reusePort) {
        return (HttpSenderOptions)super.setReusePort(reusePort);
    }

    public HttpSenderOptions setTrafficClass(int trafficClass) {
        return (HttpSenderOptions)super.setTrafficClass(trafficClass);
    }

    public HttpSenderOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (HttpSenderOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public HttpSenderOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (HttpSenderOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public HttpSenderOptions setSoLinger(int soLinger) {
        return (HttpSenderOptions)super.setSoLinger(soLinger);
    }

    public HttpSenderOptions setIdleTimeout(int idleTimeout) {
        return (HttpSenderOptions)super.setIdleTimeout(idleTimeout);
    }

    public HttpSenderOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return (HttpSenderOptions)super.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    public HttpSenderOptions setSsl(boolean ssl) {
        return (HttpSenderOptions)super.setSsl(ssl);
    }

    public HttpSenderOptions setKeyCertOptions(KeyCertOptions options) {
        return (HttpSenderOptions)super.setKeyCertOptions(options);
    }

    public HttpSenderOptions setTrustOptions(TrustOptions options) {
        return (HttpSenderOptions)super.setTrustOptions(options);
    }

    public HttpSenderOptions addEnabledCipherSuite(String suite) {
        return (HttpSenderOptions)super.addEnabledCipherSuite(suite);
    }

    public HttpSenderOptions addEnabledSecureTransportProtocol(String protocol) {
        return (HttpSenderOptions)super.addEnabledSecureTransportProtocol(protocol);
    }

    public HttpSenderOptions removeEnabledSecureTransportProtocol(String protocol) {
        return (HttpSenderOptions)super.removeEnabledSecureTransportProtocol(protocol);
    }

    public HttpSenderOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (HttpSenderOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    public HttpSenderOptions setTcpCork(boolean tcpCork) {
        return (HttpSenderOptions)super.setTcpCork(tcpCork);
    }

    public HttpSenderOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (HttpSenderOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    public HttpSenderOptions addCrlPath(String crlPath) throws NullPointerException {
        return (HttpSenderOptions)super.addCrlPath(crlPath);
    }

    public HttpSenderOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (HttpSenderOptions)super.addCrlValue(crlValue);
    }

    public HttpSenderOptions setConnectTimeout(int connectTimeout) {
        return (HttpSenderOptions)super.setConnectTimeout(connectTimeout);
    }

    public HttpSenderOptions setTrustAll(boolean trustAll) {
        return (HttpSenderOptions)super.setTrustAll(trustAll);
    }

    public HttpSenderOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (HttpSenderOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    public HttpSenderOptions setHttp2MultiplexingLimit(int limit) {
        return (HttpSenderOptions)super.setHttp2MultiplexingLimit(limit);
    }

    public HttpSenderOptions setHttp2ConnectionWindowSize(int http2ConnectionWindowSize) {
        return (HttpSenderOptions)super.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
    }

    public HttpSenderOptions setHttp2KeepAliveTimeout(int keepAliveTimeout) {
        return (HttpSenderOptions)super.setHttp2KeepAliveTimeout(keepAliveTimeout);
    }

    public HttpSenderOptions setKeepAlive(boolean keepAlive) {
        return (HttpSenderOptions)super.setKeepAlive(keepAlive);
    }

    public HttpSenderOptions setKeepAliveTimeout(int keepAliveTimeout) {
        return (HttpSenderOptions)super.setKeepAliveTimeout(keepAliveTimeout);
    }

    public HttpSenderOptions setPipelining(boolean pipelining) {
        return (HttpSenderOptions)super.setPipelining(pipelining);
    }

    public HttpSenderOptions setPipeliningLimit(int limit) {
        return (HttpSenderOptions)super.setPipeliningLimit(limit);
    }

    public HttpSenderOptions setVerifyHost(boolean verifyHost) {
        return (HttpSenderOptions)super.setVerifyHost(verifyHost);
    }

    public HttpSenderOptions setDecompressionSupported(boolean decompressionSupported) {
        return (HttpSenderOptions)super.setDecompressionSupported(decompressionSupported);
    }

    public HttpSenderOptions setDefaultHost(String defaultHost) {
        return (HttpSenderOptions)super.setDefaultHost(defaultHost);
    }

    public HttpSenderOptions setDefaultPort(int defaultPort) {
        return (HttpSenderOptions)super.setDefaultPort(defaultPort);
    }

    public HttpSenderOptions setProtocolVersion(HttpVersion protocolVersion) {
        return (HttpSenderOptions)super.setProtocolVersion(protocolVersion);
    }

    public HttpSenderOptions setMaxChunkSize(int maxChunkSize) {
        return (HttpSenderOptions)super.setMaxChunkSize(maxChunkSize);
    }

    public HttpSenderOptions setMaxInitialLineLength(int maxInitialLineLength) {
        return (HttpSenderOptions)super.setMaxInitialLineLength(maxInitialLineLength);
    }

    public HttpSenderOptions setMaxHeaderSize(int maxHeaderSize) {
        return (HttpSenderOptions)super.setMaxHeaderSize(maxHeaderSize);
    }

    public HttpSenderOptions setInitialSettings(Http2Settings settings) {
        return (HttpSenderOptions)super.setInitialSettings(settings);
    }

    public HttpSenderOptions setUseAlpn(boolean useAlpn) {
        return (HttpSenderOptions)super.setUseAlpn(useAlpn);
    }

    public HttpSenderOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (HttpSenderOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    public HttpSenderOptions setAlpnVersions(List<HttpVersion> alpnVersions) {
        return (HttpSenderOptions)super.setAlpnVersions(alpnVersions);
    }

    public HttpSenderOptions setHttp2ClearTextUpgrade(boolean value) {
        return (HttpSenderOptions)super.setHttp2ClearTextUpgrade(value);
    }

    public HttpSenderOptions setMaxRedirects(int maxRedirects) {
        return (HttpSenderOptions)super.setMaxRedirects(maxRedirects);
    }

    public HttpSenderOptions setForceSni(boolean forceSni) {
        return (HttpSenderOptions)super.setForceSni(forceSni);
    }

    public HttpSenderOptions setMetricsName(String metricsName) {
        return (HttpSenderOptions)super.setMetricsName(metricsName);
    }

    public HttpSenderOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (HttpSenderOptions)super.setProxyOptions(proxyOptions);
    }

    public HttpSenderOptions setLocalAddress(String localAddress) {
        return (HttpSenderOptions)super.setLocalAddress(localAddress);
    }

    public HttpSenderOptions setLogActivity(boolean logEnabled) {
        return (HttpSenderOptions)super.setLogActivity(logEnabled);
    }

    public HttpSenderOptions setDecoderInitialBufferSize(int decoderInitialBufferSize) {
        return (HttpSenderOptions)super.setDecoderInitialBufferSize(decoderInitialBufferSize);
    }
}

