/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.tracing.zipkin.HttpSenderOptions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import zipkin2.reporter.BaseHttpSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSuppliers;

public class VertxSender
extends BaseHttpSender<RequestOptions, Buffer> {
    private static final CharSequence APPLICATION_JSON = HttpHeaders.createOptimized((String)"application/json");
    private final int messageMaxBytes = 0x500000;
    private final Vertx vertx;
    private final HttpClient client;
    private final HttpSenderOptions options;
    private final String endpoint;

    public VertxSender(HttpSenderOptions options) {
        super(Encoding.JSON, HttpEndpointSuppliers.constantFactory(), options.getSenderEndpoint());
        this.options = new HttpSenderOptions(options);
        this.endpoint = options.getSenderEndpoint();
        this.vertx = Vertx.builder().withTracer(VertxTracerFactory.NOOP).build();
        this.client = this.vertx.createHttpClient((HttpClientOptions)options);
    }

    public HttpSenderOptions options() {
        return this.options;
    }

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        int val = 2;
        int length = encodedSpans.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ++val;
            }
            val += encodedSpans.get(i).length;
        }
        return val;
    }

    protected RequestOptions newEndpoint(String endpoint) {
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.POST).addHeader(HttpHeaders.CONTENT_TYPE, APPLICATION_JSON);
        if (endpoint.startsWith("http://") || endpoint.startsWith("https://")) {
            options.setAbsoluteURI(endpoint);
        } else {
            options.setURI(endpoint);
        }
        return options;
    }

    protected Buffer newBody(List<byte[]> encodedSpans) {
        int capacity = this.messageSizeInBytes(encodedSpans);
        Buffer body = Buffer.buffer((int)capacity);
        body.appendByte((byte)91);
        for (int i = 0; i < encodedSpans.size(); ++i) {
            if (i > 0) {
                body.appendByte((byte)44);
            }
            body.appendBytes(encodedSpans.get(i));
        }
        body.appendByte((byte)93);
        return body;
    }

    protected void postSpans(RequestOptions requestOptions, Buffer body) throws IOException {
        try {
            this.client.request(requestOptions).compose(req -> req.send(body).compose(HttpClientResponse::body)).await(20L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }

    public void doClose() {
        this.client.close();
        this.vertx.close();
    }
}

