/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.vertx.core.Context;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.tracing.zipkin.VertxSender;
import io.vertx.tracing.zipkin.ZipkinTracerFactory;
import io.vertx.tracing.zipkin.impl.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZipkinTracer
implements VertxTracer<Span, BiConsumer<Object, Throwable>> {
    private static final Propagation.Getter<Map<String, String>, String> MAP_GETTER = Map::get;
    private final Tracing tracing;
    private final boolean closeTracer;
    private final VertxSender sender;
    private final HttpServerHandler<brave.http.HttpServerRequest, brave.http.HttpServerResponse> httpServerHandler;
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler;
    private final TraceContext.Extractor<Map<String, String>> mapExtractor;
    private static final Pattern P = Pattern.compile("^([^:]+):([0-9]+)$");

    public VertxSender sender() {
        return this.sender;
    }

    public static Span activeSpan() {
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            return (Span)ctx.getLocal(ZipkinTracerFactory.ACTIVE_SPAN);
        }
        return null;
    }

    public static TraceContext activeContext() {
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            return (TraceContext)ctx.getLocal(ZipkinTracerFactory.ACTIVE_CONTEXT);
        }
        return null;
    }

    public ZipkinTracer(boolean closeTracer, Tracing tracing, VertxSender sender) {
        this(closeTracer, HttpTracing.newBuilder((Tracing)tracing).build(), sender);
    }

    public ZipkinTracer(boolean closeTracer, HttpTracing httpTracing, VertxSender sender) {
        this.closeTracer = closeTracer;
        this.tracing = httpTracing.tracing();
        this.clientHandler = HttpClientHandler.create((HttpTracing)httpTracing);
        this.httpServerHandler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.mapExtractor = this.tracing.propagation().extractor(MAP_GETTER);
        this.sender = sender;
    }

    public Tracing getTracing() {
        return this.tracing;
    }

    public <R> Span receiveRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        Span span;
        if (policy == TracingPolicy.IGNORE) {
            return null;
        }
        ContextInternal ctx = (ContextInternal)context;
        if (request instanceof HttpServerRequest) {
            HttpServerRequest httpReq = (HttpServerRequest)request;
            String traceId = httpReq.getHeader("X-B3-TraceId");
            if (traceId == null && policy == TracingPolicy.PROPAGATE) {
                return null;
            }
            span = this.httpServerHandler.handleReceive((brave.http.HttpServerRequest)new HttpServerRequestAdapter(httpReq));
            ctx.putLocal(ZipkinTracerFactory.ACTIVE_REQUEST, AccessMode.CONCURRENT, (Object)httpReq);
        } else {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Map.Entry<String, String> header : headers) {
                headerMap.put(header.getKey(), header.getValue());
            }
            TraceContextOrSamplingFlags extracted = this.mapExtractor.extract(headerMap);
            if (extracted.context() != null) {
                span = this.tracing.tracer().joinSpan(extracted.context());
            } else if (policy == TracingPolicy.ALWAYS) {
                span = this.tracing.tracer().newTrace();
                span.start();
            } else {
                return null;
            }
            span.kind(kind == SpanKind.RPC ? Span.Kind.SERVER : Span.Kind.CONSUMER);
            span.name(operation);
            ZipkinTracer.reportTags(request, tagExtractor, span);
        }
        ctx.putLocal(ZipkinTracerFactory.ACTIVE_SPAN, AccessMode.CONCURRENT, (Object)span);
        ctx.putLocal(ZipkinTracerFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT, (Object)span.context());
        return span;
    }

    public <R> void sendResponse(Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            ContextInternal ctx = (ContextInternal)context;
            ctx.removeLocal(ZipkinTracerFactory.ACTIVE_SPAN, AccessMode.CONCURRENT);
            if (response instanceof HttpServerResponse) {
                this.httpServerHandler.handleSend((brave.http.HttpServerResponse)new HttpServerResponseAdapter((HttpServerRequest)ctx.getLocal(ZipkinTracerFactory.ACTIVE_REQUEST), (HttpServerResponse)response, failure), span);
                ctx.removeLocal(ZipkinTracerFactory.ACTIVE_REQUEST, AccessMode.CONCURRENT);
            } else {
                span.finish();
            }
        }
    }

    public <R> BiConsumer<Object, Throwable> sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        Span span;
        if (policy == TracingPolicy.IGNORE) {
            return null;
        }
        TraceContext activeCtx = (TraceContext)((ContextInternal)context).getLocal(ZipkinTracerFactory.ACTIVE_CONTEXT);
        if (activeCtx == null) {
            if (policy != TracingPolicy.ALWAYS) {
                return null;
            }
            span = this.tracing.tracer().newTrace();
        } else {
            span = this.tracing.tracer().newChild(activeCtx);
            span.start();
        }
        if (request instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)request;
            SocketAddress socketAddress = httpRequest.remoteAddress();
            if (socketAddress != null && socketAddress.hostAddress() != null) {
                span.remoteIpAndPort(socketAddress.hostAddress(), socketAddress.port());
            }
            HttpClientRequestAdapter clientRequestAdapter = new HttpClientRequestAdapter(httpRequest, headers);
            this.clientHandler.handleSend((HttpClientRequest)clientRequestAdapter, span);
            return (resp, err) -> this.clientHandler.handleReceive((HttpClientResponse)new HttpClientResponseAdapter(clientRequestAdapter, (HttpResponse)resp, (Throwable)err), span);
        }
        span.kind(kind == SpanKind.RPC ? Span.Kind.CLIENT : Span.Kind.PRODUCER);
        span.name(operation);
        ZipkinTracer.reportTags(request, tagExtractor, span);
        TraceContext.Injector injector = this.tracing.propagation().injector(BiConsumer::accept);
        injector.inject(span.context(), headers);
        return (resp, err) -> {
            if (err != null) {
                span.error(err);
            }
            span.finish();
        };
    }

    private static <R> void reportTags(R request, TagExtractor<R> tagExtractor, Span span) {
        int len = tagExtractor.len(request);
        block11: for (int i = 0; i < len; ++i) {
            String name = tagExtractor.name(request, i);
            String value = tagExtractor.value(request, i);
            switch (name) {
                case "db.query.text": {
                    span.tag("sql.query", value);
                    continue block11;
                }
                case "db.namespace": 
                case "messaging.destination.name": {
                    span.remoteServiceName(value);
                    continue block11;
                }
                case "network.peer.address": {
                    Matcher matcher = P.matcher(value);
                    if (!matcher.matches()) continue block11;
                    String host = matcher.group(1);
                    int port = Integer.parseInt(matcher.group(2));
                    span.remoteIpAndPort(host, port);
                }
            }
        }
    }

    public <R> void receiveResponse(Context context, R response, BiConsumer<Object, Throwable> payload, Throwable failure, TagExtractor<R> tagExtractor) {
        if (payload != null) {
            payload.accept(response, failure);
        }
    }

    public void close() {
        if (this.closeTracer) {
            this.tracing.close();
        }
        if (this.sender != null) {
            this.sender.close();
        }
    }

    public static void clearContext() {
        ContextInternal c = ContextInternal.current();
        if (c != null) {
            c.removeLocal(ZipkinTracerFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT);
        }
    }

    public static void clearSpan() {
        ContextInternal c = ContextInternal.current();
        if (c != null) {
            c.removeLocal(ZipkinTracerFactory.ACTIVE_SPAN, AccessMode.CONCURRENT);
        }
    }

    public static void importTraceId(String traceId) {
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            ctx.putLocal(ZipkinTracerFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT, (Object)B3SingleFormat.parseB3SingleFormat((CharSequence)traceId).context());
        }
    }

    public static String exportTraceId() {
        TraceContext ctx = ZipkinTracer.activeContext();
        if (ctx != null) {
            return B3SingleFormat.writeB3SingleFormat((TraceContext)ctx);
        }
        return null;
    }

    public static void setTraceContext(TraceContext context) {
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            ctx.putLocal(ZipkinTracerFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT, (Object)context);
        }
    }

    public static void setSpan(Span span) {
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            ctx.putLocal(ZipkinTracerFactory.ACTIVE_SPAN, AccessMode.CONCURRENT, (Object)span);
        }
    }

    private static class HttpClientResponseAdapter
    extends HttpClientResponse {
        final HttpClientRequest request;
        final HttpResponse response;
        final Throwable err;

        public HttpClientResponseAdapter(HttpClientRequest request, HttpResponse response, Throwable err) {
            this.request = request;
            this.response = response;
            this.err = err;
        }

        public HttpClientRequest request() {
            return this.request;
        }

        public int statusCode() {
            return this.response.statusCode();
        }

        public Throwable error() {
            return this.err;
        }

        public Object unwrap() {
            return this.response;
        }
    }

    private static class HttpClientRequestAdapter
    extends HttpClientRequest {
        final HttpRequest request;
        final BiConsumer<String, String> headers;

        HttpClientRequestAdapter(HttpRequest request, BiConsumer<String, String> headers) {
            this.request = request;
            this.headers = headers;
        }

        public String method() {
            return this.request.method().name();
        }

        public String url() {
            return this.request.absoluteURI();
        }

        public String path() {
            return HttpUtils.parsePath(this.request.uri());
        }

        public String header(String name) {
            return this.request.headers().get(name);
        }

        public void header(String name, String value) {
            this.headers.accept(name, value);
        }

        public Object unwrap() {
            return this.request;
        }
    }

    private static class HttpServerResponseAdapter
    extends brave.http.HttpServerResponse {
        final HttpServerRequest request;
        final HttpServerResponse response;
        final Throwable error;

        HttpServerResponseAdapter(HttpServerRequest request, HttpServerResponse response, Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public brave.http.HttpServerRequest request() {
            return new HttpServerRequestAdapter(this.request);
        }

        public String method() {
            return this.request.method().name();
        }

        public int statusCode() {
            return this.response.getStatusCode();
        }

        public Throwable error() {
            return this.error;
        }

        public Object unwrap() {
            return this.response;
        }
    }

    private static class HttpServerRequestAdapter
    extends brave.http.HttpServerRequest {
        final HttpServerRequest request;

        HttpServerRequestAdapter(HttpServerRequest request) {
            this.request = request;
        }

        public String method() {
            return this.request.method().name();
        }

        public String path() {
            return this.request.path();
        }

        public String url() {
            return this.request.absoluteURI();
        }

        public String header(String name) {
            return this.request.headers().get(name);
        }

        public boolean parseClientIpAndPort(Span span) {
            if (this.parseClientIpFromXForwardedFor(span)) {
                return true;
            }
            SocketAddress addr = this.request.remoteAddress();
            if (addr != null && addr.hostAddress() != null) {
                return span.remoteIpAndPort(addr.hostAddress(), addr.port());
            }
            return false;
        }

        public Object unwrap() {
            return this.request;
        }
    }
}

